/*
 * $Id$
 */

package org.apache.archiva.redback.role.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         model templates specify a role and its corresponding
 *         permissions, child roles and parent roles to link to,
 * however
 *         they are generated at runtime with additional input
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ModelTemplate implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field namePrefix
     */
    private String namePrefix;

    /**
     * Field delimiter
     */
    private String delimiter = " - ";

    /**
     * Field description
     */
    private String description;

    /**
     * Field assignable
     */
    private boolean assignable = false;

    /**
     * Field permanent
     */
    private boolean permanent = false;

    /**
     * Field permanentResource
     */
    private boolean permanentResource = false;

    /**
     * Field permissions
     */
    private java.util.List permissions;

    /**
     * Field parentRoles
     */
    private java.util.List parentRoles;

    /**
     * Field childRoles
     */
    private java.util.List childRoles;

    /**
     * Field parentTemplates
     */
    private java.util.List parentTemplates;

    /**
     * Field childTemplates
     */
    private java.util.List childTemplates;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addChildRole
     * 
     * @param string
     */
    public void addChildRole(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModelTemplate.addChildRoles(string) parameter must be instanceof " + String.class.getName() );
        }
        getChildRoles().add( string );
    } //-- void addChildRole(String) 

    /**
     * Method addChildTemplate
     * 
     * @param string
     */
    public void addChildTemplate(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModelTemplate.addChildTemplates(string) parameter must be instanceof " + String.class.getName() );
        }
        getChildTemplates().add( string );
    } //-- void addChildTemplate(String) 

    /**
     * Method addParentRole
     * 
     * @param string
     */
    public void addParentRole(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModelTemplate.addParentRoles(string) parameter must be instanceof " + String.class.getName() );
        }
        getParentRoles().add( string );
    } //-- void addParentRole(String) 

    /**
     * Method addParentTemplate
     * 
     * @param string
     */
    public void addParentTemplate(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModelTemplate.addParentTemplates(string) parameter must be instanceof " + String.class.getName() );
        }
        getParentTemplates().add( string );
    } //-- void addParentTemplate(String) 

    /**
     * Method addPermission
     * 
     * @param modelPermission
     */
    public void addPermission(ModelPermission modelPermission)
    {
        if ( !(modelPermission instanceof ModelPermission) )
        {
            throw new ClassCastException( "ModelTemplate.addPermissions(modelPermission) parameter must be instanceof " + ModelPermission.class.getName() );
        }
        getPermissions().add( modelPermission );
    } //-- void addPermission(ModelPermission) 

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof ModelTemplate) )
        {
            return false;
        }
        
        ModelTemplate that = (ModelTemplate) other;
        boolean result = true;
        result = result && ( getId() == null ? that.getId() == null : getId().equals( that.getId() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Method getChildRoles
     */
    public java.util.List getChildRoles()
    {
        if ( this.childRoles == null )
        {
            this.childRoles = new java.util.ArrayList();
        }
        
        return this.childRoles;
    } //-- java.util.List getChildRoles() 

    /**
     * Method getChildTemplates
     */
    public java.util.List getChildTemplates()
    {
        if ( this.childTemplates == null )
        {
            this.childTemplates = new java.util.ArrayList();
        }
        
        return this.childTemplates;
    } //-- java.util.List getChildTemplates() 

    /**
     * Get 
     */
    public String getDelimiter()
    {
        return this.delimiter;
    } //-- String getDelimiter() 

    /**
     * Get description of this role
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get null
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     */
    public String getNamePrefix()
    {
        return this.namePrefix;
    } //-- String getNamePrefix() 

    /**
     * Method getParentRoles
     */
    public java.util.List getParentRoles()
    {
        if ( this.parentRoles == null )
        {
            this.parentRoles = new java.util.ArrayList();
        }
        
        return this.parentRoles;
    } //-- java.util.List getParentRoles() 

    /**
     * Method getParentTemplates
     */
    public java.util.List getParentTemplates()
    {
        if ( this.parentTemplates == null )
        {
            this.parentTemplates = new java.util.ArrayList();
        }
        
        return this.parentTemplates;
    } //-- java.util.List getParentTemplates() 

    /**
     * Method getPermissions
     */
    public java.util.List getPermissions()
    {
        if ( this.permissions == null )
        {
            this.permissions = new java.util.ArrayList();
        }
        
        return this.permissions;
    } //-- java.util.List getPermissions() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( id != null ? id.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Get 
     *             boolean specifying if a given role can assigned
     *           
     */
    public boolean isAssignable()
    {
        return this.assignable;
    } //-- boolean isAssignable() 

    /**
     * Get 
     *             boolean specifying if a given role can be
     * removed once
     *             created
     *           
     */
    public boolean isPermanent()
    {
        return this.permanent;
    } //-- boolean isPermanent() 

    /**
     * Get 
     *             boolean specifying if the resource generated
     * with this template can be removed once
     *             created
     *           
     */
    public boolean isPermanentResource()
    {
        return this.permanentResource;
    } //-- boolean isPermanentResource() 

    /**
     * Method removeChildRole
     * 
     * @param string
     */
    public void removeChildRole(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModelTemplate.removeChildRoles(string) parameter must be instanceof " + String.class.getName() );
        }
        getChildRoles().remove( string );
    } //-- void removeChildRole(String) 

    /**
     * Method removeChildTemplate
     * 
     * @param string
     */
    public void removeChildTemplate(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModelTemplate.removeChildTemplates(string) parameter must be instanceof " + String.class.getName() );
        }
        getChildTemplates().remove( string );
    } //-- void removeChildTemplate(String) 

    /**
     * Method removeParentRole
     * 
     * @param string
     */
    public void removeParentRole(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModelTemplate.removeParentRoles(string) parameter must be instanceof " + String.class.getName() );
        }
        getParentRoles().remove( string );
    } //-- void removeParentRole(String) 

    /**
     * Method removeParentTemplate
     * 
     * @param string
     */
    public void removeParentTemplate(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModelTemplate.removeParentTemplates(string) parameter must be instanceof " + String.class.getName() );
        }
        getParentTemplates().remove( string );
    } //-- void removeParentTemplate(String) 

    /**
     * Method removePermission
     * 
     * @param modelPermission
     */
    public void removePermission(ModelPermission modelPermission)
    {
        if ( !(modelPermission instanceof ModelPermission) )
        {
            throw new ClassCastException( "ModelTemplate.removePermissions(modelPermission) parameter must be instanceof " + ModelPermission.class.getName() );
        }
        getPermissions().remove( modelPermission );
    } //-- void removePermission(ModelPermission) 

    /**
     * Set 
     *             boolean specifying if a given role can assigned
     *           
     * 
     * @param assignable
     */
    public void setAssignable(boolean assignable)
    {
        this.assignable = assignable;
    } //-- void setAssignable(boolean) 

    /**
     * Set 
     *             the id of other role profiles to assign as
     * children to this
     *             role, can accept 'foo - ${resource}'
     *           
     * 
     * @param childRoles
     */
    public void setChildRoles(java.util.List childRoles)
    {
        this.childRoles = childRoles;
    } //-- void setChildRoles(java.util.List) 

    /**
     * Set 
     *             the id of other templates to assign as children
     * to this
     *             role, can accept 'foo - ${resource}'
     *           
     * 
     * @param childTemplates
     */
    public void setChildTemplates(java.util.List childTemplates)
    {
        this.childTemplates = childTemplates;
    } //-- void setChildTemplates(java.util.List) 

    /**
     * Set 
     * 
     * @param delimiter
     */
    public void setDelimiter(String delimiter)
    {
        this.delimiter = delimiter;
    } //-- void setDelimiter(String) 

    /**
     * Set description of this role
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set null
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     * 
     * @param namePrefix
     */
    public void setNamePrefix(String namePrefix)
    {
        this.namePrefix = namePrefix;
    } //-- void setNamePrefix(String) 

    /**
     * Set 
     *             the id of other role profiles to have create a
     * child
     *             relationship to this role, can accept 'foo -
     * ${resource}'
     *           
     * 
     * @param parentRoles
     */
    public void setParentRoles(java.util.List parentRoles)
    {
        this.parentRoles = parentRoles;
    } //-- void setParentRoles(java.util.List) 

    /**
     * Set 
     *             the id of other templates to have create a child
     *             relationship to this role, can accept 'foo -
     * ${resource}'
     *           
     * 
     * @param parentTemplates
     */
    public void setParentTemplates(java.util.List parentTemplates)
    {
        this.parentTemplates = parentTemplates;
    } //-- void setParentTemplates(java.util.List) 

    /**
     * Set 
     *             boolean specifying if a given role can be
     * removed once
     *             created
     *           
     * 
     * @param permanent
     */
    public void setPermanent(boolean permanent)
    {
        this.permanent = permanent;
    } //-- void setPermanent(boolean) 

    /**
     * Set 
     *             boolean specifying if the resource generated
     * with this template can be removed once
     *             created
     *           
     * 
     * @param permanentResource
     */
    public void setPermanentResource(boolean permanentResource)
    {
        this.permanentResource = permanentResource;
    } //-- void setPermanentResource(boolean) 

    /**
     * Set null
     * 
     * @param permissions
     */
    public void setPermissions(java.util.List permissions)
    {
        this.permissions = permissions;
    } //-- void setPermissions(java.util.List) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "id = '" );
        buf.append( getId() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
