/*
 * $Id$
 */

package org.apache.archiva.redback.role.model.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.*;
import org.apache.archiva.redback.role.model.ModelApplication;
import org.apache.archiva.redback.role.model.ModelOperation;
import org.apache.archiva.redback.role.model.ModelPermission;
import org.apache.archiva.redback.role.model.ModelResource;
import org.apache.archiva.redback.role.model.ModelRole;
import org.apache.archiva.redback.role.model.ModelTemplate;
import org.apache.archiva.redback.role.model.RedbackRoleModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/**
 * Class RedbackRoleModelStaxReader.
 * 
 * @version $Revision$ $Date$
 */
public class RedbackRoleModelStaxReader {


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method buildDom
     * 
     * @param xmlStreamReader
     */
    public Xpp3Dom buildDom(XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        java.util.List elements = new java.util.ArrayList();
        java.util.List values = new java.util.ArrayList();
        int eventType = xmlStreamReader.getEventType();
        while ( xmlStreamReader.hasNext() )
        {
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                String rawName = xmlStreamReader.getLocalName();
                Xpp3Dom childConfiguration = new Xpp3Dom( rawName );
                int depth = elements.size();
                if ( depth > 0 )
                {
                    Xpp3Dom parent = (Xpp3Dom) elements.get( depth - 1 );
                    parent.addChild( childConfiguration );
                }
                elements.add( childConfiguration );
                if ( xmlStreamReader.isEndElement() )
                {
                    values.add( null );
                }
                else
                {
                    values.add( new StringBuffer() );
                }
                int attributesSize = xmlStreamReader.getAttributeCount();
                for ( int i = 0; i < attributesSize; i++ )
                {
                    String name = xmlStreamReader.getAttributeLocalName( i );
                    String value = xmlStreamReader.getAttributeValue( i );
                    childConfiguration.setAttribute( name, value );
                }
            }
            else if ( eventType == XMLStreamConstants.CHARACTERS )
            {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer) values.get( depth );
                String text = xmlStreamReader.getText();
                text = text.trim();
                valueBuffer.append( text );
            }
            else if ( eventType == XMLStreamConstants.END_ELEMENT )
            {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom) elements.remove( depth );
                // this Object could be null if it is a singleton tag
                Object accumulatedValue = values.remove( depth );
                if ( finishedConfiguration.getChildCount() == 0 )
                {
                    if ( accumulatedValue == null )
                    {
                        finishedConfiguration.setValue( null );
                    }
                    else
                    {
                        finishedConfiguration.setValue( accumulatedValue.toString() );
                    }
                }
                if ( depth == 0 )
                {
                    return finishedConfiguration;
                }
            }
            eventType = xmlStreamReader.next();
        }
        throw new IllegalStateException( "End of document found before returning to 0 depth" );
    } //-- Xpp3Dom buildDom(XMLStreamReader) 

    /**
     * Method getBooleanValue
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     */
    public boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue(String, String, XMLStreamReader) 

    /**
     * Method getCharacterValue
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     */
    public char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue(String, String, XMLStreamReader) 

    /**
     * Method getDateValue
     * 
     * @param s
     * @param xmlStreamReader
     * @param dateFormat
     * @param attribute
     */
    public java.util.Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            if ( dateFormat == null )
            {
                return new java.util.Date( Long.valueOf( s ).longValue() );
            }
            else
            {
                DateFormat dateParser = new java.text.SimpleDateFormat( dateFormat, Locale.US );
                try
                {
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XMLStreamException( e.getMessage() );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue(String, String, String, XMLStreamReader) 

    /**
     * Method getDoubleValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getFloatValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- float getFloatValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getIntegerValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getLongValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- long getLongValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getRequiredAttributeValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XMLStreamException( "Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation() );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getShortValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- short getShortValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getTrimmedValue
     * 
     * @param s
     */
    public String getTrimmedValue(String s)
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue(String) 

    /**
     * Method parseModelApplication
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ModelApplication parseModelApplication(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ModelApplication modelApplication = new ModelApplication();
        modelApplication.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "version" )  )
            {
                if ( parsed.contains( "version" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "version" );
                modelApplication.setVersion( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                modelApplication.setId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                modelApplication.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "longDescription" )  )
            {
                if ( parsed.contains( "longDescription" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "longDescription" );
                modelApplication.setLongDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "resources" )  )
            {
                if ( parsed.contains( "resources" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "resources" );
                java.util.List resources = new java.util.ArrayList();
                modelApplication.setResources( resources );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "resource" ) )
                    {
                        modelApplication.addResource( parseModelResource( "resource", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "operations" )  )
            {
                if ( parsed.contains( "operations" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "operations" );
                java.util.List operations = new java.util.ArrayList();
                modelApplication.setOperations( operations );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "operation" ) )
                    {
                        modelApplication.addOperation( parseModelOperation( "operation", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "roles" )  )
            {
                if ( parsed.contains( "roles" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "roles" );
                java.util.List roles = new java.util.ArrayList();
                modelApplication.setRoles( roles );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "role" ) )
                    {
                        modelApplication.addRole( parseModelRole( "role", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "templates" )  )
            {
                if ( parsed.contains( "templates" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "templates" );
                java.util.List templates = new java.util.ArrayList();
                modelApplication.setTemplates( templates );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "template" ) )
                    {
                        modelApplication.addTemplate( parseModelTemplate( "template", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return modelApplication;
    } //-- ModelApplication parseModelApplication(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseModelOperation
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ModelOperation parseModelOperation(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ModelOperation modelOperation = new ModelOperation();
        modelOperation.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                modelOperation.setId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                modelOperation.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                modelOperation.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanent" )  )
            {
                if ( parsed.contains( "permanent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanent" );
                modelOperation.setPermanent( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanent", xmlStreamReader ) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return modelOperation;
    } //-- ModelOperation parseModelOperation(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseModelPermission
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ModelPermission parseModelPermission(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ModelPermission modelPermission = new ModelPermission();
        modelPermission.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                modelPermission.setId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                modelPermission.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                modelPermission.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanent" )  )
            {
                if ( parsed.contains( "permanent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanent" );
                modelPermission.setPermanent( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanent", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "operation" )  )
            {
                if ( parsed.contains( "operation" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "operation" );
                modelPermission.setOperation( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "resource" )  )
            {
                if ( parsed.contains( "resource" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "resource" );
                modelPermission.setResource( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return modelPermission;
    } //-- ModelPermission parseModelPermission(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseModelResource
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ModelResource parseModelResource(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ModelResource modelResource = new ModelResource();
        modelResource.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                modelResource.setId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                modelResource.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanent" )  )
            {
                if ( parsed.contains( "permanent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanent" );
                modelResource.setPermanent( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanent", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "pattern" )  )
            {
                if ( parsed.contains( "pattern" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "pattern" );
                modelResource.setPattern( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "pattern", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                modelResource.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return modelResource;
    } //-- ModelResource parseModelResource(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseModelRole
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ModelRole parseModelRole(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ModelRole modelRole = new ModelRole();
        modelRole.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                modelRole.setId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                modelRole.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                modelRole.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "assignable" )  )
            {
                if ( parsed.contains( "assignable" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "assignable" );
                modelRole.setAssignable( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "assignable", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanent" )  )
            {
                if ( parsed.contains( "permanent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanent" );
                modelRole.setPermanent( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanent", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permissions" )  )
            {
                if ( parsed.contains( "permissions" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permissions" );
                java.util.List permissions = new java.util.ArrayList();
                modelRole.setPermissions( permissions );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "permission" ) )
                    {
                        modelRole.addPermission( parseModelPermission( "permission", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "parentRoles" )  )
            {
                if ( parsed.contains( "parentRoles" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "parentRoles" );
                java.util.List parentRoles = new java.util.ArrayList();
                modelRole.setParentRoles( parentRoles );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "parentRole" ) )
                    {
                        parentRoles.add( getTrimmedValue( xmlStreamReader.getElementText()) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "childRoles" )  )
            {
                if ( parsed.contains( "childRoles" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "childRoles" );
                java.util.List childRoles = new java.util.ArrayList();
                modelRole.setChildRoles( childRoles );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "childRole" ) )
                    {
                        childRoles.add( getTrimmedValue( xmlStreamReader.getElementText()) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return modelRole;
    } //-- ModelRole parseModelRole(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseModelTemplate
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ModelTemplate parseModelTemplate(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ModelTemplate modelTemplate = new ModelTemplate();
        modelTemplate.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                modelTemplate.setId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "namePrefix" )  )
            {
                if ( parsed.contains( "namePrefix" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "namePrefix" );
                modelTemplate.setNamePrefix( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "delimiter" )  )
            {
                if ( parsed.contains( "delimiter" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "delimiter" );
                modelTemplate.setDelimiter( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                modelTemplate.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "assignable" )  )
            {
                if ( parsed.contains( "assignable" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "assignable" );
                modelTemplate.setAssignable( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "assignable", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanent" )  )
            {
                if ( parsed.contains( "permanent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanent" );
                modelTemplate.setPermanent( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanent", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permanentResource" )  )
            {
                if ( parsed.contains( "permanentResource" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permanentResource" );
                modelTemplate.setPermanentResource( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "permanentResource", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "permissions" )  )
            {
                if ( parsed.contains( "permissions" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "permissions" );
                java.util.List permissions = new java.util.ArrayList();
                modelTemplate.setPermissions( permissions );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "permission" ) )
                    {
                        modelTemplate.addPermission( parseModelPermission( "permission", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "parentRoles" )  )
            {
                if ( parsed.contains( "parentRoles" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "parentRoles" );
                java.util.List parentRoles = new java.util.ArrayList();
                modelTemplate.setParentRoles( parentRoles );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "parentRole" ) )
                    {
                        parentRoles.add( getTrimmedValue( xmlStreamReader.getElementText()) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "childRoles" )  )
            {
                if ( parsed.contains( "childRoles" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "childRoles" );
                java.util.List childRoles = new java.util.ArrayList();
                modelTemplate.setChildRoles( childRoles );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "childRole" ) )
                    {
                        childRoles.add( getTrimmedValue( xmlStreamReader.getElementText()) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "parentTemplates" )  )
            {
                if ( parsed.contains( "parentTemplates" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "parentTemplates" );
                java.util.List parentTemplates = new java.util.ArrayList();
                modelTemplate.setParentTemplates( parentTemplates );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "parentTemplate" ) )
                    {
                        parentTemplates.add( getTrimmedValue( xmlStreamReader.getElementText()) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "childTemplates" )  )
            {
                if ( parsed.contains( "childTemplates" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "childTemplates" );
                java.util.List childTemplates = new java.util.ArrayList();
                modelTemplate.setChildTemplates( childTemplates );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "childTemplate" ) )
                    {
                        childTemplates.add( getTrimmedValue( xmlStreamReader.getElementText()) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return modelTemplate;
    } //-- ModelTemplate parseModelTemplate(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseRedbackRoleModel
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private RedbackRoleModel parseRedbackRoleModel(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        RedbackRoleModel redbackRoleModel = new RedbackRoleModel();
        redbackRoleModel.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        boolean foundRoot = false;
        while ( xmlStreamReader.hasNext() )
        {
            int eventType = xmlStreamReader.next();
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                if ( xmlStreamReader.getLocalName().equals( tagName ) )
                {
                    foundRoot = true;
                }
                else if ( xmlStreamReader.getLocalName().equals( "modelVersion" )  )
                {
                    if ( parsed.contains( "modelVersion" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "modelVersion" );
                    redbackRoleModel.setModelVersion( getTrimmedValue( xmlStreamReader.getElementText()) );
                }
                else if ( xmlStreamReader.getLocalName().equals( "applications" )  )
                {
                    if ( parsed.contains( "applications" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "applications" );
                    java.util.List applications = new java.util.ArrayList();
                    redbackRoleModel.setApplications( applications );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "application" ) )
                        {
                            redbackRoleModel.addApplication( parseModelApplication( "application", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else
                {
                    if ( foundRoot )
                    {
                        if ( strict )
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
            }
        }
        return redbackRoleModel;
    } //-- RedbackRoleModel parseRedbackRoleModel(String, XMLStreamReader, boolean, String) 

    /**
     * Method read
     * 
     * @param reader
     * @param strict
     */
    public RedbackRoleModel read(Reader reader, boolean strict)
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );
        
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        RedbackRoleModel value = parseRedbackRoleModel( "redback-role-model", xmlStreamReader, strict, encoding );
        resolveReferences( value );
        return value;
    } //-- RedbackRoleModel read(Reader, boolean) 

    /**
     * Method read
     * 
     * @param reader
     */
    public RedbackRoleModel read(Reader reader)
        throws IOException, XMLStreamException
    {
        return read( reader, true );
    } //-- RedbackRoleModel read(Reader) 

    /**
     * Method read
     * 
     * @param filePath
     * @param strict
     */
    public RedbackRoleModel read(String filePath, boolean strict)
        throws IOException, XMLStreamException
    {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( file.toURL().toExternalForm(), new FileInputStream(file) );
        
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        RedbackRoleModel value = parseRedbackRoleModel( "redback-role-model", xmlStreamReader, strict, encoding );
        resolveReferences( value );
        return value;
    } //-- RedbackRoleModel read(String, boolean) 

    /**
     * Method read
     * 
     * @param filePath
     */
    public RedbackRoleModel read(String filePath)
        throws IOException, XMLStreamException
    {
        return read( filePath, true );
    } //-- RedbackRoleModel read(String) 

    /**
     * Method resolveReferences
     * 
     * @param value
     */
    private void resolveReferences(RedbackRoleModel value)
    {
        java.util.Map refs;
    } //-- void resolveReferences(RedbackRoleModel) 


}
