/*
 * $Id$
 */

package org.apache.archiva.redback.role.model.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.Manifest;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.*;
import org.apache.archiva.redback.role.model.ModelApplication;
import org.apache.archiva.redback.role.model.ModelOperation;
import org.apache.archiva.redback.role.model.ModelPermission;
import org.apache.archiva.redback.role.model.ModelResource;
import org.apache.archiva.redback.role.model.ModelRole;
import org.apache.archiva.redback.role.model.ModelTemplate;
import org.apache.archiva.redback.role.model.RedbackRoleModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/**
 * Class RedbackRoleModelStaxWriter.
 * 
 * @version $Revision$ $Date$
 */
public class RedbackRoleModelStaxWriter {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field curId
     */
    private int curId;

    /**
     * Field idMap
     */
    private java.util.Map idMap;


      //----------------/
     //- Constructors -/
    //----------------/

    public RedbackRoleModelStaxWriter() {
        idMap = new java.util.HashMap();
    } //-- org.apache.archiva.redback.role.model.io.stax.RedbackRoleModelStaxWriter()


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param redbackRoleModel
     */
    public void write(Writer writer, RedbackRoleModel redbackRoleModel)
        throws java.io.IOException, XMLStreamException
    {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if ( factory.isPropertySupported( "com.ctc.wstx.outputEscapeCr" ) )
        {
            factory.setProperty( "com.ctc.wstx.outputEscapeCr", Boolean.FALSE );
            supportWindowsLineEndings = true;
        }
        if ( factory.isPropertySupported( "org.codehaus.stax2.automaticEmptyElements" ) )
        {
            factory.setProperty( "org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE );
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter( factory.createXMLStreamWriter( writer ) );
        if ( supportWindowsLineEndings )
        {
            serializer.setNewLine( serializer.getLineSeparator() );
        }
        serializer.writeStartDocument( redbackRoleModel.getModelEncoding(), "1.0" );
        writeRedbackRoleModel( redbackRoleModel, "redback-role-model", serializer );
        serializer.writeEndDocument();
    } //-- void write(Writer, RedbackRoleModel) 

    /**
     * Method writeDom
     * 
     * @param dom
     * @param serializer
     */
    public void writeDom(Xpp3Dom dom, XMLStreamWriter serializer)
        throws XMLStreamException
    {
        serializer.writeStartElement( dom.getName() );
        String[] attributeNames = dom.getAttributeNames();
        for ( int i = 0; i < attributeNames.length; i++ )
        {
            String attributeName = attributeNames[i];
            serializer.writeAttribute( attributeName, dom.getAttribute( attributeName ) );
        }
        Xpp3Dom[] children = dom.getChildren();
        for ( int i = 0; i < children.length; i++ )
        {
            writeDom( children[i], serializer );
        }
        String value = dom.getValue();
        if ( value != null )
        {
            serializer.writeCharacters( value );
        }
        serializer.writeEndElement();
    } //-- void writeDom(Xpp3Dom, XMLStreamWriter) 

    /**
     * Method writeModelApplication
     * 
     * @param modelApplication
     * @param serializer
     * @param tagName
     */
    private void writeModelApplication(ModelApplication modelApplication, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( modelApplication != null )
        {
            serializer.writeStartElement( tagName );
            if ( modelApplication.getVersion() != null )
            {
                serializer.writeStartElement( "version" );
                serializer.writeCharacters( modelApplication.getVersion() );
                serializer.writeEndElement();
            }
            if ( modelApplication.getId() != null )
            {
                serializer.writeStartElement( "id" );
                serializer.writeCharacters( modelApplication.getId() );
                serializer.writeEndElement();
            }
            if ( modelApplication.getDescription() != null )
            {
                serializer.writeStartElement( "description" );
                serializer.writeCharacters( modelApplication.getDescription() );
                serializer.writeEndElement();
            }
            if ( modelApplication.getLongDescription() != null )
            {
                serializer.writeStartElement( "longDescription" );
                serializer.writeCharacters( modelApplication.getLongDescription() );
                serializer.writeEndElement();
            }
            if ( modelApplication.getResources() != null && modelApplication.getResources().size() > 0 )
            {
                serializer.writeStartElement( "resources" );
                for ( Iterator iter = modelApplication.getResources().iterator(); iter.hasNext(); )
                {
                    ModelResource o = (ModelResource) iter.next();
                    writeModelResource( o, "resource", serializer );
                }
                serializer.writeEndElement();
            }
            if ( modelApplication.getOperations() != null && modelApplication.getOperations().size() > 0 )
            {
                serializer.writeStartElement( "operations" );
                for ( Iterator iter = modelApplication.getOperations().iterator(); iter.hasNext(); )
                {
                    ModelOperation o = (ModelOperation) iter.next();
                    writeModelOperation( o, "operation", serializer );
                }
                serializer.writeEndElement();
            }
            if ( modelApplication.getRoles() != null && modelApplication.getRoles().size() > 0 )
            {
                serializer.writeStartElement( "roles" );
                for ( Iterator iter = modelApplication.getRoles().iterator(); iter.hasNext(); )
                {
                    ModelRole o = (ModelRole) iter.next();
                    writeModelRole( o, "role", serializer );
                }
                serializer.writeEndElement();
            }
            if ( modelApplication.getTemplates() != null && modelApplication.getTemplates().size() > 0 )
            {
                serializer.writeStartElement( "templates" );
                for ( Iterator iter = modelApplication.getTemplates().iterator(); iter.hasNext(); )
                {
                    ModelTemplate o = (ModelTemplate) iter.next();
                    writeModelTemplate( o, "template", serializer );
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeModelApplication(ModelApplication, String, XMLStreamWriter) 

    /**
     * Method writeModelOperation
     * 
     * @param modelOperation
     * @param serializer
     * @param tagName
     */
    private void writeModelOperation(ModelOperation modelOperation, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( modelOperation != null )
        {
            serializer.writeStartElement( tagName );
            if ( modelOperation.getId() != null )
            {
                serializer.writeStartElement( "id" );
                serializer.writeCharacters( modelOperation.getId() );
                serializer.writeEndElement();
            }
            if ( modelOperation.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( modelOperation.getName() );
                serializer.writeEndElement();
            }
            if ( modelOperation.getDescription() != null )
            {
                serializer.writeStartElement( "description" );
                serializer.writeCharacters( modelOperation.getDescription() );
                serializer.writeEndElement();
            }
            if ( modelOperation.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( modelOperation.isPermanent() ) );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeModelOperation(ModelOperation, String, XMLStreamWriter) 

    /**
     * Method writeModelPermission
     * 
     * @param modelPermission
     * @param serializer
     * @param tagName
     */
    private void writeModelPermission(ModelPermission modelPermission, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( modelPermission != null )
        {
            serializer.writeStartElement( tagName );
            if ( modelPermission.getId() != null )
            {
                serializer.writeStartElement( "id" );
                serializer.writeCharacters( modelPermission.getId() );
                serializer.writeEndElement();
            }
            if ( modelPermission.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( modelPermission.getName() );
                serializer.writeEndElement();
            }
            if ( modelPermission.getDescription() != null )
            {
                serializer.writeStartElement( "description" );
                serializer.writeCharacters( modelPermission.getDescription() );
                serializer.writeEndElement();
            }
            if ( modelPermission.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( modelPermission.isPermanent() ) );
                serializer.writeEndElement();
            }
            if ( modelPermission.getOperation() != null )
            {
                serializer.writeStartElement( "operation" );
                serializer.writeCharacters( modelPermission.getOperation() );
                serializer.writeEndElement();
            }
            if ( modelPermission.getResource() != null )
            {
                serializer.writeStartElement( "resource" );
                serializer.writeCharacters( modelPermission.getResource() );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeModelPermission(ModelPermission, String, XMLStreamWriter) 

    /**
     * Method writeModelResource
     * 
     * @param modelResource
     * @param serializer
     * @param tagName
     */
    private void writeModelResource(ModelResource modelResource, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( modelResource != null )
        {
            serializer.writeStartElement( tagName );
            if ( modelResource.getId() != null )
            {
                serializer.writeStartElement( "id" );
                serializer.writeCharacters( modelResource.getId() );
                serializer.writeEndElement();
            }
            if ( modelResource.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( modelResource.getName() );
                serializer.writeEndElement();
            }
            if ( modelResource.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( modelResource.isPermanent() ) );
                serializer.writeEndElement();
            }
            if ( modelResource.isPattern() != false )
            {
                serializer.writeStartElement( "pattern" );
                serializer.writeCharacters( String.valueOf( modelResource.isPattern() ) );
                serializer.writeEndElement();
            }
            if ( modelResource.getDescription() != null )
            {
                serializer.writeStartElement( "description" );
                serializer.writeCharacters( modelResource.getDescription() );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeModelResource(ModelResource, String, XMLStreamWriter) 

    /**
     * Method writeModelRole
     * 
     * @param modelRole
     * @param serializer
     * @param tagName
     */
    private void writeModelRole(ModelRole modelRole, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( modelRole != null )
        {
            serializer.writeStartElement( tagName );
            if ( modelRole.getId() != null )
            {
                serializer.writeStartElement( "id" );
                serializer.writeCharacters( modelRole.getId() );
                serializer.writeEndElement();
            }
            if ( modelRole.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( modelRole.getName() );
                serializer.writeEndElement();
            }
            if ( modelRole.getDescription() != null )
            {
                serializer.writeStartElement( "description" );
                serializer.writeCharacters( modelRole.getDescription() );
                serializer.writeEndElement();
            }
            if ( modelRole.isAssignable() != false )
            {
                serializer.writeStartElement( "assignable" );
                serializer.writeCharacters( String.valueOf( modelRole.isAssignable() ) );
                serializer.writeEndElement();
            }
            if ( modelRole.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( modelRole.isPermanent() ) );
                serializer.writeEndElement();
            }
            if ( modelRole.getPermissions() != null && modelRole.getPermissions().size() > 0 )
            {
                serializer.writeStartElement( "permissions" );
                for ( Iterator iter = modelRole.getPermissions().iterator(); iter.hasNext(); )
                {
                    ModelPermission o = (ModelPermission) iter.next();
                    writeModelPermission( o, "permission", serializer );
                }
                serializer.writeEndElement();
            }
            if ( modelRole.getParentRoles() != null && modelRole.getParentRoles().size() > 0 )
            {
                serializer.writeStartElement( "parentRoles" );
                for ( Iterator iter = modelRole.getParentRoles().iterator(); iter.hasNext(); )
                {
                    String parentRole = (String) iter.next();
                    serializer.writeStartElement( "parentRole" );
                    serializer.writeCharacters( parentRole );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( modelRole.getChildRoles() != null && modelRole.getChildRoles().size() > 0 )
            {
                serializer.writeStartElement( "childRoles" );
                for ( Iterator iter = modelRole.getChildRoles().iterator(); iter.hasNext(); )
                {
                    String childRole = (String) iter.next();
                    serializer.writeStartElement( "childRole" );
                    serializer.writeCharacters( childRole );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeModelRole(ModelRole, String, XMLStreamWriter) 

    /**
     * Method writeModelTemplate
     * 
     * @param modelTemplate
     * @param serializer
     * @param tagName
     */
    private void writeModelTemplate(ModelTemplate modelTemplate, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( modelTemplate != null )
        {
            serializer.writeStartElement( tagName );
            if ( modelTemplate.getId() != null )
            {
                serializer.writeStartElement( "id" );
                serializer.writeCharacters( modelTemplate.getId() );
                serializer.writeEndElement();
            }
            if ( modelTemplate.getNamePrefix() != null )
            {
                serializer.writeStartElement( "namePrefix" );
                serializer.writeCharacters( modelTemplate.getNamePrefix() );
                serializer.writeEndElement();
            }
            if ( modelTemplate.getDelimiter() != null && !modelTemplate.getDelimiter().equals( " - " ) )
            {
                serializer.writeStartElement( "delimiter" );
                serializer.writeCharacters( modelTemplate.getDelimiter() );
                serializer.writeEndElement();
            }
            if ( modelTemplate.getDescription() != null )
            {
                serializer.writeStartElement( "description" );
                serializer.writeCharacters( modelTemplate.getDescription() );
                serializer.writeEndElement();
            }
            if ( modelTemplate.isAssignable() != false )
            {
                serializer.writeStartElement( "assignable" );
                serializer.writeCharacters( String.valueOf( modelTemplate.isAssignable() ) );
                serializer.writeEndElement();
            }
            if ( modelTemplate.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( modelTemplate.isPermanent() ) );
                serializer.writeEndElement();
            }
            if ( modelTemplate.isPermanentResource() != false )
            {
                serializer.writeStartElement( "permanentResource" );
                serializer.writeCharacters( String.valueOf( modelTemplate.isPermanentResource() ) );
                serializer.writeEndElement();
            }
            if ( modelTemplate.getPermissions() != null && modelTemplate.getPermissions().size() > 0 )
            {
                serializer.writeStartElement( "permissions" );
                for ( Iterator iter = modelTemplate.getPermissions().iterator(); iter.hasNext(); )
                {
                    ModelPermission o = (ModelPermission) iter.next();
                    writeModelPermission( o, "permission", serializer );
                }
                serializer.writeEndElement();
            }
            if ( modelTemplate.getParentRoles() != null && modelTemplate.getParentRoles().size() > 0 )
            {
                serializer.writeStartElement( "parentRoles" );
                for ( Iterator iter = modelTemplate.getParentRoles().iterator(); iter.hasNext(); )
                {
                    String parentRole = (String) iter.next();
                    serializer.writeStartElement( "parentRole" );
                    serializer.writeCharacters( parentRole );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( modelTemplate.getChildRoles() != null && modelTemplate.getChildRoles().size() > 0 )
            {
                serializer.writeStartElement( "childRoles" );
                for ( Iterator iter = modelTemplate.getChildRoles().iterator(); iter.hasNext(); )
                {
                    String childRole = (String) iter.next();
                    serializer.writeStartElement( "childRole" );
                    serializer.writeCharacters( childRole );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( modelTemplate.getParentTemplates() != null && modelTemplate.getParentTemplates().size() > 0 )
            {
                serializer.writeStartElement( "parentTemplates" );
                for ( Iterator iter = modelTemplate.getParentTemplates().iterator(); iter.hasNext(); )
                {
                    String parentTemplate = (String) iter.next();
                    serializer.writeStartElement( "parentTemplate" );
                    serializer.writeCharacters( parentTemplate );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( modelTemplate.getChildTemplates() != null && modelTemplate.getChildTemplates().size() > 0 )
            {
                serializer.writeStartElement( "childTemplates" );
                for ( Iterator iter = modelTemplate.getChildTemplates().iterator(); iter.hasNext(); )
                {
                    String childTemplate = (String) iter.next();
                    serializer.writeStartElement( "childTemplate" );
                    serializer.writeCharacters( childTemplate );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeModelTemplate(ModelTemplate, String, XMLStreamWriter) 

    /**
     * Method writeRedbackRoleModel
     * 
     * @param redbackRoleModel
     * @param serializer
     * @param tagName
     */
    private void writeRedbackRoleModel(RedbackRoleModel redbackRoleModel, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( redbackRoleModel != null )
        {
            serializer.writeStartElement( tagName );
            if ( redbackRoleModel.getModelVersion() != null )
            {
                serializer.writeStartElement( "modelVersion" );
                serializer.writeCharacters( redbackRoleModel.getModelVersion() );
                serializer.writeEndElement();
            }
            if ( redbackRoleModel.getApplications() != null && redbackRoleModel.getApplications().size() > 0 )
            {
                serializer.writeStartElement( "applications" );
                for ( Iterator iter = redbackRoleModel.getApplications().iterator(); iter.hasNext(); )
                {
                    ModelApplication o = (ModelApplication) iter.next();
                    writeModelApplication( o, "application", serializer );
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeRedbackRoleModel(RedbackRoleModel, String, XMLStreamWriter) 


}
