/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.tests;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import net.sf.ehcache.CacheManager;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RBACManagerListener;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.RbacPermanentException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.tests.RbacManagerEventTracker;
import org.apache.archiva.redback.tests.utils.RBACDefaults;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath*:/META-INF/spring-context.xml", "classpath*:/spring-context.xml"})
public abstract class AbstractRbacManagerTestCase
extends TestCase {
    private RBACManager rbacManager;
    protected RbacManagerEventTracker eventTracker;
    private RBACDefaults rbacDefaults;
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void setRbacManager(RBACManager store) {
        this.rbacManager = store;
        if (this.rbacManager != null) {
            this.eventTracker = new RbacManagerEventTracker();
            this.rbacManager.addListener((RBACManagerListener)this.eventTracker);
        }
        this.rbacDefaults = new RBACDefaults(this.rbacManager);
    }

    public RBACManager getRbacManager() {
        return this.rbacManager;
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private Role getAdminRole() throws RbacManagerException {
        Role role = this.rbacManager.createRole("ADMIN");
        role.setAssignable(false);
        Permission perm = this.rbacManager.createPermission("EDIT_ANY_USER", "EDIT", "User:*");
        role.addPermission(perm);
        return role;
    }

    private Role getDeveloperRole() throws RbacManagerException {
        Role role = this.rbacManager.createRole("DEVELOPER");
        role.setAssignable(true);
        Permission perm = this.rbacManager.createPermission("EDIT_MY_USER", "EDIT", "User:Self");
        role.addPermission(perm);
        return role;
    }

    private Role getProjectAdminRole() throws RbacManagerException {
        Role role = this.rbacManager.createRole("PROJECT_ADMIN");
        role.setAssignable(true);
        Permission perm = this.rbacManager.createPermission("EDIT_PROJECT", "EDIT", "Project:Foo");
        role.addPermission(perm);
        return role;
    }

    private Role getSuperDeveloperRole() {
        Role role = this.rbacManager.createRole("SUPER_DEVELOPER");
        role.setAssignable(true);
        return role;
    }

    public abstract void assertEventCount();

    private void assertEventTracker(int addedRoleNameCount, int removedRoleNameCount, int addedPermissionNames, int removedPermissionNames, boolean freshness, boolean eventCount) {
        AbstractRbacManagerTestCase.assertNotNull((Object)this.eventTracker);
        if (eventCount) {
            this.assertEventCount();
        }
        AbstractRbacManagerTestCase.assertEquals((int)addedRoleNameCount, (int)this.eventTracker.addedRoleNames.size());
        AbstractRbacManagerTestCase.assertEquals((int)removedRoleNameCount, (int)this.eventTracker.removedRoleNames.size());
        AbstractRbacManagerTestCase.assertEquals((int)addedPermissionNames, (int)this.eventTracker.addedPermissionNames.size());
        AbstractRbacManagerTestCase.assertEquals((int)removedPermissionNames, (int)this.eventTracker.removedPermissionNames.size());
        if (freshness) {
            AbstractRbacManagerTestCase.assertTrue((boolean)this.eventTracker.lastDbFreshness);
        }
    }

    @Test
    public void testStoreInitialization() throws Exception {
        AbstractRbacManagerTestCase.assertNotNull((Object)this.rbacManager);
        Role role = this.getAdminRole();
        AbstractRbacManagerTestCase.assertNotNull((Object)role);
        Role added = this.rbacManager.saveRole(role);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)this.rbacManager.getAllRoles().size());
        AbstractRbacManagerTestCase.assertNotNull((Object)added);
        this.rbacManager.removeRole(added);
        AbstractRbacManagerTestCase.assertEquals((int)0, (int)this.rbacManager.getAllRoles().size());
        this.assertEventTracker(1, 1, 1, 0, false, false);
    }

    @Test
    public void testResources() throws Exception {
        AbstractRbacManagerTestCase.assertNotNull((Object)this.rbacManager);
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Resource resource = this.rbacManager.createResource("foo");
        Resource resource2 = this.rbacManager.createResource("bar");
        AbstractRbacManagerTestCase.assertNotNull((Object)resource);
        Resource added = this.rbacManager.saveResource(resource);
        AbstractRbacManagerTestCase.assertNotNull((Object)added);
        Resource added2 = this.rbacManager.saveResource(resource2);
        AbstractRbacManagerTestCase.assertNotNull((Object)added2);
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllResources().size());
        this.rbacManager.removeResource(added);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)this.rbacManager.getAllResources().size());
        this.assertEventTracker(0, 0, 0, 0, true, true);
    }

    @Test
    public void testAddGetPermission() throws RbacManagerException {
        AbstractRbacManagerTestCase.assertNotNull((Object)this.rbacManager);
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Role adminRole = this.rbacManager.saveRole(this.getAdminRole());
        this.rbacManager.saveRole(this.getDeveloperRole());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllRoles().size());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllPermissions().size());
        Permission createUserPerm = this.rbacManager.createPermission("CREATE_USER", "CREATE", "User");
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllPermissions().size());
        adminRole.addPermission(createUserPerm);
        this.rbacManager.saveRole(adminRole);
        AbstractRbacManagerTestCase.assertEquals((int)3, (int)this.rbacManager.getAllPermissions().size());
        Permission fetched = this.rbacManager.getPermission("CREATE_USER");
        AbstractRbacManagerTestCase.assertNotNull((Object)fetched);
        this.assertEventTracker(2, 0, 3, 0, true, true);
    }

    @Test
    public void testAddGetRole() throws RbacManagerException {
        AbstractRbacManagerTestCase.assertNotNull((Object)this.rbacManager);
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Role adminRole = this.rbacManager.saveRole(this.getAdminRole());
        Role develRole = this.rbacManager.saveRole(this.getDeveloperRole());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllRoles().size());
        Role actualAdmin = this.rbacManager.getRole(adminRole.getName());
        Role actualDevel = this.rbacManager.getRole(develRole.getName());
        AbstractRbacManagerTestCase.assertEquals((String)adminRole.getName(), (String)actualAdmin.getName());
        AbstractRbacManagerTestCase.assertEquals((Object)adminRole.getChildRoleNames(), (Object)actualAdmin.getChildRoleNames());
        AbstractRbacManagerTestCase.assertEquals((Object)develRole, (Object)actualDevel);
        this.assertEventTracker(2, 0, 2, 0, true, true);
    }

    @Test
    public void testAllowRoleWithoutPermissions() throws RbacManagerException {
        AbstractRbacManagerTestCase.assertNotNull((Object)this.rbacManager);
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        String rolename = "Test Role";
        Role testRole = this.rbacManager.createRole(rolename);
        testRole = this.rbacManager.saveRole(testRole);
        AbstractRbacManagerTestCase.assertNotNull((Object)testRole);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)this.rbacManager.getAllRoles().size());
        AbstractRbacManagerTestCase.assertEquals((int)0, (int)this.rbacManager.getAllPermissions().size());
        Role actualRole = this.rbacManager.getRole(rolename);
        AbstractRbacManagerTestCase.assertEquals((String)testRole.getName(), (String)actualRole.getName());
        AbstractRbacManagerTestCase.assertEquals((Object)testRole.getChildRoleNames(), (Object)actualRole.getChildRoleNames());
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)this.rbacManager.getAllRoles().size());
        AbstractRbacManagerTestCase.assertEquals((int)0, (int)this.rbacManager.getAllPermissions().size());
        this.assertEventTracker(1, 0, 0, 0, true, true);
    }

    protected boolean supportChildRole() {
        return true;
    }

    @Test
    public void testAddGetChildRole() throws RbacManagerException {
        if (!this.supportChildRole()) {
            this.log.info("child role feature not supported by the RBACManager impl: {}", (Object)this.rbacManager.getClass().getName());
            return;
        }
        RBACManager manager = this.rbacManager;
        AbstractRbacManagerTestCase.assertNotNull((Object)manager);
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Role adminRole = manager.saveRole(this.getAdminRole());
        Role develRole = manager.saveRole(this.getDeveloperRole());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)manager.getAllRoles().size());
        Role actualAdmin = manager.getRole(adminRole.getName());
        Role actualDevel = manager.getRole(develRole.getName());
        AbstractRbacManagerTestCase.assertEquals((String)adminRole.getName(), (String)actualAdmin.getName());
        AbstractRbacManagerTestCase.assertEquals((Object)adminRole.getChildRoleNames(), (Object)actualAdmin.getChildRoleNames());
        AbstractRbacManagerTestCase.assertEquals((Object)develRole, (Object)actualDevel);
        manager.addChildRole(develRole, this.getProjectAdminRole());
        manager.saveRole(develRole);
        AbstractRbacManagerTestCase.assertEquals((int)3, (int)manager.getAllRoles().size());
        this.assertEventTracker(3, 0, 3, 0, true, true);
    }

    @Test
    public void testAddGetChildRoleViaName() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        AbstractRbacManagerTestCase.assertNotNull((Object)manager);
        Role adminRole = manager.saveRole(this.getAdminRole());
        Role develRole = manager.saveRole(this.getDeveloperRole());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)manager.getAllRoles().size());
        Role actualAdmin = manager.getRole(adminRole.getName());
        Role actualDevel = manager.getRole(develRole.getName());
        AbstractRbacManagerTestCase.assertEquals((String)adminRole.getName(), (String)actualAdmin.getName());
        AbstractRbacManagerTestCase.assertEquals((Object)adminRole.getChildRoleNames(), (Object)actualAdmin.getChildRoleNames());
        AbstractRbacManagerTestCase.assertEquals((Object)develRole, (Object)actualDevel);
        Role projectRole = this.getProjectAdminRole();
        String projectRoleName = projectRole.getName();
        manager.saveRole(projectRole);
        develRole.addChildRoleName(projectRoleName);
        manager.saveRole(develRole);
        AbstractRbacManagerTestCase.assertEquals((int)3, (int)manager.getAllRoles().size());
        this.assertEventTracker(3, 0, 3, 0, true, true);
    }

    @Test
    public void testUserAssignmentAddRole() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Role adminRole = manager.saveRole(this.getAdminRole());
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllRoles().size());
        String adminPrincipal = "admin";
        UserAssignment assignment = manager.createUserAssignment(adminPrincipal);
        assignment.addRoleName(adminRole);
        manager.saveUserAssignment(assignment);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllUserAssignments().size());
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllRoles().size());
        UserAssignment ua = manager.getUserAssignment(adminPrincipal);
        AbstractRbacManagerTestCase.assertNotNull((Object)ua);
        Role fetched = manager.getRole("ADMIN");
        AbstractRbacManagerTestCase.assertNotNull((Object)fetched);
        this.assertEventTracker(1, 0, 1, 0, true, true);
    }

    @Test
    public void testUserAssignmentWithChildRoles() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        Role developerRole = manager.saveRole(this.getDeveloperRole());
        Role adminRole = this.getAdminRole();
        adminRole.addChildRoleName(developerRole.getName());
        adminRole = manager.saveRole(adminRole);
        String adminPrincipal = "theadmin";
        UserAssignment assignment = manager.createUserAssignment(adminPrincipal);
        assignment.addRoleName(adminRole);
        assignment = manager.saveUserAssignment(assignment);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)assignment.getRoleNames().size());
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAssignedRoles(adminPrincipal).size());
    }

    @Test
    public void testGetAssignedPermissionsNoChildRoles() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Role admin = this.getAdminRole();
        admin = manager.saveRole(admin);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllRoles().size());
        String adminPrincipal = "admin";
        UserAssignment ua = manager.createUserAssignment(adminPrincipal);
        ua.addRoleName(admin);
        manager.saveUserAssignment(ua);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllUserAssignments().size());
        Set assignedPermissions = manager.getAssignedPermissions(adminPrincipal);
        ((AbstractIterableAssert)Assertions.assertThat((Iterable)assignedPermissions).isNotNull()).isNotEmpty().hasSize(1);
        this.assertEventTracker(1, 0, 1, 0, true, true);
    }

    @Test
    public void testGlobalResource() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Permission editConfiguration = manager.createPermission("Edit Configuration");
        editConfiguration.setOperation(manager.createOperation("edit-configuration"));
        editConfiguration.setResource(manager.getGlobalResource());
        manager.savePermission(editConfiguration);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllPermissions().size());
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllOperations().size());
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllResources().size());
        Permission deleteConfiguration = manager.createPermission("Delete Configuration");
        deleteConfiguration.setOperation(manager.createOperation("delete-configuration"));
        deleteConfiguration.setResource(manager.getGlobalResource());
        manager.savePermission(deleteConfiguration);
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)manager.getAllPermissions().size());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)manager.getAllOperations().size());
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllResources().size());
        this.assertEventTracker(0, 0, 2, 0, true, true);
    }

    @Test
    public void testGlobalResourceOneLiner() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        manager.savePermission(manager.createPermission("Edit Configuration", "edit-configuration", "*"));
        manager.savePermission(manager.createPermission("Delete Configuration", "delete-configuration", "*"));
        this.assertEventTracker(0, 0, 2, 0, true, true);
    }

    @Test
    public void testUserAssignmentAddRemoveSecondRole() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Role developerRole = this.getDeveloperRole();
        manager.saveRole(developerRole);
        String username = "bob";
        UserAssignment assignment = manager.createUserAssignment(username);
        assignment.addRoleName(developerRole);
        manager.saveUserAssignment(assignment);
        AbstractRbacManagerTestCase.assertEquals((int)this.incAssignements(1), (int)manager.getAllUserAssignments().size());
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllRoles().size());
        Role projectAdmin = this.getProjectAdminRole();
        String projectAdminRoleName = projectAdmin.getName();
        manager.saveRole(projectAdmin);
        UserAssignment bob = manager.getUserAssignment(username);
        bob.addRoleName(projectAdminRoleName);
        bob = manager.saveUserAssignment(bob);
        AbstractRbacManagerTestCase.assertEquals((int)this.incAssignements(1), (int)manager.getAllUserAssignments().size());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)manager.getAllRoles().size());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)bob.getRoleNames().size());
        AbstractRbacManagerTestCase.assertEquals((int)0, (int)manager.getUnassignedRoles(bob.getPrincipal()).size());
        List roles = bob.getRoleNames();
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)roles.size());
        roles.remove(projectAdminRoleName);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)roles.size());
        bob.setRoleNames(roles);
        bob = manager.saveUserAssignment(bob);
        AbstractRbacManagerTestCase.assertEquals((String)"Should only have 1 role under bob now.", (int)1, (int)bob.getRoleNames().size());
        AbstractRbacManagerTestCase.assertEquals((String)"Should have 2 total roles still.", (int)2, (int)manager.getAllRoles().size());
        AbstractRbacManagerTestCase.assertEquals((String)"Should have 1 assignable role", (int)1, (int)manager.getUnassignedRoles(bob.getPrincipal()).size());
        UserAssignment cousin = manager.getUserAssignment(username);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)cousin.getRoleNames().size());
        AbstractRbacManagerTestCase.assertEquals((String)"Should only have 1 role under bob now.", (int)1, (int)cousin.getRoleNames().size());
        AbstractRbacManagerTestCase.assertEquals((String)"Should have 2 total roles still.", (int)2, (int)manager.getAllRoles().size());
        roles.remove(developerRole.getName());
        bob.setRoleNames(roles);
        bob = manager.saveUserAssignment(bob);
        AbstractRbacManagerTestCase.assertEquals((String)"Should have 2 assignable roles.", (int)2, (int)manager.getUnassignedRoles(bob.getPrincipal()).size());
        this.assertEventTracker(2, 0, 2, 0, true, true);
    }

    @Test
    public void testUserAssignmentMultipleRoles() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Role devRole = this.getDeveloperRole();
        manager.saveRole(devRole);
        String username = "bob";
        UserAssignment assignment = manager.createUserAssignment(username);
        assignment.addRoleName(devRole);
        assignment = manager.saveUserAssignment(assignment);
        AbstractRbacManagerTestCase.assertEquals((int)this.incAssignements(1), (int)manager.getAllUserAssignments().size());
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)manager.getAllRoles().size());
        assignment.addRoleName(devRole.getName());
        manager.saveUserAssignment(assignment);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)assignment.getRoleNames().size());
        this.assertEventTracker(1, 0, 1, 0, true, true);
    }

    @Test
    public void testUserAssignmentMultipleRolesWithChildRoles() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Role devRole = this.getDeveloperRole();
        Role devPlusRole = this.getSuperDeveloperRole();
        devPlusRole.setChildRoleNames(Collections.singletonList(devRole.getName()));
        manager.saveRole(devRole);
        manager.saveRole(devPlusRole);
        String username = "bob";
        UserAssignment assignment = manager.createUserAssignment(username);
        assignment.addRoleName(devRole);
        assignment = manager.saveUserAssignment(assignment);
        AbstractRbacManagerTestCase.assertEquals((int)this.incAssignements(1), (int)manager.getAllUserAssignments().size());
        AbstractRbacManagerTestCase.assertEquals((String)"should be only one role assigned", (int)1, (int)manager.getAssignedRoles(assignment.getPrincipal()).size());
        AbstractRbacManagerTestCase.assertEquals((String)"should be one role left to assign", (int)1, (int)manager.getUnassignedRoles(assignment.getPrincipal()).size());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)manager.getAllRoles().size());
        assignment.addRoleName(devRole.getName());
        manager.saveUserAssignment(assignment);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)assignment.getRoleNames().size());
        this.assertEventTracker(2, 0, 1, 0, true, true);
    }

    @Test
    public void testGetAssignedRoles() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        Role adminRole = manager.saveRole(this.getAdminRole());
        Role projectAdminRole = manager.saveRole(this.getProjectAdminRole());
        Role developerRole = manager.saveRole(this.getDeveloperRole());
        AbstractRbacManagerTestCase.assertEquals((int)3, (int)manager.getAllRoles().size());
        String username = "bob";
        UserAssignment assignment = manager.createUserAssignment(username);
        assignment.addRoleName(developerRole.getName());
        assignment.addRoleName(projectAdminRole.getName());
        assignment.addRoleName(adminRole.getName());
        assignment = manager.saveUserAssignment(assignment);
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)assignment.getRoleNames()).isNotNull()).isNotEmpty()).hasSize(3);
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)manager.getAllUserAssignments()).isNotNull()).isNotEmpty()).hasSize(this.incAssignements(1));
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)manager.getAllRoles()).isNotNull()).isNotEmpty()).hasSize(3);
        this.afterSetup();
        Collection assignedRoles = manager.getAssignedRoles(username);
        ((AbstractIterableAssert)Assertions.assertThat((Iterable)assignedRoles).isNotNull()).isNotEmpty().hasSize(3);
    }

    protected int incAssignements(int size) {
        return size;
    }

    @Test
    public void testGetAssignedPermissions() throws RbacManagerException {
        RBACManager manager = this.rbacManager;
        this.rbacManager.eraseDatabase();
        manager.saveRole(this.getAdminRole());
        manager.saveRole(this.getProjectAdminRole());
        Role added = manager.saveRole(this.getDeveloperRole());
        String roleName = added.getName();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)manager.getAllRoles()).isNotNull()).isNotEmpty()).hasSize(3);
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)manager.getAllPermissions()).isNotNull()).isNotEmpty()).hasSize(3);
        String username = "bob";
        UserAssignment assignment = manager.createUserAssignment(username);
        assignment.addRoleName(roleName);
        manager.saveUserAssignment(assignment);
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)manager.getAllUserAssignments()).isNotNull()).isNotEmpty()).hasSize(this.incAssignements(1));
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)manager.getAllRoles()).isNotNull()).isNotEmpty()).hasSize(3);
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)manager.getAllPermissions()).isNotNull()).isNotEmpty()).hasSize(3);
        Set assignedPermissions = manager.getAssignedPermissions(username);
        ((AbstractIterableAssert)Assertions.assertThat((Iterable)assignedPermissions).isNotNull()).isNotEmpty().hasSize(1);
    }

    public Role getChildRole(RBACManager manager, Role role, String expectedChildRoleName, int childRoleCount) throws RbacManagerException {
        AbstractRbacManagerTestCase.assertTrue((boolean)role.hasChildRoles());
        List childNames = role.getChildRoleNames();
        AbstractRbacManagerTestCase.assertNotNull((Object)childNames);
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)childNames.size());
        String childName = (String)childNames.get(0);
        AbstractRbacManagerTestCase.assertNotNull((Object)childName);
        Role childRole = manager.getRole(childName);
        AbstractRbacManagerTestCase.assertNotNull((Object)childRole);
        AbstractRbacManagerTestCase.assertEquals((String)expectedChildRoleName, (String)childRole.getName());
        return childRole;
    }

    @Test
    public void testAddRemovePermanentRole() throws RbacManagerException {
        AbstractRbacManagerTestCase.assertNotNull((Object)this.rbacManager);
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Role adminRole = this.getAdminRole();
        adminRole.setPermanent(true);
        adminRole = this.rbacManager.saveRole(adminRole);
        Role develRole = this.rbacManager.saveRole(this.getDeveloperRole());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllRoles().size());
        Role actualAdmin = this.rbacManager.getRole(adminRole.getName());
        Role actualDevel = this.rbacManager.getRole(develRole.getName());
        AbstractRbacManagerTestCase.assertEquals((String)adminRole.getName(), (String)actualAdmin.getName());
        AbstractRbacManagerTestCase.assertEquals((Object)adminRole.getChildRoleNames(), (Object)actualAdmin.getChildRoleNames());
        AbstractRbacManagerTestCase.assertEquals((Object)develRole, (Object)actualDevel);
        try {
            this.rbacManager.removeRole(adminRole.getName());
        }
        catch (RbacPermanentException e) {
            // empty catch block
        }
        try {
            this.rbacManager.removeRole(adminRole);
        }
        catch (RbacPermanentException e) {
            // empty catch block
        }
        this.assertEventTracker(2, 0, 2, 0, true, true);
    }

    @Test
    public void testGetRolesDeep() throws RbacManagerException {
        this.rbacManager.eraseDatabase();
        this.rbacDefaults.createDefaults();
        String username = "bob";
        UserAssignment assignment = this.rbacManager.createUserAssignment(username);
        assignment.addRoleName("Developer");
        this.rbacManager.saveUserAssignment(assignment);
        AbstractRbacManagerTestCase.assertEquals((int)this.incAssignements(1), (int)this.rbacManager.getAllUserAssignments().size());
        AbstractRbacManagerTestCase.assertEquals((int)4, (int)this.rbacManager.getAllRoles().size());
        AbstractRbacManagerTestCase.assertEquals((int)6, (int)this.rbacManager.getAllPermissions().size());
        Role devel = this.rbacManager.getRole("Developer");
        AbstractRbacManagerTestCase.assertNotNull((Object)devel);
        Role trusted = this.getChildRole(this.rbacManager, devel, "Trusted Developer", 1);
        Role sysAdmin = this.getChildRole(this.rbacManager, trusted, "System Administrator", 1);
        this.getChildRole(this.rbacManager, sysAdmin, "User Administrator", 1);
    }

    @Test
    public void testGetAssignedPermissionsDeep() throws RbacManagerException {
        this.clearCache();
        AbstractRbacManagerTestCase.assertNotNull((Object)this.rbacManager);
        this.rbacManager.eraseDatabase();
        this.rbacDefaults.createDefaults();
        String username = "bob";
        UserAssignment assignment = this.rbacManager.createUserAssignment(username);
        assignment.addRoleName("Developer");
        this.rbacManager.saveUserAssignment(assignment);
        AbstractRbacManagerTestCase.assertEquals((int)this.incAssignements(1), (int)this.rbacManager.getAllUserAssignments().size());
        List permissions = this.rbacManager.getAllPermissions();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)permissions).isNotNull()).isNotEmpty()).hasSize(6);
        List roles = this.rbacManager.getAllRoles();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((List)roles).isNotNull()).isNotEmpty()).hasSize(4);
        this.afterSetup();
        Set assignedPermissions = this.rbacManager.getAssignedPermissions(username);
        AbstractRbacManagerTestCase.assertNotNull((Object)assignedPermissions);
        AbstractRbacManagerTestCase.assertEquals((int)6, (int)assignedPermissions.size());
    }

    @Test
    public void testLargeApplicationInit() throws RbacManagerException {
        AbstractRbacManagerTestCase.assertNotNull((Object)this.rbacManager);
        this.rbacManager.eraseDatabase();
        this.rbacDefaults.createDefaults();
        AbstractRbacManagerTestCase.assertEquals((int)6, (int)this.rbacManager.getAllPermissions().size());
        AbstractRbacManagerTestCase.assertEquals((int)11, (int)this.rbacManager.getAllOperations().size());
        AbstractRbacManagerTestCase.assertEquals((int)4, (int)this.rbacManager.getAllRoles().size());
    }

    @Test
    public void testAddRemovePermanentPermission() throws RbacManagerException {
        AbstractRbacManagerTestCase.assertNotNull((Object)this.rbacManager);
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        Role adminRole = this.rbacManager.saveRole(this.getAdminRole());
        this.rbacManager.saveRole(this.getDeveloperRole());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllRoles().size());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllPermissions().size());
        Permission createUserPerm = this.rbacManager.createPermission("CREATE_USER", "CREATE", "User");
        createUserPerm.setPermanent(true);
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllPermissions().size());
        adminRole.addPermission(createUserPerm);
        this.rbacManager.saveRole(adminRole);
        AbstractRbacManagerTestCase.assertEquals((int)3, (int)this.rbacManager.getAllPermissions().size());
        Permission fetched = this.rbacManager.getPermission("CREATE_USER");
        AbstractRbacManagerTestCase.assertNotNull((Object)fetched);
        try {
            this.rbacManager.removePermission("CREATE_USER");
        }
        catch (RbacPermanentException e) {
            // empty catch block
        }
        try {
            this.rbacManager.removePermission(fetched);
        }
        catch (RbacPermanentException e) {
            // empty catch block
        }
        this.assertEventTracker(2, 0, 3, 0, true, true);
    }

    @Test
    public void testAddRemovePermanentOperation() throws RbacManagerException {
        this.rbacManager.eraseDatabase();
        this.eventTracker.rbacInit(true);
        AbstractRbacManagerTestCase.assertNotNull((Object)this.rbacManager);
        Role adminRole = this.rbacManager.saveRole(this.getAdminRole());
        this.rbacManager.saveRole(this.getDeveloperRole());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllRoles().size());
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllPermissions().size());
        Permission createUserPerm = this.rbacManager.createPermission("CREATE_USER", "CREATE", "User");
        createUserPerm.getOperation().setPermanent(true);
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllPermissions().size());
        AbstractRbacManagerTestCase.assertEquals((int)1, (int)this.rbacManager.getAllOperations().size());
        adminRole.addPermission(createUserPerm);
        this.rbacManager.saveRole(adminRole);
        AbstractRbacManagerTestCase.assertEquals((int)2, (int)this.rbacManager.getAllOperations().size());
        Operation fetched = this.rbacManager.getOperation("CREATE");
        AbstractRbacManagerTestCase.assertNotNull((Object)fetched);
        try {
            this.rbacManager.removeOperation("CREATE");
        }
        catch (RbacPermanentException e) {
            // empty catch block
        }
        try {
            this.rbacManager.removeOperation(fetched);
        }
        catch (RbacPermanentException e) {
            // empty catch block
        }
        this.assertEventTracker(2, 0, 3, 0, true, true);
    }

    @Test
    public void testInitialize() throws Exception {
        this.rbacManager.initialize();
    }

    protected void afterSetup() {
    }

    protected void clearCache() {
        for (String cacheName : CacheManager.getInstance().getCacheNames()) {
            CacheManager.getInstance().getCache(cacheName).removeAll();
        }
    }
}

