/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.tests.utils;

import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.Role;

public class RBACDefaults {
    private final RBACManager manager;

    public RBACDefaults(RBACManager manager) {
        this.manager = manager;
    }

    public RBACManager createDefaults() throws RbacManagerException {
        Role developer;
        Permission editAllUsers;
        Permission runIndexer;
        Operation operation;
        if (!this.manager.operationExists("add-repository")) {
            operation = this.manager.createOperation("add-repository");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.operationExists("edit-repository")) {
            operation = this.manager.createOperation("edit-repository");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.operationExists("delete-repository")) {
            operation = this.manager.createOperation("delete-repository");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.operationExists("edit-configuration")) {
            operation = this.manager.createOperation("edit-configuration");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.operationExists("run-indexer")) {
            operation = this.manager.createOperation("run-indexer");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.operationExists("regenerate-index")) {
            operation = this.manager.createOperation("regenerate-index");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.operationExists("get-reports")) {
            operation = this.manager.createOperation("get-reports");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.operationExists("regenerate-reports")) {
            operation = this.manager.createOperation("regenerate-reports");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.operationExists("edit-user")) {
            operation = this.manager.createOperation("edit-user");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.operationExists("edit-all-users")) {
            operation = this.manager.createOperation("edit-all-users");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.operationExists("remove-roles")) {
            operation = this.manager.createOperation("remove-roles");
            this.manager.saveOperation(operation);
        }
        if (!this.manager.permissionExists("Edit Configuration")) {
            Permission editConfiguration = this.manager.createPermission("Edit Configuration", "edit-configuration", this.manager.getGlobalResource().getIdentifier());
            this.manager.savePermission(editConfiguration);
        }
        if (!this.manager.permissionExists("Run Indexer")) {
            runIndexer = this.manager.createPermission("Run Indexer", "run-indexer", this.manager.getGlobalResource().getIdentifier());
            this.manager.savePermission(runIndexer);
        }
        if (!this.manager.permissionExists("Add Repository")) {
            runIndexer = this.manager.createPermission("Add Repository", "add-repository", this.manager.getGlobalResource().getIdentifier());
            this.manager.savePermission(runIndexer);
        }
        if (!this.manager.permissionExists("Edit All Users")) {
            editAllUsers = this.manager.createPermission("Edit All Users", "edit-all-users", this.manager.getGlobalResource().getIdentifier());
            this.manager.savePermission(editAllUsers);
        }
        if (!this.manager.permissionExists("Remove Roles")) {
            editAllUsers = this.manager.createPermission("Remove Roles", "remove-roles", this.manager.getGlobalResource().getIdentifier());
            this.manager.savePermission(editAllUsers);
        }
        if (!this.manager.permissionExists("Regenerate Index")) {
            Permission regenIndex = this.manager.createPermission("Regenerate Index", "regenerate-index", this.manager.getGlobalResource().getIdentifier());
            this.manager.savePermission(regenIndex);
        }
        if (!this.manager.roleExists("User Administrator")) {
            Role userAdmin = this.manager.createRole("User Administrator");
            userAdmin.addPermission(this.manager.getPermission("Edit All Users"));
            userAdmin.addPermission(this.manager.getPermission("Remove Roles"));
            userAdmin.setAssignable(true);
            this.manager.saveRole(userAdmin);
        }
        if (!this.manager.roleExists("System Administrator")) {
            Role admin = this.manager.createRole("System Administrator");
            admin.addChildRoleName("User Administrator");
            admin.addPermission(this.manager.getPermission("Edit Configuration"));
            admin.addPermission(this.manager.getPermission("Run Indexer"));
            admin.addPermission(this.manager.getPermission("Add Repository"));
            admin.addPermission(this.manager.getPermission("Regenerate Index"));
            admin.setAssignable(true);
            this.manager.saveRole(admin);
        }
        if (!this.manager.roleExists("Trusted Developer")) {
            developer = this.manager.createRole("Trusted Developer");
            developer.addChildRoleName("System Administrator");
            developer.addPermission(this.manager.getPermission("Run Indexer"));
            developer.setAssignable(true);
            this.manager.saveRole(developer);
        }
        if (!this.manager.roleExists("Developer")) {
            developer = this.manager.createRole("Developer");
            developer.addChildRoleName("Trusted Developer");
            developer.addPermission(this.manager.getPermission("Run Indexer"));
            developer.setAssignable(true);
            this.manager.saveRole(developer);
        }
        return this.manager;
    }
}

