/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.archiva.redback.rest.api.model.Permission;
import org.apache.archiva.redback.rest.api.model.User;

@XmlRootElement(name="role")
public class Role
implements Serializable {
    private String name;
    private String description;
    private boolean assignable = false;
    private List<String> childRoleNames = new ArrayList<String>(0);
    private List<Permission> permissions = new ArrayList<Permission>(0);
    private List<String> parentRoleNames = new ArrayList<String>(0);
    private List<User> parentsRolesUsers = new ArrayList<User>(0);
    private List<User> users = new ArrayList<User>(0);
    private List<User> otherUsers = new ArrayList<User>(0);
    private List<User> removedUsers = new ArrayList<User>(0);
    private boolean permanent = false;

    public Role() {
    }

    public Role(String name) {
        this.name = name;
    }

    public Role(org.apache.archiva.redback.rbac.Role role) {
        this.name = role.getName();
        this.description = role.getDescription();
        this.assignable = role.isAssignable();
        List<String> list = this.childRoleNames = role.getChildRoleNames() == null ? new ArrayList<String>(0) : new ArrayList(role.getChildRoleNames());
        if (role.getPermissions() == null) {
            this.permissions = new ArrayList<Permission>(0);
        } else {
            for (org.apache.archiva.redback.rbac.Permission p : role.getPermissions()) {
                this.permissions.add(new Permission(p));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public void setAssignable(boolean assignable) {
        this.assignable = assignable;
    }

    public List<String> getChildRoleNames() {
        return this.childRoleNames;
    }

    public void setChildRoleNames(List<String> childRoleNames) {
        this.childRoleNames = childRoleNames;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public List<String> getParentRoleNames() {
        return this.parentRoleNames;
    }

    public void setParentRoleNames(List<String> parentRoleNames) {
        this.parentRoleNames = parentRoleNames;
    }

    public List<User> getParentsRolesUsers() {
        return this.parentsRolesUsers;
    }

    public void setParentsRolesUsers(List<User> parentsRolesUsers) {
        this.parentsRolesUsers = parentsRolesUsers;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public List<User> getOtherUsers() {
        return this.otherUsers;
    }

    public void setOtherUsers(List<User> otherUsers) {
        this.otherUsers = otherUsers;
    }

    public List<User> getRemovedUsers() {
        return this.removedUsers;
    }

    public void setRemovedUsers(List<User> removedUsers) {
        this.removedUsers = removedUsers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Role");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", assignable=").append(this.assignable);
        sb.append(", childRoleNames=").append(this.childRoleNames);
        sb.append(", permissions=").append(this.permissions);
        sb.append(", parentRoleNames=").append(this.parentRoleNames);
        sb.append(", parentsRolesUsers=").append(this.parentsRolesUsers);
        sb.append(", users=").append(this.users);
        sb.append(", otherUsers=").append(this.otherUsers);
        sb.append(", removedUsers=").append(this.removedUsers);
        sb.append(", permanent=").append(this.permanent);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return !(this.name != null ? !this.name.equals(role.name) : role.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

