/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.api.services;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.redback.rest.api.model.LdapGroupMapping;
import org.apache.archiva.redback.rest.api.model.LdapGroupMappingUpdateRequest;
import org.apache.archiva.redback.rest.api.model.StringList;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;

@Path(value="/ldapGroupMappingService/")
public interface LdapGroupMappingService {
    @Path(value="ldapGroups")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"configuration-edit"})
    public StringList getLdapGroups() throws RedbackServiceException;

    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"configuration-edit"})
    public List<LdapGroupMapping> getLdapGroupMappings() throws RedbackServiceException;

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"configuration-edit"})
    public Boolean addLdapGroupMapping(LdapGroupMapping var1) throws RedbackServiceException;

    @DELETE
    @Path(value="{group}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"configuration-edit"})
    public Boolean removeLdapGroupMapping(@PathParam(value="group") String var1) throws RedbackServiceException;

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"configuration-edit"})
    public Boolean updateLdapGroupMapping(LdapGroupMappingUpdateRequest var1) throws RedbackServiceException;
}

