/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.api.services;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.redback.rest.api.model.Operation;
import org.apache.archiva.redback.rest.api.model.Permission;
import org.apache.archiva.redback.rest.api.model.RegistrationKey;
import org.apache.archiva.redback.rest.api.model.ResetPasswordRequest;
import org.apache.archiva.redback.rest.api.model.User;
import org.apache.archiva.redback.rest.api.model.UserRegistrationRequest;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;

@Path(value="/userService/")
public interface UserService {
    @Path(value="getUser/{userName}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"user-management-user-edit"})
    public User getUser(@PathParam(value="userName") String var1) throws RedbackServiceException;

    @Path(value="getUsers")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"user-management-user-list"})
    public List<User> getUsers() throws RedbackServiceException;

    @Path(value="createUser")
    @POST
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"user-management-user-create"})
    public Boolean createUser(User var1) throws RedbackServiceException;

    @Path(value="createAdminUser")
    @POST
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(noRestriction=true)
    public Boolean createAdminUser(User var1) throws RedbackServiceException;

    @Path(value="isAdminUserExists")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noRestriction=true)
    public Boolean isAdminUserExists() throws RedbackServiceException;

    @Path(value="deleteUser/{userName}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-delete"})
    public Boolean deleteUser(@PathParam(value="userName") String var1) throws RedbackServiceException;

    @Path(value="updateUser")
    @POST
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-edit"})
    public Boolean updateUser(User var1) throws RedbackServiceException;

    @Path(value="lockUser/{username}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-edit"})
    public Boolean lockUser(@PathParam(value="username") String var1) throws RedbackServiceException;

    @Path(value="unlockUser/{username}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-edit"})
    public Boolean unlockUser(@PathParam(value="username") String var1) throws RedbackServiceException;

    @Path(value="passwordChangeRequired/{username}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-edit"})
    public Boolean passwordChangeRequired(@PathParam(value="username") String var1) throws RedbackServiceException;

    @Path(value="passwordChangeNotRequired/{username}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-edit"})
    public Boolean passwordChangeNotRequired(@PathParam(value="username") String var1) throws RedbackServiceException;

    @Path(value="updateMe")
    @POST
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noRestriction=false, noPermission=true)
    public Boolean updateMe(User var1) throws RedbackServiceException;

    @Path(value="ping")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noRestriction=true)
    public Boolean ping() throws RedbackServiceException;

    @Path(value="removeFromCache/{userName}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-edit"})
    public int removeFromCache(@PathParam(value="userName") String var1) throws RedbackServiceException;

    @Path(value="getGuestUser")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-edit"})
    public User getGuestUser() throws RedbackServiceException;

    @Path(value="createGuestUser")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-edit"})
    public User createGuestUser() throws RedbackServiceException;

    @Path(value="registerUser")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noRestriction=true, noPermission=true)
    public RegistrationKey registerUser(UserRegistrationRequest var1) throws RedbackServiceException;

    @Path(value="validateKey/{key}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noRestriction=true, noPermission=true)
    public Boolean validateUserFromKey(@PathParam(value="key") String var1) throws RedbackServiceException;

    @Path(value="resetPassword")
    @POST
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(noRestriction=true, noPermission=true)
    public Boolean resetPassword(ResetPasswordRequest var1) throws RedbackServiceException;

    @Path(value="getUserPermissions/{userName}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-list"})
    public Collection<Permission> getUserPermissions(@PathParam(value="userName") String var1) throws RedbackServiceException;

    @Path(value="getUserOperations/{userName}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-user-list"})
    public Collection<Operation> getUserOperations(@PathParam(value="userName") String var1) throws RedbackServiceException;

    @Path(value="getCurrentUserPermissions")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noRestriction=true, noPermission=true)
    public Collection<Permission> getCurrentUserPermissions() throws RedbackServiceException;

    @Path(value="getCurrentUserOperations")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noRestriction=true, noPermission=true)
    public Collection<Operation> getCurrentUserOperations() throws RedbackServiceException;
}

