/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationFailureCause;
import org.apache.archiva.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticator;
import org.apache.archiva.redback.keys.AuthenticationKey;
import org.apache.archiva.redback.keys.KeyManager;
import org.apache.archiva.redback.keys.jdo.JdoAuthenticationKey;
import org.apache.archiva.redback.keys.memory.MemoryAuthenticationKey;
import org.apache.archiva.redback.keys.memory.MemoryKeyManager;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.rest.api.model.ErrorMessage;
import org.apache.archiva.redback.rest.api.model.LoginRequest;
import org.apache.archiva.redback.rest.api.services.LoginService;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="loginService#rest")
public class DefaultLoginService
implements LoginService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private SecuritySystem securitySystem;
    private HttpAuthenticator httpAuthenticator;
    @Context
    private HttpServletRequest httpServletRequest;

    @Inject
    public DefaultLoginService(SecuritySystem securitySystem, @Named(value="httpAuthenticator#basic") HttpAuthenticator httpAuthenticator) {
        this.securitySystem = securitySystem;
        this.httpAuthenticator = httpAuthenticator;
    }

    public String addAuthenticationKey(String providedKey, String principal, String purpose, int expirationMinutes) throws RedbackServiceException {
        KeyManager keyManager = this.securitySystem.getKeyManager();
        Object key = keyManager instanceof MemoryKeyManager ? new MemoryAuthenticationKey() : new JdoAuthenticationKey();
        key.setKey(providedKey);
        key.setForPrincipal(principal);
        key.setPurpose(purpose);
        Calendar now = this.getNowGMT();
        key.setDateCreated(now.getTime());
        if (expirationMinutes >= 0) {
            Calendar expiration = this.getNowGMT();
            expiration.add(12, expirationMinutes);
            key.setDateExpires(expiration.getTime());
        }
        keyManager.addKey((AuthenticationKey)key);
        return key.getKey();
    }

    public Boolean ping() throws RedbackServiceException {
        return Boolean.TRUE;
    }

    public Boolean pingWithAutz() throws RedbackServiceException {
        return Boolean.TRUE;
    }

    public org.apache.archiva.redback.rest.api.model.User logIn(LoginRequest loginRequest) throws RedbackServiceException {
        String userName = loginRequest.getUsername();
        String password = loginRequest.getPassword();
        PasswordBasedAuthenticationDataSource authDataSource = new PasswordBasedAuthenticationDataSource(userName, password);
        try {
            SecuritySession securitySession = this.securitySystem.authenticate((AuthenticationDataSource)authDataSource);
            if (securitySession.getAuthenticationResult().isAuthenticated()) {
                User user = securitySession.getUser();
                if (!user.isValidated()) {
                    this.log.info("user {} not validated", (Object)user.getUsername());
                    return null;
                }
                org.apache.archiva.redback.rest.api.model.User restUser = this.buildRestUser(user);
                restUser.setReadOnly(this.securitySystem.userManagerReadOnly());
                this.httpAuthenticator.authenticate((AuthenticationDataSource)authDataSource, this.httpServletRequest.getSession(true));
                return restUser;
            }
            if (securitySession.getAuthenticationResult() != null && securitySession.getAuthenticationResult().getAuthenticationFailureCauses() != null) {
                ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
                for (AuthenticationFailureCause authenticationFailureCause : securitySession.getAuthenticationResult().getAuthenticationFailureCauses()) {
                    if (authenticationFailureCause.getCause() == 1) {
                        errorMessages.add(new ErrorMessage("incorrect.username.password"));
                        continue;
                    }
                    errorMessages.add(new ErrorMessage().message(authenticationFailureCause.getMessage()));
                }
                throw new RedbackServiceException(errorMessages);
            }
            return null;
        }
        catch (AuthenticationException e) {
            throw new RedbackServiceException(e.getMessage(), Response.Status.FORBIDDEN.getStatusCode());
        }
        catch (UserNotFoundException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        catch (AccountLockedException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        catch (MustChangePasswordException e) {
            return this.buildRestUser(e.getUser());
        }
        catch (UserManagerException e) {
            this.log.info("UserManagerException: {}", (Object)e.getMessage());
            List<ErrorMessage> errorMessages = Arrays.asList(new ErrorMessage().message("UserManagerException: " + e.getMessage()));
            throw new RedbackServiceException(errorMessages);
        }
    }

    public org.apache.archiva.redback.rest.api.model.User isLogged() throws RedbackServiceException {
        SecuritySession securitySession = this.httpAuthenticator.getSecuritySession(this.httpServletRequest.getSession(true));
        Boolean isLogged = securitySession != null;
        this.log.debug("isLogged {}", (Object)isLogged);
        return isLogged != false && securitySession.getUser() != null ? this.buildRestUser(securitySession.getUser()) : null;
    }

    public Boolean logout() throws RedbackServiceException {
        HttpSession httpSession = this.httpServletRequest.getSession();
        if (httpSession != null) {
            httpSession.invalidate();
        }
        return Boolean.TRUE;
    }

    private Calendar getNowGMT() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    private org.apache.archiva.redback.rest.api.model.User buildRestUser(User user) {
        org.apache.archiva.redback.rest.api.model.User restUser = new org.apache.archiva.redback.rest.api.model.User();
        restUser.setEmail(user.getEmail());
        restUser.setUsername(user.getUsername());
        restUser.setPasswordChangeRequired(user.isPasswordChangeRequired());
        restUser.setLocked(user.isLocked());
        restUser.setValidated(user.isValidated());
        restUser.setFullName(user.getFullName());
        return restUser;
    }
}

