/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.archiva.redback.integration.model.AdminEditUserCredentials;
import org.apache.archiva.redback.integration.util.RoleSorter;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.rest.api.model.Application;
import org.apache.archiva.redback.rest.api.model.ApplicationRoles;
import org.apache.archiva.redback.rest.api.model.ErrorMessage;
import org.apache.archiva.redback.rest.api.model.RoleTemplate;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;
import org.apache.archiva.redback.rest.api.services.RoleManagementService;
import org.apache.archiva.redback.rest.services.RedbackAuthenticationThreadLocal;
import org.apache.archiva.redback.rest.services.RedbackRequestInformation;
import org.apache.archiva.redback.role.RoleManager;
import org.apache.archiva.redback.role.RoleManagerException;
import org.apache.archiva.redback.role.model.ModelApplication;
import org.apache.archiva.redback.role.model.ModelRole;
import org.apache.archiva.redback.role.model.ModelTemplate;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="roleManagementService#rest")
public class DefaultRoleManagementService
implements RoleManagementService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private RoleManager roleManager;
    private RBACManager rbacManager;
    private UserManager userManager;

    @Inject
    public DefaultRoleManagementService(RoleManager roleManager, @Named(value="rbacManager#default") RBACManager rbacManager, @Named(value="userManager#default") UserManager userManager) {
        this.roleManager = roleManager;
        this.rbacManager = rbacManager;
        this.userManager = userManager;
        this.log.debug("use rbacManager impl: {}", (Object)rbacManager.getClass().getName());
        this.log.debug("use userManager impl: {}", (Object)userManager.getClass().getName());
    }

    public Boolean createTemplatedRole(String templateId, String resource) throws RedbackServiceException {
        try {
            this.roleManager.createTemplatedRole(templateId, resource);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean removeTemplatedRole(String templateId, String resource) throws RedbackServiceException {
        try {
            this.roleManager.removeTemplatedRole(templateId, resource);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean updateRole(String templateId, String oldResource, String newResource) throws RedbackServiceException {
        try {
            this.roleManager.updateRole(templateId, oldResource, newResource);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean assignRole(String roleId, String principal) throws RedbackServiceException {
        try {
            this.roleManager.assignRole(roleId, principal);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean assignRoleByName(String roleName, String principal) throws RedbackServiceException {
        try {
            this.roleManager.assignRoleByName(roleName, principal);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean assignTemplatedRole(String templateId, String resource, String principal) throws RedbackServiceException {
        try {
            this.roleManager.assignTemplatedRole(templateId, resource, principal);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean unassignRole(String roleId, String principal) throws RedbackServiceException {
        try {
            this.roleManager.unassignRole(roleId, principal);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean unassignRoleByName(String roleName, String principal) throws RedbackServiceException {
        try {
            this.roleManager.unassignRoleByName(roleName, principal);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean roleExists(String roleId) throws RedbackServiceException {
        try {
            return this.roleManager.roleExists(roleId);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
    }

    public Boolean templatedRoleExists(String templateId, String resource) throws RedbackServiceException {
        try {
            return this.roleManager.templatedRoleExists(templateId, resource);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
    }

    public Boolean verifyTemplatedRole(String templateId, String resource) throws RedbackServiceException {
        try {
            this.roleManager.verifyTemplatedRole(templateId, resource);
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public List<org.apache.archiva.redback.rest.api.model.Role> getEffectivelyAssignedRoles(String username) throws RedbackServiceException {
        if (StringUtils.isEmpty((String)username)) {
            throw new RedbackServiceException(new ErrorMessage("user.cannot.be.null"));
        }
        try {
            List<Role> roles = this.filterAssignableRoles(this.rbacManager.getEffectivelyAssignedRoles(username));
            ArrayList<org.apache.archiva.redback.rest.api.model.Role> effectivelyAssignedRoles = new ArrayList<org.apache.archiva.redback.rest.api.model.Role>(roles.size());
            for (Role r : roles) {
                effectivelyAssignedRoles.add(new org.apache.archiva.redback.rest.api.model.Role(r));
            }
            Collections.sort(effectivelyAssignedRoles, RoleComparator.INSTANCE);
            return effectivelyAssignedRoles;
        }
        catch (RbacManagerException rbacManagerException) {
            return new ArrayList<org.apache.archiva.redback.rest.api.model.Role>(0);
        }
    }

    public List<Application> getApplications(String username) throws RedbackServiceException {
        List modelApplications = this.roleManager.getModel().getApplications();
        ArrayList<Application> applications = new ArrayList<Application>(modelApplications.size());
        for (ModelApplication modelApplication : modelApplications) {
            Application application = new Application();
            application.setDescription(modelApplication.getDescription());
            application.setId(modelApplication.getId());
            application.setLongDescription(modelApplication.getLongDescription());
            application.setVersion(modelApplication.getVersion());
            applications.add(application);
        }
        return applications;
    }

    public List<org.apache.archiva.redback.rest.api.model.Role> getAllRoles() throws RedbackServiceException {
        try {
            List<Role> roles = this.rbacManager.getAllRoles();
            if (roles == null) {
                return Collections.emptyList();
            }
            roles = this.filterRolesForCurrentUserAccess(roles);
            ArrayList<org.apache.archiva.redback.rest.api.model.Role> res = new ArrayList<org.apache.archiva.redback.rest.api.model.Role>(roles.size());
            for (Role r : roles) {
                res.add(new org.apache.archiva.redback.rest.api.model.Role(r));
            }
            return res;
        }
        catch (RbacManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
    }

    public List<org.apache.archiva.redback.rest.api.model.Role> getDetailedAllRoles() throws RedbackServiceException {
        try {
            List<Role> roles = this.rbacManager.getAllRoles();
            if (roles == null) {
                return Collections.emptyList();
            }
            roles = this.filterRolesForCurrentUserAccess(roles);
            ArrayList<org.apache.archiva.redback.rest.api.model.Role> res = new ArrayList<org.apache.archiva.redback.rest.api.model.Role>(roles.size());
            for (Role r : roles) {
                res.add(this.getRole(r.getName()));
            }
            return res;
        }
        catch (RbacManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
    }

    private List<Role> filterAssignableRoles(Collection<Role> roles) {
        ArrayList<Role> assignableRoles = new ArrayList<Role>(roles.size());
        for (Role r : roles) {
            if (!r.isAssignable()) continue;
            assignableRoles.add(r);
        }
        return assignableRoles;
    }

    public org.apache.archiva.redback.rest.api.model.Role getRole(String roleName) throws RedbackServiceException {
        try {
            org.apache.archiva.redback.rest.api.model.User user;
            List userParentAssignments;
            Role rbacRole = this.rbacManager.getRole(roleName);
            org.apache.archiva.redback.rest.api.model.Role role = new org.apache.archiva.redback.rest.api.model.Role(rbacRole);
            Map parentRoles = this.rbacManager.getParentRoles(rbacRole);
            for (String parentRoleName : parentRoles.keySet()) {
                role.getParentRoleNames().add(parentRoleName);
            }
            List userAssignments = this.rbacManager.getUserAssignmentsForRoles(Arrays.asList(roleName));
            if (userAssignments != null) {
                for (UserAssignment userAssignment : userAssignments) {
                    try {
                        User user2 = this.userManager.findUser(userAssignment.getPrincipal());
                        role.getUsers().add(new org.apache.archiva.redback.rest.api.model.User(user2));
                    }
                    catch (UserNotFoundException e) {
                        this.log.warn("User '{}' doesn't exist.", (Object)userAssignment.getPrincipal(), (Object)e);
                    }
                }
            }
            if (!role.getParentRoleNames().isEmpty() && (userParentAssignments = this.rbacManager.getUserAssignmentsForRoles(parentRoles.keySet())) != null) {
                for (UserAssignment userAssignment : userParentAssignments) {
                    try {
                        user = this.userManager.findUser(userAssignment.getPrincipal());
                        role.getParentsRolesUsers().add(new org.apache.archiva.redback.rest.api.model.User((User)user));
                    }
                    catch (UserNotFoundException e) {
                        this.log.warn("User '{}' doesn't exist.", (Object)userAssignment.getPrincipal(), (Object)e);
                    }
                }
            }
            ArrayList<org.apache.archiva.redback.rest.api.model.User> otherUsers = new ArrayList<org.apache.archiva.redback.rest.api.model.User>();
            for (User u : this.userManager.getUsers()) {
                user = new org.apache.archiva.redback.rest.api.model.User(u);
                if (role.getParentsRolesUsers().contains(user) || role.getUsers().contains(user)) continue;
                otherUsers.add(user);
            }
            role.setOtherUsers(otherUsers);
            return role;
        }
        catch (RbacManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
    }

    public Boolean updateRoleDescription(String roleName, String description) throws RedbackServiceException {
        try {
            Role rbacRole = this.rbacManager.getRole(roleName);
            rbacRole.setDescription(description);
            this.rbacManager.saveRole(rbacRole);
        }
        catch (RbacManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        return Boolean.TRUE;
    }

    public Boolean updateRoleUsers(org.apache.archiva.redback.rest.api.model.Role role) throws RedbackServiceException {
        UserAssignment assignment;
        String username;
        for (org.apache.archiva.redback.rest.api.model.User user : role.getUsers()) {
            username = user.getUsername();
            try {
                if (!this.userManager.userExists(username)) {
                    this.log.error("user {} not exits", (Object)username);
                    throw new RedbackServiceException(new ErrorMessage("user.not.exists", new String[]{username}));
                }
                assignment = this.rbacManager.userAssignmentExists(username) ? this.rbacManager.getUserAssignment(username) : this.rbacManager.createUserAssignment(username);
                assignment.addRoleName(role.getName());
                assignment = this.rbacManager.saveUserAssignment(assignment);
                this.log.info("{} role assigned to {}", (Object)role.getName(), (Object)username);
            }
            catch (RbacManagerException e) {
                this.log.error("error during assign role {}\u00a0to user {}", new Object[]{role.getName(), username, e});
                throw new RedbackServiceException(new ErrorMessage("error.assign.role.user", new String[]{role.getName(), username}));
            }
            catch (UserManagerException e) {
                throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
            }
        }
        for (org.apache.archiva.redback.rest.api.model.User user : role.getRemovedUsers()) {
            username = user.getUsername();
            try {
                if (!this.userManager.userExists(username)) {
                    this.log.error("user {} not exits", (Object)username);
                    throw new RedbackServiceException(new ErrorMessage("user.not.exists", new String[]{username}));
                }
                assignment = this.rbacManager.userAssignmentExists(username) ? this.rbacManager.getUserAssignment(username) : this.rbacManager.createUserAssignment(username);
                assignment.removeRoleName(role.getName());
                assignment = this.rbacManager.saveUserAssignment(assignment);
                this.log.info("{} role unassigned to {}", (Object)role.getName(), (Object)username);
            }
            catch (RbacManagerException e) {
                this.log.error("error during assign role {}\u00a0to user {}", new Object[]{role.getName(), username, e});
                throw new RedbackServiceException(new ErrorMessage("error.unassign.role.user", new String[]{role.getName(), username}));
            }
            catch (UserManagerException e) {
                throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
            }
        }
        return Boolean.TRUE;
    }

    public List<ApplicationRoles> getApplicationRoles(String username) throws RedbackServiceException {
        AdminEditUserCredentials user = null;
        if (StringUtils.isEmpty((String)username)) {
            throw new RedbackServiceException(new ErrorMessage("rbac.edit.user.empty.principal"));
        }
        try {
            if (!this.userManager.userExists(username)) {
                throw new RedbackServiceException(new ErrorMessage("user.does.not.exist", new String[]{username}));
            }
            User u = this.userManager.findUser(username);
            if (u == null) {
                throw new RedbackServiceException(new ErrorMessage("cannot.operate.on.null.user"));
            }
            user = new AdminEditUserCredentials(u);
        }
        catch (UserNotFoundException e) {
            throw new RedbackServiceException(new ErrorMessage("user.does.not.exist", new String[]{username, e.getMessage()}));
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        try {
            if (!this.rbacManager.userAssignmentExists(username)) {
                UserAssignment assignment = this.rbacManager.createUserAssignment(username);
                this.rbacManager.saveUserAssignment(assignment);
            }
            List<Role> allRoles = this.filterRolesForCurrentUserAccess(this.rbacManager.getAllRoles());
            List modelApplications = this.roleManager.getModel().getApplications();
            ArrayList<ApplicationRoles> applicationRolesList = new ArrayList<ApplicationRoles>(modelApplications.size());
            for (ModelApplication modelApplication : modelApplications) {
                ApplicationRoles applicationRoles = new ApplicationRoles();
                applicationRoles.setDescription(modelApplication.getDescription());
                applicationRoles.setName(modelApplication.getId());
                Collection<Role> appRoles = this.filterApplicationRoles(modelApplication, allRoles, modelApplication.getTemplates());
                ArrayList<String> roleNames = new ArrayList<String>(this.toRoleNames(appRoles));
                Collections.sort(roleNames);
                applicationRoles.setGlobalRoles(roleNames);
                Set<String> resources = this.discoverResources(modelApplication.getTemplates(), appRoles);
                applicationRoles.setResources(resources);
                applicationRoles.setRoleTemplates(this.toRoleTemplates(modelApplication.getTemplates()));
                ArrayList<String> appRoleNames = new ArrayList<String>(appRoles.size());
                for (String appRoleName : applicationRoles.getGlobalRoles()) {
                    if (this.roleFromTemplate(appRoleName, modelApplication.getTemplates())) continue;
                    appRoleNames.add(appRoleName);
                }
                Collections.sort(appRoleNames);
                applicationRoles.setGlobalRoles(appRoleNames);
                Collections.sort(appRoleNames);
                applicationRolesList.add(applicationRoles);
            }
            return applicationRolesList;
        }
        catch (RbacManagerException e) {
            RedbackServiceException redbackServiceException = new RedbackServiceException(new ErrorMessage(e.getMessage()));
            redbackServiceException.setHttpErrorCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            throw redbackServiceException;
        }
    }

    public Boolean updateUserRoles(org.apache.archiva.redback.rest.api.model.User user) throws RedbackServiceException {
        String username = user.getUsername();
        if (StringUtils.isEmpty((String)username)) {
            throw new RedbackServiceException(new ErrorMessage("rbac.edit.user.empty.principal"));
        }
        try {
            if (!this.userManager.userExists(username)) {
                throw new RedbackServiceException(new ErrorMessage("user.does.not.exist", new String[]{username}));
            }
            User u = this.userManager.findUser(username);
            if (u == null) {
                throw new RedbackServiceException(new ErrorMessage("cannot.operate.on.null.user"));
            }
        }
        catch (UserNotFoundException e) {
            throw new RedbackServiceException(new ErrorMessage("user.does.not.exist", new String[]{username, e.getMessage()}));
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        try {
            UserAssignment assignment = this.rbacManager.userAssignmentExists(username) ? this.rbacManager.getUserAssignment(username) : this.rbacManager.createUserAssignment(username);
            assignment.setRoleNames(user.getAssignedRoles());
            assignment = this.rbacManager.saveUserAssignment(assignment);
        }
        catch (RbacManagerException e) {
            RedbackServiceException redbackServiceException = new RedbackServiceException(new ErrorMessage(e.getMessage()));
            redbackServiceException.setHttpErrorCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            throw redbackServiceException;
        }
        return Boolean.TRUE;
    }

    private Role isInList(String roleName, Collection<Role> roles) {
        for (Role role : roles) {
            if (!roleName.equals(role.getName())) continue;
            return role;
        }
        return null;
    }

    private Collection<Role> filterApplicationRoles(ModelApplication application, List<Role> allRoles, List<ModelTemplate> applicationTemplates) {
        HashSet<Role> applicationRoles = new HashSet<Role>();
        List roles = application.getRoles();
        for (ModelRole modelRole : roles) {
            Role r = this.isInList(modelRole.getName(), allRoles);
            if (r == null) continue;
            applicationRoles.add(r);
        }
        List<String> roleNames = this.toRoleNames(allRoles);
        for (ModelTemplate modelTemplate : applicationTemplates) {
            for (Role r : allRoles) {
                if (!StringUtils.startsWith((String)r.getName(), (String)(modelTemplate.getNamePrefix() + modelTemplate.getDelimiter()))) continue;
                applicationRoles.add(r);
            }
        }
        return applicationRoles;
    }

    private boolean roleFromTemplate(String roleName, List<ModelTemplate> applicationTemplates) {
        for (ModelTemplate modelTemplate : applicationTemplates) {
            if (!StringUtils.startsWith((String)roleName, (String)(modelTemplate.getNamePrefix() + modelTemplate.getDelimiter()))) continue;
            return true;
        }
        return false;
    }

    private List<String> toRoleNames(Collection<Role> roles) {
        ArrayList<String> names = new ArrayList<String>(roles.size());
        for (Role r : roles) {
            names.add(r.getName());
        }
        return names;
    }

    private List<RoleTemplate> toRoleTemplates(List<ModelTemplate> modelTemplates) {
        if (modelTemplates == null || modelTemplates.isEmpty()) {
            return new ArrayList<RoleTemplate>(0);
        }
        ArrayList<RoleTemplate> roleTemplates = new ArrayList<RoleTemplate>(modelTemplates.size());
        for (ModelTemplate modelTemplate : modelTemplates) {
            RoleTemplate roleTemplate = new RoleTemplate();
            roleTemplate.setDelimiter(modelTemplate.getDelimiter());
            roleTemplate.setDescription(modelTemplate.getDescription());
            roleTemplate.setId(modelTemplate.getId());
            roleTemplate.setNamePrefix(modelTemplate.getNamePrefix());
            roleTemplates.add(roleTemplate);
        }
        return roleTemplates;
    }

    private Set<String> discoverResources(List<ModelTemplate> applicationTemplates, Collection<Role> roles) {
        HashSet<String> resources = new HashSet<String>();
        for (ModelTemplate modelTemplate : applicationTemplates) {
            for (Role role : roles) {
                String roleName = role.getName();
                if (!roleName.startsWith(modelTemplate.getNamePrefix())) continue;
                String delimiter = modelTemplate.getDelimiter();
                resources.add(roleName.substring(roleName.indexOf(delimiter) + delimiter.length()));
            }
        }
        return resources;
    }

    protected List<Role> filterRolesForCurrentUserAccess(List<Role> roleList) throws RedbackServiceException {
        RedbackRequestInformation redbackRequestInformation = RedbackAuthenticationThreadLocal.get();
        if (redbackRequestInformation == null || redbackRequestInformation.getUser() == null) {
            throw new RedbackServiceException(new ErrorMessage("login.mandatory"));
        }
        String currentUser = redbackRequestInformation.getUser().getUsername();
        ArrayList<Role> filteredRoleList = new ArrayList<Role>();
        try {
            Map assignedPermissionMap = this.rbacManager.getAssignedPermissionMap(currentUser);
            ArrayList<String> resourceGrants = new ArrayList<String>();
            if (assignedPermissionMap.containsKey("user-management-role-grant")) {
                List roleGrantPermissions = (List)assignedPermissionMap.get("user-management-role-grant");
                for (Permission permission : roleGrantPermissions) {
                    if (permission.getResource().getIdentifier().equals("*")) {
                        return roleList;
                    }
                    resourceGrants.add(permission.getResource().getIdentifier());
                }
            } else {
                return Collections.emptyList();
            }
            String delimiter = " - ";
            for (Role role : roleList) {
                int delimiterIndex = role.getName().indexOf(delimiter);
                for (String resourceIdentifier : resourceGrants) {
                    String resourceName;
                    if (role.getName().indexOf(resourceIdentifier) == -1 || delimiterIndex == -1 || !(resourceName = role.getName().substring(delimiterIndex + delimiter.length())).equals(resourceIdentifier)) continue;
                    filteredRoleList.add(role);
                }
            }
        }
        catch (RbacManagerException rme) {
            // empty catch block
        }
        Collections.sort(filteredRoleList, new RoleSorter());
        return filteredRoleList;
    }

    private static class RoleComparator
    implements Comparator<org.apache.archiva.redback.rest.api.model.Role> {
        private static RoleComparator INSTANCE = new RoleComparator();

        private RoleComparator() {
        }

        @Override
        public int compare(org.apache.archiva.redback.rest.api.model.Role role, org.apache.archiva.redback.rest.api.model.Role role2) {
            return role.getName().compareTo(role2.getName());
        }
    }
}

