/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.sf.ehcache.CacheManager;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.TokenBasedAuthenticationDataSource;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticator;
import org.apache.archiva.redback.integration.mail.Mailer;
import org.apache.archiva.redback.keys.AuthenticationKey;
import org.apache.archiva.redback.keys.KeyManager;
import org.apache.archiva.redback.keys.KeyManagerException;
import org.apache.archiva.redback.keys.KeyNotFoundException;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.policy.PasswordEncoder;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.RbacObjectNotFoundException;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.rest.api.model.ErrorMessage;
import org.apache.archiva.redback.rest.api.model.Operation;
import org.apache.archiva.redback.rest.api.model.RegistrationKey;
import org.apache.archiva.redback.rest.api.model.ResetPasswordRequest;
import org.apache.archiva.redback.rest.api.model.Resource;
import org.apache.archiva.redback.rest.api.model.UserRegistrationRequest;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;
import org.apache.archiva.redback.rest.api.services.UserService;
import org.apache.archiva.redback.rest.services.RedbackAuthenticationThreadLocal;
import org.apache.archiva.redback.rest.services.RedbackRequestInformation;
import org.apache.archiva.redback.rest.services.utils.PasswordValidator;
import org.apache.archiva.redback.role.RoleManager;
import org.apache.archiva.redback.role.RoleManagerException;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="userService#rest")
public class DefaultUserService
implements UserService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String VALID_USERNAME_CHARS = "[a-zA-Z_0-9\\-.@]*";
    private UserManager userManager;
    private SecuritySystem securitySystem;
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration config;
    @Inject
    private RoleManager roleManager;
    @Inject
    @Named(value="cache#userAssignments")
    private Cache userAssignmentsCache;
    @Inject
    @Named(value="cache#userPermissions")
    private Cache userPermissionsCache;
    @Inject
    @Named(value="cache#users")
    private Cache usersCache;
    @Inject
    private Mailer mailer;
    @Inject
    @Named(value="rbacManager#default")
    private RBACManager rbacManager;
    private HttpAuthenticator httpAuthenticator;
    @Inject
    private PasswordValidator passwordValidator;
    @Context
    private HttpServletRequest httpServletRequest;

    @Inject
    public DefaultUserService(@Named(value="userManager#default") UserManager userManager, SecuritySystem securitySystem, @Named(value="httpAuthenticator#basic") HttpAuthenticator httpAuthenticator) {
        this.userManager = userManager;
        this.securitySystem = securitySystem;
        this.httpAuthenticator = httpAuthenticator;
    }

    public Boolean createUser(org.apache.archiva.redback.rest.api.model.User user) throws RedbackServiceException {
        User u;
        try {
            u = this.userManager.findUser(user.getUsername());
            if (u != null) {
                throw new RedbackServiceException(new ErrorMessage("user " + user.getUsername() + " already exists"));
            }
        }
        catch (UserNotFoundException e) {
            this.log.debug("user {} not exists", (Object)user.getUsername());
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        if (StringUtils.isEmpty((String)user.getUsername())) {
            throw new RedbackServiceException(new ErrorMessage("username cannot be empty"));
        }
        if (StringUtils.isEmpty((String)user.getFullName())) {
            throw new RedbackServiceException(new ErrorMessage("fullName cannot be empty"));
        }
        if (StringUtils.isEmpty((String)user.getEmail())) {
            throw new RedbackServiceException(new ErrorMessage("email cannot be empty"));
        }
        try {
            u = this.userManager.createUser(user.getUsername(), user.getFullName(), user.getEmail());
            u.setPassword(user.getPassword());
            u.setLocked(user.isLocked());
            u.setPasswordChangeRequired(user.isPasswordChangeRequired());
            u.setPermanent(user.isPermanent());
            u.setValidated(user.isValidated());
            u = this.userManager.addUser(u);
            if (!user.isPasswordChangeRequired()) {
                u.setPasswordChangeRequired(false);
                try {
                    u = this.userManager.updateUser(u);
                    this.log.debug("user {} created", (Object)u.getUsername());
                }
                catch (UserNotFoundException e) {
                    throw new RedbackServiceException(e.getMessage());
                }
            }
            this.roleManager.assignRole("registered-user", u.getUsername());
        }
        catch (RoleManagerException rpe) {
            this.log.error("RoleProfile Error: {}", (Object)rpe.getMessage(), (Object)rpe);
            throw new RedbackServiceException(new ErrorMessage("assign.role.failure", null));
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        return Boolean.TRUE;
    }

    public Boolean deleteUser(String username) throws RedbackServiceException {
        try {
            if (this.rbacManager.userAssignmentExists(username)) {
                UserAssignment assignment = this.rbacManager.getUserAssignment(username);
                this.rbacManager.removeUserAssignment(assignment);
            }
        }
        catch (RbacManagerException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RedbackServiceException(e.getMessage());
        }
        try {
            this.userManager.deleteUser(username);
            Boolean e = Boolean.TRUE;
            return e;
        }
        catch (UserNotFoundException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RedbackServiceException(e.getMessage());
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        finally {
            this.removeFromCache(username);
        }
    }

    public org.apache.archiva.redback.rest.api.model.User getUser(String username) throws RedbackServiceException {
        try {
            User user = this.userManager.findUser(username);
            return this.getSimpleUser(user);
        }
        catch (UserNotFoundException e) {
            return null;
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
    }

    public List<org.apache.archiva.redback.rest.api.model.User> getUsers() throws RedbackServiceException {
        try {
            List users = this.userManager.getUsers();
            ArrayList<org.apache.archiva.redback.rest.api.model.User> simpleUsers = new ArrayList<org.apache.archiva.redback.rest.api.model.User>(users.size());
            for (User user : users) {
                simpleUsers.add(this.getSimpleUser(user));
            }
            return simpleUsers;
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
    }

    public Boolean updateMe(org.apache.archiva.redback.rest.api.model.User user) throws RedbackServiceException {
        RedbackRequestInformation redbackRequestInformation = RedbackAuthenticationThreadLocal.get();
        if (redbackRequestInformation == null || redbackRequestInformation.getUser() == null) {
            this.log.warn("RedbackRequestInformation from ThreadLocal is null");
            throw new RedbackServiceException(new ErrorMessage("you must be logged to update your profile"), Response.Status.FORBIDDEN.getStatusCode());
        }
        if (user == null) {
            throw new RedbackServiceException(new ErrorMessage("user parameter is mandatory"), Response.Status.BAD_REQUEST.getStatusCode());
        }
        if (!StringUtils.equals((String)redbackRequestInformation.getUser().getUsername(), (String)user.getUsername())) {
            throw new RedbackServiceException(new ErrorMessage("you can update only your profile"), Response.Status.FORBIDDEN.getStatusCode());
        }
        if (StringUtils.isEmpty((String)user.getPreviousPassword())) {
            throw new RedbackServiceException(new ErrorMessage("previous password is empty"), Response.Status.BAD_REQUEST.getStatusCode());
        }
        org.apache.archiva.redback.rest.api.model.User realUser = this.getUser(user.getUsername());
        try {
            String previousEncodedPassword = this.securitySystem.getUserManager().findUser(user.getUsername(), false).getEncodedPassword();
            PasswordEncoder encoder = this.securitySystem.getPolicy().getPasswordEncoder();
            if (!encoder.isPasswordValid(previousEncodedPassword, user.getPreviousPassword())) {
                throw new RedbackServiceException(new ErrorMessage("password.provided.does.not.match.existing"), Response.Status.BAD_REQUEST.getStatusCode());
            }
        }
        catch (UserNotFoundException e) {
            throw new RedbackServiceException(new ErrorMessage("user not found"), Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        realUser.setFullName(user.getFullName());
        realUser.setEmail(user.getEmail());
        if (StringUtils.isNotBlank((String)user.getPassword())) {
            this.passwordValidator.validatePassword(user.getPassword(), user.getUsername());
            realUser.setPassword(user.getPassword());
        }
        this.updateUser(realUser);
        return Boolean.TRUE;
    }

    public Boolean updateUser(org.apache.archiva.redback.rest.api.model.User user) throws RedbackServiceException {
        try {
            User rawUser = this.userManager.findUser(user.getUsername(), false);
            rawUser.setFullName(user.getFullName());
            rawUser.setEmail(user.getEmail());
            rawUser.setValidated(user.isValidated());
            rawUser.setLocked(user.isLocked());
            rawUser.setPassword(user.getPassword());
            rawUser.setPasswordChangeRequired(user.isPasswordChangeRequired());
            rawUser.setPermanent(user.isPermanent());
            this.userManager.updateUser(rawUser);
            return Boolean.TRUE;
        }
        catch (UserNotFoundException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
    }

    public int removeFromCache(String userName) throws RedbackServiceException {
        String[] caches;
        if (this.userAssignmentsCache != null) {
            this.userAssignmentsCache.remove((Object)userName);
        }
        if (this.userPermissionsCache != null) {
            this.userPermissionsCache.remove((Object)userName);
        }
        if (this.usersCache != null) {
            this.usersCache.remove((Object)userName);
        }
        CacheManager cacheManager = CacheManager.getInstance();
        for (String cacheName : caches = cacheManager.getCacheNames()) {
            if (!StringUtils.startsWith((String)cacheName, (String)"org.apache.archiva.redback.rbac.jdo")) continue;
            cacheManager.getCache(cacheName).removeAll();
        }
        return 0;
    }

    public org.apache.archiva.redback.rest.api.model.User getGuestUser() throws RedbackServiceException {
        try {
            User user = this.userManager.getGuestUser();
            return this.getSimpleUser(user);
        }
        catch (Exception e) {
            return null;
        }
    }

    public org.apache.archiva.redback.rest.api.model.User createGuestUser() throws RedbackServiceException {
        org.apache.archiva.redback.rest.api.model.User u = this.getGuestUser();
        if (u != null) {
            return u;
        }
        try {
            this.securitySystem.getPolicy().setEnabled(false);
            User user = this.userManager.createGuestUser();
            user.setPasswordChangeRequired(false);
            user = this.userManager.updateUser(user, false);
            this.roleManager.assignRole(this.config.getString("redback.default.guest"), user.getUsername());
            org.apache.archiva.redback.rest.api.model.User user2 = this.getSimpleUser(user);
            return user2;
        }
        catch (RoleManagerException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RedbackServiceException(e.getMessage());
        }
        catch (UserNotFoundException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RedbackServiceException(e.getMessage());
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        finally {
            if (!this.securitySystem.getPolicy().isEnabled()) {
                this.securitySystem.getPolicy().setEnabled(true);
            }
        }
    }

    public Boolean ping() throws RedbackServiceException {
        return Boolean.TRUE;
    }

    private org.apache.archiva.redback.rest.api.model.User getSimpleUser(User user) {
        if (user == null) {
            return null;
        }
        return new org.apache.archiva.redback.rest.api.model.User(user);
    }

    public Boolean createAdminUser(org.apache.archiva.redback.rest.api.model.User adminUser) throws RedbackServiceException {
        if (this.isAdminUserExists().booleanValue()) {
            return Boolean.FALSE;
        }
        try {
            User user = this.userManager.createUser("admin", adminUser.getFullName(), adminUser.getEmail());
            user.setPassword(adminUser.getPassword());
            user.setLocked(false);
            user.setPasswordChangeRequired(false);
            user.setPermanent(true);
            user.setValidated(true);
            this.userManager.addUser(user);
            this.roleManager.assignRole("system-administrator", user.getUsername());
        }
        catch (RoleManagerException e) {
            throw new RedbackServiceException(e.getMessage());
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        return Boolean.TRUE;
    }

    public Boolean isAdminUserExists() throws RedbackServiceException {
        try {
            this.userManager.findUser(this.config.getString("redback.default.admin"));
            return Boolean.TRUE;
        }
        catch (UserNotFoundException e) {
        }
        catch (UserManagerException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof UserNotFoundException) {
                return Boolean.FALSE;
            }
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        return Boolean.FALSE;
    }

    public Boolean resetPassword(ResetPasswordRequest resetPasswordRequest) throws RedbackServiceException {
        String username = resetPasswordRequest.getUsername();
        if (StringUtils.isEmpty((String)username)) {
            throw new RedbackServiceException(new ErrorMessage("username.cannot.be.empty"));
        }
        UserManager userManager = this.securitySystem.getUserManager();
        KeyManager keyManager = this.securitySystem.getKeyManager();
        UserSecurityPolicy policy = this.securitySystem.getPolicy();
        try {
            User user = userManager.findUser(username);
            AuthenticationKey authkey = keyManager.createKey(username, "Password Reset Request", policy.getUserValidationSettings().getEmailValidationTimeout());
            String applicationUrl = resetPasswordRequest.getApplicationUrl();
            if (StringUtils.isBlank((String)applicationUrl)) {
                applicationUrl = this.getBaseUrl();
            }
            this.mailer.sendPasswordResetEmail(Arrays.asList(user.getEmail()), authkey, applicationUrl);
            this.log.info("password reset request for username {}", (Object)username);
        }
        catch (UserNotFoundException e) {
            this.log.info("Password Reset on non-existant user [{}].", (Object)username);
            throw new RedbackServiceException(new ErrorMessage("password.reset.failure"));
        }
        catch (KeyManagerException e) {
            this.log.info("Unable to issue password reset.", (Throwable)e);
            throw new RedbackServiceException(new ErrorMessage("password.reset.email.generation.failure"));
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        return Boolean.TRUE;
    }

    public RegistrationKey registerUser(UserRegistrationRequest userRegistrationRequest) throws RedbackServiceException {
        org.apache.archiva.redback.rest.api.model.User user = userRegistrationRequest.getUser();
        if (user == null) {
            throw new RedbackServiceException(new ErrorMessage("invalid.user.credentials", null));
        }
        UserSecurityPolicy securityPolicy = this.securitySystem.getPolicy();
        boolean emailValidationRequired = securityPolicy.getUserValidationSettings().isEmailValidationRequired();
        if (emailValidationRequired) {
            this.validateCredentialsLoose(user);
        } else {
            this.validateCredentialsStrict(user);
        }
        User u = null;
        try {
            if (this.userManager.userExists(user.getUsername())) {
                throw new RedbackServiceException(new ErrorMessage("user.already.exists", new String[]{user.getUsername()}));
            }
            u = this.userManager.createUser(user.getUsername(), user.getFullName(), user.getEmail());
            u.setPassword(user.getPassword());
            u.setValidated(false);
            u.setLocked(false);
            this.roleManager.assignRole("registered-user", u.getUsername());
        }
        catch (RoleManagerException rpe) {
            this.log.error("RoleProfile Error: {}", (Object)rpe.getMessage(), (Object)rpe);
            throw new RedbackServiceException(new ErrorMessage("assign.role.failure", null));
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
        if (emailValidationRequired) {
            u.setLocked(true);
            try {
                AuthenticationKey authkey = this.securitySystem.getKeyManager().createKey(u.getUsername(), "New User Email Validation", securityPolicy.getUserValidationSettings().getEmailValidationTimeout());
                String baseUrl = userRegistrationRequest.getApplicationUrl();
                if (StringUtils.isBlank((String)baseUrl)) {
                    baseUrl = this.getBaseUrl();
                }
                this.log.debug("register user {} with email {} and app url {}", new Object[]{u.getUsername(), u.getEmail(), baseUrl});
                this.mailer.sendAccountValidationEmail(Arrays.asList(u.getEmail()), authkey, baseUrl);
                securityPolicy.setEnabled(false);
                this.userManager.addUser(u);
                RegistrationKey registrationKey = new RegistrationKey(authkey.getKey());
                return registrationKey;
            }
            catch (KeyManagerException e) {
                this.log.error("Unable to register a new user.", (Throwable)e);
                throw new RedbackServiceException(new ErrorMessage("cannot.register.user", null));
            }
            catch (UserManagerException e) {
                throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
            }
            finally {
                securityPolicy.setEnabled(true);
            }
        }
        try {
            this.userManager.addUser(u);
            return new RegistrationKey("-1");
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
    }

    public Boolean validateUserFromKey(String key) throws RedbackServiceException {
        String principal = null;
        try {
            AuthenticationKey authkey = this.securitySystem.getKeyManager().findKey(key);
            User user = this.securitySystem.getUserManager().findUser(authkey.getForPrincipal());
            user.setValidated(true);
            user.setLocked(false);
            user.setPasswordChangeRequired(true);
            user.setEncodedPassword("");
            principal = user.getUsername();
            TokenBasedAuthenticationDataSource authsource = new TokenBasedAuthenticationDataSource();
            authsource.setPrincipal(principal);
            authsource.setToken(authkey.getKey());
            authsource.setEnforcePasswordChange(false);
            this.securitySystem.getUserManager().updateUser(user);
            this.httpAuthenticator.authenticate((AuthenticationDataSource)authsource, this.httpServletRequest.getSession(true));
            this.log.info("account validated for user {}", (Object)user.getUsername());
            return Boolean.TRUE;
        }
        catch (MustChangePasswordException e) {
            throw new RedbackServiceException(e.getMessage(), Response.Status.FORBIDDEN.getStatusCode());
        }
        catch (KeyNotFoundException e) {
            this.log.info("Invalid key requested: {}", (Object)key);
            throw new RedbackServiceException(new ErrorMessage("cannot.find.key"));
        }
        catch (KeyManagerException e) {
            throw new RedbackServiceException(new ErrorMessage("cannot.find.key.at.the.momment"));
        }
        catch (UserNotFoundException e) {
            throw new RedbackServiceException(new ErrorMessage("cannot.find.user", new String[]{principal}));
        }
        catch (AccountLockedException e) {
            throw new RedbackServiceException(e.getMessage(), Response.Status.FORBIDDEN.getStatusCode());
        }
        catch (AuthenticationException e) {
            throw new RedbackServiceException(e.getMessage(), Response.Status.FORBIDDEN.getStatusCode());
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
    }

    public Collection<org.apache.archiva.redback.rest.api.model.Permission> getCurrentUserPermissions() throws RedbackServiceException {
        RedbackRequestInformation redbackRequestInformation = RedbackAuthenticationThreadLocal.get();
        String userName = "guest";
        if (redbackRequestInformation != null && redbackRequestInformation.getUser() != null) {
            userName = redbackRequestInformation.getUser().getUsername();
        } else {
            this.log.warn("RedbackRequestInformation from ThreadLocal is null");
        }
        return this.getUserPermissions(userName);
    }

    public Collection<Operation> getCurrentUserOperations() throws RedbackServiceException {
        RedbackRequestInformation redbackRequestInformation = RedbackAuthenticationThreadLocal.get();
        String userName = "guest";
        if (redbackRequestInformation != null && redbackRequestInformation.getUser() != null) {
            userName = redbackRequestInformation.getUser().getUsername();
        } else {
            this.log.warn("RedbackRequestInformation from ThreadLocal is null");
        }
        return this.getUserOperations(userName);
    }

    public Collection<Operation> getUserOperations(String userName) throws RedbackServiceException {
        Collection<org.apache.archiva.redback.rest.api.model.Permission> permissions = this.getUserPermissions(userName);
        ArrayList<Operation> operations = new ArrayList<Operation>(permissions.size());
        for (org.apache.archiva.redback.rest.api.model.Permission permission : permissions) {
            if (permission.getOperation() == null) continue;
            Operation operation = new Operation();
            operation.setName(permission.getOperation().getName());
            operations.add(operation);
        }
        return operations;
    }

    public Collection<org.apache.archiva.redback.rest.api.model.Permission> getUserPermissions(String userName) throws RedbackServiceException {
        try {
            Set permissions = this.rbacManager.getAssignedPermissions(userName);
            ArrayList<org.apache.archiva.redback.rest.api.model.Permission> userPermissions = new ArrayList<org.apache.archiva.redback.rest.api.model.Permission>(permissions.size());
            for (Permission p : permissions) {
                org.apache.archiva.redback.rest.api.model.Permission permission = new org.apache.archiva.redback.rest.api.model.Permission();
                permission.setName(p.getName());
                if (p.getOperation() != null) {
                    Operation operation = new Operation();
                    operation.setName(p.getOperation().getName());
                    permission.setOperation(operation);
                }
                if (p.getResource() != null) {
                    Resource resource = new Resource();
                    resource.setIdentifier(p.getResource().getIdentifier());
                    resource.setPattern(p.getResource().isPattern());
                    permission.setResource(resource);
                }
                userPermissions.add(permission);
            }
            return userPermissions;
        }
        catch (RbacObjectNotFoundException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RedbackServiceException(e.getMessage());
        }
        catch (RbacManagerException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RedbackServiceException(e.getMessage());
        }
    }

    public void validateCredentialsLoose(org.apache.archiva.redback.rest.api.model.User user) throws RedbackServiceException {
        RedbackServiceException redbackServiceException = new RedbackServiceException("issues during validating user");
        if (StringUtils.isEmpty((String)user.getUsername())) {
            redbackServiceException.addErrorMessage(new ErrorMessage("username.required", null));
        } else if (!user.getUsername().matches(VALID_USERNAME_CHARS)) {
            redbackServiceException.addErrorMessage(new ErrorMessage("username.invalid.characters", null));
        }
        if (StringUtils.isEmpty((String)user.getFullName())) {
            redbackServiceException.addErrorMessage(new ErrorMessage("fullName.required", null));
        }
        if (StringUtils.isEmpty((String)user.getEmail())) {
            redbackServiceException.addErrorMessage(new ErrorMessage("email.required", null));
        }
        if (!StringUtils.equals((String)user.getPassword(), (String)user.getConfirmPassword())) {
            redbackServiceException.addErrorMessage(new ErrorMessage("passwords.does.not.match", null));
        }
        try {
            if (!org.codehaus.plexus.util.StringUtils.isEmpty((String)user.getEmail())) {
                new InternetAddress(user.getEmail(), true);
            }
        }
        catch (AddressException e) {
            redbackServiceException.addErrorMessage(new ErrorMessage("email.invalid", null));
        }
        if (!redbackServiceException.getErrorMessages().isEmpty()) {
            throw redbackServiceException;
        }
    }

    public void validateCredentialsStrict(org.apache.archiva.redback.rest.api.model.User user) throws RedbackServiceException {
        this.validateCredentialsLoose(user);
        try {
            User tmpuser = this.userManager.createUser(user.getUsername(), user.getFullName(), user.getEmail());
            user.setPassword(user.getPassword());
            this.securitySystem.getPolicy().validatePassword(tmpuser);
            if (org.codehaus.plexus.util.StringUtils.isEmpty((String)user.getPassword())) {
                throw new RedbackServiceException(new ErrorMessage("password.required", null));
            }
        }
        catch (UserManagerException e) {
            throw new RedbackServiceException(new ErrorMessage(e.getMessage()));
        }
    }

    private String getBaseUrl() {
        if (this.httpServletRequest != null && this.httpServletRequest != null) {
            return this.httpServletRequest.getScheme() + "://" + this.httpServletRequest.getServerName() + (this.httpServletRequest.getServerPort() == 80 ? "" : ":" + this.httpServletRequest.getServerPort()) + this.httpServletRequest.getContextPath();
        }
        return null;
    }

    public Boolean unlockUser(String username) throws RedbackServiceException {
        org.apache.archiva.redback.rest.api.model.User user = this.getUser(username);
        if (user != null) {
            user.setLocked(false);
            this.updateUser(user);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean lockUser(String username) throws RedbackServiceException {
        org.apache.archiva.redback.rest.api.model.User user = this.getUser(username);
        if (user != null) {
            user.setLocked(true);
            this.updateUser(user);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean passwordChangeRequired(String username) throws RedbackServiceException {
        org.apache.archiva.redback.rest.api.model.User user = this.getUser(username);
        if (user == null) {
            user.setPasswordChangeRequired(true);
            this.updateUser(user);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean passwordChangeNotRequired(String username) throws RedbackServiceException {
        org.apache.archiva.redback.rest.api.model.User user = this.getUser(username);
        if (user == null) {
            user.setPasswordChangeRequired(false);
            this.updateUser(user);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

