/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;
import org.apache.archiva.redback.rest.api.services.UtilServices;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="utilServices#rest")
public class DefaultUtilServices
implements UtilServices {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> cachei18n = new ConcurrentHashMap<String, String>();

    @PostConstruct
    public void init() throws RedbackServiceException {
        this.getI18nProperties("en");
        this.getI18nProperties("fr");
    }

    public String getI18nResources(String locale) throws RedbackServiceException {
        String cachedi18n = this.cachei18n.get(StringUtils.isEmpty((String)locale) ? "en" : StringUtils.lowerCase((String)locale));
        if (cachedi18n != null) {
            return cachedi18n;
        }
        Properties properties = new Properties();
        try {
            this.loadResource(properties, "org/apache/archiva/redback/users/messages", null);
            this.loadResource(properties, "org/apache/archiva/redback/users/messages", locale);
        }
        catch (IOException e) {
            this.log.warn("skip error loading properties {}", (Object)"org/apache/archiva/redback/users/messages");
        }
        try {
            this.loadResource(properties, "org/apache/archiva/redback/i18n/default", null);
            this.loadResource(properties, "org/apache/archiva/redback/i18n/default", locale);
        }
        catch (IOException e) {
            this.log.warn("skip error loading properties {}", (Object)"org/apache/archiva/redback/i18n/default");
        }
        StringBuilder output = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            output.append((String)entry.getKey()).append('=').append((String)entry.getValue());
            output.append('\n');
        }
        this.cachei18n.put(StringUtils.isEmpty((String)locale) ? "en" : StringUtils.lowerCase((String)locale), output.toString());
        return output.toString();
    }

    public Properties getI18nProperties(String locale) throws RedbackServiceException {
        try {
            Properties properties = new Properties();
            this.loadResource(properties, "org/apache/archiva/redback/users/messages", null);
            this.loadResource(properties, "org/apache/archiva/redback/users/messages", locale);
            this.loadResource(properties, "org/apache/archiva/redback/i18n/default", null);
            this.loadResource(properties, "org/apache/archiva/redback/i18n/default", locale);
            return properties;
        }
        catch (IOException e) {
            throw new RedbackServiceException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(Properties finalProperties, String resourceName, String locale) throws IOException {
        InputStream is = null;
        Properties properties = new Properties();
        try {
            if (StringUtils.isNotEmpty((String)locale)) {
                resourceName = resourceName + "_" + locale;
            }
            resourceName = resourceName + ".properties";
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            if (is != null) {
                properties.load(is);
                finalProperties.putAll((Map<?, ?>)properties);
            } else if (!StringUtils.equalsIgnoreCase((String)locale, (String)"en")) {
                this.log.info("cannot load resource {}", (Object)resourceName);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

