/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services.interceptors;

import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authorization.AuthorizationException;
import org.apache.archiva.redback.authorization.AuthorizationResult;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.redback.integration.filter.authentication.basic.HttpBasicAuthentication;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.rest.services.interceptors.AbstractInterceptor;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="permissionInterceptor#rest")
@Provider
public class PermissionsInterceptor
extends AbstractInterceptor
implements ContainerRequestFilter {
    @Inject
    @Named(value="securitySystem")
    private SecuritySystem securitySystem;
    @Inject
    @Named(value="httpAuthenticator#basic")
    private HttpBasicAuthentication httpAuthenticator;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void filter(ContainerRequestContext containerRequestContext) {
        Message message = JAXRSUtils.getCurrentMessage();
        RedbackAuthorization redbackAuthorization = this.getRedbackAuthorization(message);
        if (redbackAuthorization != null) {
            int len$;
            String[] arr$;
            AuthenticationResult authenticationResult;
            SecuritySession securitySession;
            block16: {
                if (redbackAuthorization.noRestriction()) {
                    this.log.debug("redbackAuthorization.noRestriction() so skip permission check");
                    return;
                }
                String[] permissions = redbackAuthorization.permissions();
                if (!(permissions == null || permissions.length <= 0 || permissions.length == 1 && StringUtils.isEmpty((String)permissions[0]))) {
                    HttpServletRequest request = this.getHttpServletRequest(message);
                    securitySession = this.httpAuthenticator.getSecuritySession(request.getSession());
                    authenticationResult = (AuthenticationResult)message.get(AuthenticationResult.class);
                    this.log.debug("authenticationResult from message: {}", (Object)authenticationResult);
                    if (authenticationResult == null) {
                        try {
                            authenticationResult = this.httpAuthenticator.getAuthenticationResult(request, this.getHttpServletResponse(message));
                            this.log.debug("authenticationResult from request: {}", (Object)authenticationResult);
                        }
                        catch (AuthenticationException e) {
                            this.log.debug("failed to authenticate for path {}", message.get((Object)"org.apache.cxf.request.uri"));
                            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                            return;
                        }
                        catch (AccountLockedException e) {
                            this.log.debug("account locked for path {}", message.get((Object)"org.apache.cxf.request.uri"));
                            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                            return;
                        }
                        catch (MustChangePasswordException e) {
                            this.log.debug("must change password for path {}", message.get((Object)"org.apache.cxf.request.uri"));
                            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                            return;
                        }
                    }
                    if (authenticationResult != null && authenticationResult.isAuthenticated()) {
                        message.put(AuthenticationResult.class, (Object)authenticationResult);
                        arr$ = permissions;
                        len$ = arr$.length;
                        break block16;
                    } else {
                        if (securitySession != null && securitySession.getUser() != null) {
                            this.log.debug("user {} not authenticated", (Object)securitySession.getUser().getUsername());
                        }
                        return;
                    }
                }
                if (redbackAuthorization.noPermission()) {
                    this.log.debug("path {} doesn't need special permission", message.get((Object)"org.apache.cxf.request.uri"));
                    return;
                }
                containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                return;
            }
            for (int i$ = 0; i$ < len$; ++i$) {
                String permission = arr$[i$];
                this.log.debug("check permission: {} with securitySession {}", (Object)permission, (Object)securitySession);
                if (StringUtils.isBlank((String)permission)) continue;
                try {
                    AuthorizationResult authorizationResult = this.securitySystem.authorize(authenticationResult.getUser(), permission, StringUtils.isBlank((String)redbackAuthorization.resource()) ? null : redbackAuthorization.resource());
                    if (authenticationResult != null && authorizationResult.isAuthorized()) {
                        this.log.debug("isAuthorized for permission {}", (Object)permission);
                        return;
                    }
                    if (securitySession == null || securitySession.getUser() == null) continue;
                    this.log.debug("user {} not authorized for permission {}", (Object)securitySession.getUser().getUsername(), (Object)permission);
                    continue;
                }
                catch (AuthorizationException e) {
                    this.log.debug(" AuthorizationException " + e.getMessage() + " checking permission " + permission, (Throwable)e);
                    containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                    return;
                }
            }
        }
        this.log.warn("http path {} doesn't contain any informations regarding permissions ", message.get((Object)"org.apache.cxf.request.uri"));
        containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
    }
}

