/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services.utils;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.archiva.redback.system.check.EnvironmentCheck;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="environmentChecker#rest")
public class EnvironmentChecker {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Inject
    public EnvironmentChecker(ApplicationContext applicationContext) {
        Collection checkers = applicationContext.getBeansOfType(EnvironmentCheck.class).values();
        StopWatch stopWatch = new StopWatch();
        stopWatch.reset();
        stopWatch.start();
        if (checkers != null) {
            ArrayList violations = new ArrayList();
            for (EnvironmentCheck check : checkers) {
                check.validateEnvironment(violations);
            }
            if (!violations.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                msg.append("EnvironmentCheck Failure.\n");
                msg.append("======================================================================\n");
                msg.append(" ENVIRONMENT FAILURE !! \n");
                msg.append("\n");
                for (String v : violations) {
                    msg.append(v).append("\n");
                }
                msg.append("\n");
                msg.append("======================================================================");
                this.log.error(msg.toString());
            }
        }
        stopWatch.stop();
        this.log.info("time to execute all EnvironmentCheck: {} ms", (Object)stopWatch.getTime());
    }
}

