/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.system;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationManager;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authorization.AuthorizationDataSource;
import org.apache.archiva.redback.authorization.AuthorizationException;
import org.apache.archiva.redback.authorization.AuthorizationResult;
import org.apache.archiva.redback.authorization.Authorizer;
import org.apache.archiva.redback.keys.KeyManager;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.system.DefaultSecuritySession;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="securitySystem")
public class DefaultSecuritySystem
implements SecuritySystem {
    private Logger log = LoggerFactory.getLogger(DefaultSecuritySystem.class);
    @Inject
    private AuthenticationManager authnManager;
    @Inject
    @Named(value="authorizer#default")
    private Authorizer authorizer;
    @Inject
    @Named(value="userManager#default")
    private UserManager userManager;
    @Inject
    @Named(value="keyManager#cached")
    private KeyManager keyManager;
    @Inject
    private UserSecurityPolicy policy;

    @Override
    public SecuritySession authenticate(AuthenticationDataSource source) throws AuthenticationException, UserNotFoundException, AccountLockedException, MustChangePasswordException, UserManagerException {
        AuthenticationResult result = this.authnManager.authenticate(source);
        this.log.debug("authnManager.authenticate() result: {}", (Object)result);
        if (result.isAuthenticated()) {
            this.log.debug("User '{}' authenticated.", (Object)result.getPrincipal());
            User user = this.userManager.findUser(result.getPrincipal());
            if (user != null) {
                this.log.debug("User '{}' exists.", (Object)result.getPrincipal());
                this.log.debug("User: {}", (Object)user);
                return new DefaultSecuritySession(result, user);
            }
            this.log.debug("User '{}' DOES NOT exist.", (Object)result.getPrincipal());
            return new DefaultSecuritySession(result);
        }
        this.log.debug("User '{}' IS NOT authenticated.", (Object)result.getPrincipal());
        return new DefaultSecuritySession(result);
    }

    @Override
    public boolean isAuthenticated(AuthenticationDataSource source) throws AuthenticationException, UserNotFoundException, AccountLockedException, MustChangePasswordException, UserManagerException {
        return this.authenticate(source).getAuthenticationResult().isAuthenticated();
    }

    public String getAuthenticatorId() {
        if (this.authnManager == null) {
            return "<null>";
        }
        return this.authnManager.getId();
    }

    @Override
    public AuthorizationResult authorize(SecuritySession session, String permission) throws AuthorizationException {
        return this.authorize(session, permission, null);
    }

    @Override
    public AuthorizationResult authorize(SecuritySession session, String permission, String resource) throws AuthorizationException {
        User user;
        AuthorizationDataSource source = null;
        if (session != null && (user = session.getUser()) != null) {
            source = new AuthorizationDataSource(user.getUsername(), user, permission, resource);
        }
        if (source == null) {
            source = new AuthorizationDataSource(null, null, permission, resource);
        }
        return this.authorizer.isAuthorized(source);
    }

    @Override
    public AuthorizationResult authorize(User user, String permission, String resource) throws AuthorizationException {
        AuthorizationDataSource source = null;
        if (user != null) {
            source = new AuthorizationDataSource(user.getUsername(), user, permission, resource);
        }
        if (source == null) {
            source = new AuthorizationDataSource(null, null, permission, resource);
        }
        return this.authorizer.isAuthorized(source);
    }

    @Override
    public boolean isAuthorized(SecuritySession session, String permission) throws AuthorizationException {
        return this.isAuthorized(session, permission, null);
    }

    @Override
    public boolean isAuthorized(SecuritySession session, String permission, String resource) throws AuthorizationException {
        return this.authorize(session, permission, resource).isAuthorized();
    }

    public String getAuthorizerId() {
        if (this.authorizer == null) {
            return "<null>";
        }
        return this.authorizer.getId();
    }

    @Override
    public UserManager getUserManager() {
        return this.userManager;
    }

    public String getUserManagementId() {
        if (this.userManager == null) {
            return "<null>";
        }
        return this.userManager.getId();
    }

    @Override
    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public String getKeyManagementId() {
        if (this.keyManager == null) {
            return "<null>";
        }
        return this.keyManager.getId();
    }

    @Override
    public UserSecurityPolicy getPolicy() {
        return this.policy;
    }

    public String getPolicyId() {
        if (this.policy == null) {
            return "<null>";
        }
        return this.policy.getId();
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authnManager;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public AuthenticationManager getAuthnManager() {
        return this.authnManager;
    }

    public void setAuthnManager(AuthenticationManager authnManager) {
        this.authnManager = authnManager;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setPolicy(UserSecurityPolicy policy) {
        this.policy = policy;
    }

    @Override
    public boolean userManagerReadOnly() {
        return this.userManager.isReadOnly();
    }
}

