/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.users.cached;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserManagerListener;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.archiva.redback.users.UserQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="userManager#cached")
public class CachedUserManager
implements UserManager,
UserManagerListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="userManager#default")
    private UserManager userImpl;
    @Inject
    @Named(value="cache#users")
    private Cache<String, User> usersCache;

    public boolean isReadOnly() {
        return this.userImpl.isReadOnly();
    }

    public User createGuestUser() throws UserManagerException {
        return this.userImpl.createGuestUser();
    }

    public User addUser(User user) throws UserManagerException {
        if (user != null) {
            this.usersCache.remove((Object)user.getUsername());
        }
        return this.userImpl.addUser(user);
    }

    public void addUserManagerListener(UserManagerListener listener) {
        this.userImpl.addUserManagerListener(listener);
    }

    public void addUserUnchecked(User user) throws UserManagerException {
        if (user != null) {
            this.usersCache.remove((Object)user.getUsername());
        }
        this.userImpl.addUserUnchecked(user);
    }

    public User createUser(String username, String fullName, String emailAddress) throws UserManagerException {
        this.usersCache.remove((Object)username);
        return this.userImpl.createUser(username, fullName, emailAddress);
    }

    public void deleteUser(String username) throws UserNotFoundException, UserManagerException {
        this.usersCache.remove((Object)username);
        this.userImpl.deleteUser(username);
    }

    public void eraseDatabase() {
        try {
            this.userImpl.eraseDatabase();
        }
        finally {
            this.usersCache.clear();
        }
    }

    public User findUser(String username) throws UserNotFoundException, UserManagerException {
        if ("guest".equals(username)) {
            return this.getGuestUser();
        }
        User el = (User)this.usersCache.get((Object)username);
        if (el != null) {
            return el;
        }
        User user = this.userImpl.findUser(username);
        this.usersCache.put((Object)username, (Object)user);
        return user;
    }

    public User findUser(String username, boolean useCache) throws UserNotFoundException, UserManagerException {
        return this.findUser(username);
    }

    public User getGuestUser() throws UserNotFoundException, UserManagerException {
        User el = (User)this.usersCache.get((Object)"guest");
        if (el != null) {
            return el;
        }
        User user = this.userImpl.getGuestUser();
        this.usersCache.put((Object)"guest", (Object)user);
        return user;
    }

    public UserQuery createUserQuery() {
        return this.userImpl.createUserQuery();
    }

    public List<User> findUsersByQuery(UserQuery query) throws UserManagerException {
        this.log.debug("NOT CACHED - .findUsersByQuery(UserQuery)");
        return this.userImpl.findUsersByQuery(query);
    }

    public List<User> findUsersByEmailKey(String emailKey, boolean orderAscending) throws UserManagerException {
        this.log.debug("NOT CACHED - .findUsersByEmailKey(String, boolean)");
        return this.userImpl.findUsersByEmailKey(emailKey, orderAscending);
    }

    public List<User> findUsersByFullNameKey(String fullNameKey, boolean orderAscending) throws UserManagerException {
        this.log.debug("NOT CACHED - .findUsersByFullNameKey(String, boolean)");
        return this.userImpl.findUsersByFullNameKey(fullNameKey, orderAscending);
    }

    public List<User> findUsersByUsernameKey(String usernameKey, boolean orderAscending) throws UserManagerException {
        this.log.debug("NOT CACHED - .findUsersByUsernameKey(String, boolean)");
        return this.userImpl.findUsersByUsernameKey(usernameKey, orderAscending);
    }

    public String getId() {
        return "cached";
    }

    public List<User> getUsers() throws UserManagerException {
        this.log.debug("NOT CACHED - .getUsers()");
        return this.userImpl.getUsers();
    }

    public List<User> getUsers(boolean orderAscending) throws UserManagerException {
        this.log.debug("NOT CACHED - .getUsers(boolean)");
        return this.userImpl.getUsers(orderAscending);
    }

    public void removeUserManagerListener(UserManagerListener listener) {
        this.userImpl.removeUserManagerListener(listener);
    }

    public User updateUser(User user) throws UserNotFoundException, UserManagerException {
        return this.updateUser(user, false);
    }

    public User updateUser(User user, boolean passwordChangeRequired) throws UserNotFoundException, UserManagerException {
        if (user != null) {
            this.usersCache.remove((Object)user.getUsername());
        }
        return this.userImpl.updateUser(user, passwordChangeRequired);
    }

    public boolean userExists(String userName) throws UserManagerException {
        if (this.usersCache.hasKey((Object)userName)) {
            return true;
        }
        return this.userImpl.userExists(userName);
    }

    public void userManagerInit(boolean freshDatabase) {
        if (this.userImpl instanceof UserManager) {
            ((UserManagerListener)this.userImpl).userManagerInit(freshDatabase);
        }
        this.usersCache.clear();
    }

    public void userManagerUserAdded(User user) {
        if (this.userImpl instanceof UserManager) {
            ((UserManagerListener)this.userImpl).userManagerUserAdded(user);
        }
        if (user != null) {
            this.usersCache.remove((Object)user.getUsername());
        }
    }

    public void userManagerUserRemoved(User user) {
        if (this.userImpl instanceof UserManager) {
            ((UserManagerListener)this.userImpl).userManagerUserRemoved(user);
        }
        if (user != null) {
            this.usersCache.remove((Object)user.getUsername());
        }
    }

    public void userManagerUserUpdated(User user) {
        if (this.userImpl instanceof UserManager) {
            ((UserManagerListener)this.userImpl).userManagerUserUpdated(user);
        }
        if (user != null) {
            this.usersCache.remove((Object)user.getUsername());
        }
    }

    public UserManager getUserImpl() {
        return this.userImpl;
    }

    public void setUserImpl(UserManager userImpl) {
        this.userImpl = userImpl;
    }

    public Cache getUsersCache() {
        return this.usersCache;
    }

    public void setUsersCache(Cache usersCache) {
        this.usersCache = usersCache;
    }

    public void initialize() {
    }

    public boolean isFinalImplementation() {
        return false;
    }

    public String getDescriptionKey() {
        return "archiva.redback.usermanager.cached";
    }
}

