// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.7,
// any modifications will be overwritten.
// ==============================================================

package org.apache.archiva.redback.users.jdo.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/**
 * Class IndentingXMLStreamWriter.
 * 
 * @version $Revision$ $Date$
 */
class IndentingXMLStreamWriter
    implements XMLStreamWriter
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field out.
     */
    private XMLStreamWriter out;

    /**
     * Field NEW_LINE.
     */
    private static final String NEW_LINE = "\n";

    /**
     * Field newLine.
     */
    private String newLine = NEW_LINE;

    /**
     * Field indent.
     */
    private String indent = "  ";

    /**
     * Field linePrefix.
     */
    private char[] linePrefix = "                        ".toCharArray();

    /**
     * Field depth.
     */
    private int depth;

    /**
     * Field states.
     */
    private byte[] states = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

    /**
     * Field ELEMENT_HAS_DATA.
     */
    private static final int ELEMENT_HAS_DATA = 0x1;

    /**
     * Field ELEMENT_HAS_MARKUP.
     */
    private static final int ELEMENT_HAS_MARKUP = 0x2;


      //----------------/
     //- Constructors -/
    //----------------/

    public IndentingXMLStreamWriter(XMLStreamWriter out)
    {
        this.out = out;
    } //-- org.apache.archiva.redback.users.jdo.io.stax.IndentingXMLStreamWriter(XMLStreamWriter)


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method close.
     * 
     * @throws XMLStreamException
     */
    public void close()
        throws XMLStreamException
    {
        out.close();
    } //-- void close()

    /**
     * Method flush.
     * 
     * @throws XMLStreamException
     */
    public void flush()
        throws XMLStreamException
    {
        out.flush();
    } //-- void flush()

    /**
     * Method getNamespaceContext.
     * 
     * @return NamespaceContext
     */
    public NamespaceContext getNamespaceContext()
    {
        return out.getNamespaceContext();
    } //-- NamespaceContext getNamespaceContext()

    /**
     * Method getPrefix.
     * 
     * @param uri
     * @throws XMLStreamException
     * @return String
     */
    public String getPrefix( String uri )
        throws XMLStreamException
    {
        return out.getPrefix( uri );
    } //-- String getPrefix( String )

    /**
     * Method getProperty.
     * 
     * @param name
     * @throws IllegalArgumentException
     * @return Object
     */
    public Object getProperty( String name )
        throws IllegalArgumentException
    {
        return out.getProperty( name );
    } //-- Object getProperty( String )

    /**
     * Method setDefaultNamespace.
     * 
     * @param uri
     * @throws XMLStreamException
     */
    public void setDefaultNamespace( String uri )
        throws XMLStreamException
    {
        out.setDefaultNamespace( uri );
    } //-- void setDefaultNamespace( String )

    /**
     * Method setNamespaceContext.
     * 
     * @param context
     * @throws XMLStreamException
     */
    public void setNamespaceContext( NamespaceContext context )
        throws XMLStreamException
    {
        out.setNamespaceContext( context );
    } //-- void setNamespaceContext( NamespaceContext )

    /**
     * Method setPrefix.
     * 
     * @param prefix
     * @param uri
     * @throws XMLStreamException
     */
    public void setPrefix( String prefix, String uri )
        throws XMLStreamException
    {
        out.setPrefix( prefix, uri );
    } //-- void setPrefix( String, String )

    /**
     * Method writeAttribute.
     * 
     * @param localName
     * @param value
     * @throws XMLStreamException
     */
    public void writeAttribute( String localName, String value )
        throws XMLStreamException
    {
        out.writeAttribute( localName, value );
    } //-- void writeAttribute( String, String )

    /**
     * Method writeAttribute.
     * 
     * @param namespaceURI
     * @param value
     * @param localName
     * @throws XMLStreamException
     */
    public void writeAttribute( String namespaceURI, String localName, String value )
        throws XMLStreamException
    {
        out.writeAttribute( namespaceURI, localName, value );
    } //-- void writeAttribute( String, String, String )

    /**
     * Method writeAttribute.
     * 
     * @param prefix
     * @param value
     * @param localName
     * @param namespaceURI
     * @throws XMLStreamException
     */
    public void writeAttribute( String prefix, String namespaceURI, String localName, String value )
        throws XMLStreamException
    {
        out.writeAttribute( prefix, namespaceURI, localName, value );
    } //-- void writeAttribute( String, String, String, String )

    /**
     * Method writeCData.
     * 
     * @param data
     * @throws XMLStreamException
     */
    public void writeCData( String data )
        throws XMLStreamException
    {
        out.writeCData( data );
        afterData();
    } //-- void writeCData( String )

    /**
     * Method writeCharacters.
     * 
     * @param text
     * @throws XMLStreamException
     */
    public void writeCharacters( String text )
        throws XMLStreamException
    {
        out.writeCharacters( text );
        afterData();
    } //-- void writeCharacters( String )

    /**
     * Method writeCharacters.
     * 
     * @param text
     * @param len
     * @param start
     * @throws XMLStreamException
     */
    public void writeCharacters( char[] text, int start, int len )
        throws XMLStreamException
    {
        out.writeCharacters( text, start, len );
        afterData();
    } //-- void writeCharacters( char[], int, int )

    /**
     * Method writeComment.
     * 
     * @param data
     * @throws XMLStreamException
     */
    public void writeComment( String data )
        throws XMLStreamException
    {
        beforeMarkup();
        out.writeComment( data );
        afterMarkup();
    } //-- void writeComment( String )

    /**
     * Method writeDTD.
     * 
     * @param dtd
     * @throws XMLStreamException
     */
    public void writeDTD( String dtd )
        throws XMLStreamException
    {
        beforeMarkup();
        out.writeDTD( dtd );
        afterMarkup();
    } //-- void writeDTD( String )

    /**
     * Method writeDefaultNamespace.
     * 
     * @param namespaceURI
     * @throws XMLStreamException
     */
    public void writeDefaultNamespace( String namespaceURI )
        throws XMLStreamException
    {
        out.writeDefaultNamespace( namespaceURI );
    } //-- void writeDefaultNamespace( String )

    /**
     * Method writeEmptyElement.
     * 
     * @param localName
     * @throws XMLStreamException
     */
    public void writeEmptyElement( String localName )
        throws XMLStreamException
    {
        beforeMarkup();
        out.writeEmptyElement( localName );
        afterMarkup();
    } //-- void writeEmptyElement( String )

    /**
     * Method writeEmptyElement.
     * 
     * @param namespaceURI
     * @param localName
     * @throws XMLStreamException
     */
    public void writeEmptyElement( String namespaceURI, String localName )
        throws XMLStreamException
    {
        beforeMarkup();
        out.writeEmptyElement( namespaceURI, localName );
        afterMarkup();
    } //-- void writeEmptyElement( String, String )

    /**
     * Method writeEmptyElement.
     * 
     * @param prefix
     * @param localName
     * @param namespaceURI
     * @throws XMLStreamException
     */
    public void writeEmptyElement( String prefix, String namespaceURI, String localName )
        throws XMLStreamException
    {
        beforeMarkup();
        out.writeEmptyElement( prefix, namespaceURI, localName );
        afterMarkup();
    } //-- void writeEmptyElement( String, String, String )

    /**
     * Method writeEndDocument.
     * 
     * @throws XMLStreamException
     */
    public void writeEndDocument()
        throws XMLStreamException
    {
        out.writeEndDocument(  );
    } //-- void writeEndDocument()

    /**
     * Method writeEndElement.
     * 
     * @throws XMLStreamException
     */
    public void writeEndElement()
        throws XMLStreamException
    {
        beforeEndElement();
        out.writeEndElement(  );
        afterEndElement();
    } //-- void writeEndElement()

    /**
     * Method writeEntityRef.
     * 
     * @param name
     * @throws XMLStreamException
     */
    public void writeEntityRef( String name )
        throws XMLStreamException
    {
        out.writeEntityRef( name );
        afterData();
    } //-- void writeEntityRef( String )

    /**
     * Method writeNamespace.
     * 
     * @param prefix
     * @param namespaceURI
     * @throws XMLStreamException
     */
    public void writeNamespace( String prefix, String namespaceURI )
        throws XMLStreamException
    {
        out.writeNamespace( prefix, namespaceURI );
    } //-- void writeNamespace( String, String )

    /**
     * Method writeProcessingInstruction.
     * 
     * @param target
     * @throws XMLStreamException
     */
    public void writeProcessingInstruction( String target )
        throws XMLStreamException
    {
        beforeMarkup();
        out.writeProcessingInstruction( target );
        afterMarkup();
    } //-- void writeProcessingInstruction( String )

    /**
     * Method writeProcessingInstruction.
     * 
     * @param target
     * @param data
     * @throws XMLStreamException
     */
    public void writeProcessingInstruction( String target, String data )
        throws XMLStreamException
    {
        beforeMarkup();
        out.writeProcessingInstruction( target, data );
        afterMarkup();
    } //-- void writeProcessingInstruction( String, String )

    /**
     * Method writeStartDocument.
     * 
     * @throws XMLStreamException
     */
    public void writeStartDocument()
        throws XMLStreamException
    {
        beforeMarkup();
        out.writeStartDocument(  );
        afterMarkup();
    } //-- void writeStartDocument()

    /**
     * Method writeStartDocument.
     * 
     * @param version
     * @throws XMLStreamException
     */
    public void writeStartDocument( String version )
        throws XMLStreamException
    {
        beforeMarkup();
        out.writeStartDocument( version );
        afterMarkup();
    } //-- void writeStartDocument( String )

    /**
     * Method writeStartDocument.
     * 
     * @param encoding
     * @param version
     * @throws XMLStreamException
     */
    public void writeStartDocument( String encoding, String version )
        throws XMLStreamException
    {
        beforeMarkup();
        out.writeStartDocument( encoding, version );
        afterMarkup();
    } //-- void writeStartDocument( String, String )

    /**
     * Method writeStartElement.
     * 
     * @param localName
     * @throws XMLStreamException
     */
    public void writeStartElement( String localName )
        throws XMLStreamException
    {
        beforeStartElement();
        out.writeStartElement( localName );
        afterStartElement();
    } //-- void writeStartElement( String )

    /**
     * Method writeStartElement.
     * 
     * @param namespaceURI
     * @param localName
     * @throws XMLStreamException
     */
    public void writeStartElement( String namespaceURI, String localName )
        throws XMLStreamException
    {
        beforeStartElement();
        out.writeStartElement( namespaceURI, localName );
        afterStartElement();
    } //-- void writeStartElement( String, String )

    /**
     * Method writeStartElement.
     * 
     * @param prefix
     * @param namespaceURI
     * @param localName
     * @throws XMLStreamException
     */
    public void writeStartElement( String prefix, String localName, String namespaceURI )
        throws XMLStreamException
    {
        beforeStartElement();
        out.writeStartElement( prefix, localName, namespaceURI );
        afterStartElement();
    } //-- void writeStartElement( String, String, String )

    /**
     * Method afterData.
     */
    private void afterData()
    {
        states[depth] |= ELEMENT_HAS_DATA;
    } //-- void afterData()

    /**
     * Method afterEndElement.
     */
    private void afterEndElement()
    {
        if ( depth > 0 )
        {
            depth--;
            if ( depth <= 0 )
            {
                newLine( 0 );
            }
        }
    } //-- void afterEndElement()

    /**
     * Method afterMarkup.
     */
    private void afterMarkup()
    {
        states[depth] |= ELEMENT_HAS_MARKUP;
    } //-- void afterMarkup()

    /**
     * Method afterStartElement.
     */
    private void afterStartElement()
    {
        afterMarkup();
        depth++;
    } //-- void afterStartElement()

    /**
     * Method beforeEndElement.
     */
    private void beforeEndElement()
    {
        if ( depth > 0 && states[depth] == ELEMENT_HAS_MARKUP )
        {
            newLine( depth - 1 );
        }
    } //-- void beforeEndElement()

    /**
     * Method beforeMarkup.
     */
    private void beforeMarkup()
    {
        int state = states[depth];
        if ( ( state & ELEMENT_HAS_DATA ) == 0 && ( depth > 0 || state != 0 ) )
        {
            newLine( depth );
            if ( depth > 0 && indent.length() > 0 )
            {
                afterMarkup();
            }
        }
    } //-- void beforeMarkup()

    /**
     * Method beforeStartElement.
     */
    private void beforeStartElement()
    {
        beforeMarkup();
        if ( states.length <= depth + 1 )
        {
            byte[] tmp = new byte[states.length * 2];
            System.arraycopy( states, 0, tmp, 0, states.length );
            states = tmp;
        }
        states[depth + 1] = 0;
    } //-- void beforeStartElement()

    /**
     * Method getLineSeparator.
     * 
     * @return String
     */
    public String getLineSeparator()
    {
        try
        {
            return System.getProperty( "line.separator", NEW_LINE );
        }
        catch ( Exception e )
        {
            return NEW_LINE;
        }
    } //-- String getLineSeparator()

    /**
     * Method newLine.
     * 
     * @param depth
     */
    private void newLine( int depth )
    {
        try
        {
            out.writeCharacters( newLine );
            int prefixLength = depth * indent.length();
            while ( linePrefix.length < prefixLength )
            {
                char[] tmp = new char[linePrefix.length * 2];
                System.arraycopy( linePrefix, 0, tmp, 0, linePrefix.length );
                System.arraycopy( linePrefix, 0, tmp, linePrefix.length, linePrefix.length );
                linePrefix = tmp;
            }
            out.writeCharacters( linePrefix, 0, prefixLength );
        }
        catch ( Exception e )
        {
        }
    } //-- void newLine( int )

    /**
     * Method setNewLine.
     * 
     * @param newLine
     */
    public void setNewLine( String newLine )
    {
        this.newLine = newLine;
    } //-- void setNewLine( String )

}
