// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.7,
// any modifications will be overwritten.
// ==============================================================

package org.apache.archiva.redback.users.jdo.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.Manifest;
import javax.xml.stream.*;
import org.apache.archiva.redback.users.jdo.JdoUser;
import org.apache.archiva.redback.users.jdo.UserDatabase;

/**
 * Class UsersManagementStaxWriter.
 * 
 * @version $Revision$ $Date$
 */
public class UsersManagementStaxWriter
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field curId.
     */
    private int curId;

    /**
     * Field idMap.
     */
    private java.util.Map idMap;


      //----------------/
     //- Constructors -/
    //----------------/

    public UsersManagementStaxWriter()
    {
        idMap = new java.util.HashMap();
    } //-- org.apache.archiva.redback.users.jdo.io.stax.UsersManagementStaxWriter()


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param userDatabase
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    public void write( Writer writer, UserDatabase userDatabase )
        throws java.io.IOException, XMLStreamException
    {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if ( factory.isPropertySupported( "com.ctc.wstx.outputEscapeCr" ) )
        {
            factory.setProperty( "com.ctc.wstx.outputEscapeCr", Boolean.FALSE );
            supportWindowsLineEndings = true;
        }
        if ( factory.isPropertySupported( "org.codehaus.stax2.automaticEmptyElements" ) )
        {
            factory.setProperty( "org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE );
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter( factory.createXMLStreamWriter( writer ) );
        if ( supportWindowsLineEndings )
        {
            serializer.setNewLine( serializer.getLineSeparator() );
        }
        serializer.writeStartDocument( userDatabase.getModelEncoding(), "1.0" );
        writeUserDatabase( userDatabase, "userDatabase", serializer );
        serializer.writeEndDocument();
    } //-- void write( Writer, UserDatabase )

    /**
     * Method write.
     * 
     * @param stream
     * @param userDatabase
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    public void write( OutputStream stream, UserDatabase userDatabase )
        throws java.io.IOException, XMLStreamException
    {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if ( factory.isPropertySupported( "com.ctc.wstx.outputEscapeCr" ) )
        {
            factory.setProperty( "com.ctc.wstx.outputEscapeCr", Boolean.FALSE );
            supportWindowsLineEndings = true;
        }
        if ( factory.isPropertySupported( "org.codehaus.stax2.automaticEmptyElements" ) )
        {
            factory.setProperty( "org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE );
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter( factory.createXMLStreamWriter( stream, userDatabase.getModelEncoding() ) );
        if ( supportWindowsLineEndings )
        {
            serializer.setNewLine( serializer.getLineSeparator() );
        }
        serializer.writeStartDocument( userDatabase.getModelEncoding(), "1.0" );
        writeUserDatabase( userDatabase, "userDatabase", serializer );
        serializer.writeEndDocument();
    } //-- void write( OutputStream, UserDatabase )

    /**
     * Method writeJdoUser.
     * 
     * @param jdoUser
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    private void writeJdoUser( JdoUser jdoUser, String tagName, XMLStreamWriter serializer )
        throws java.io.IOException, XMLStreamException
    {
        if ( jdoUser != null )
        {
            serializer.writeStartElement( tagName );
            if ( jdoUser.getUsername() != null )
            {
                serializer.writeStartElement( "username" );
                serializer.writeCharacters( jdoUser.getUsername() );
                serializer.writeEndElement();
            }
            if ( jdoUser.getPassword() != null )
            {
                serializer.writeStartElement( "password" );
                serializer.writeCharacters( jdoUser.getPassword() );
                serializer.writeEndElement();
            }
            if ( jdoUser.getEncodedPassword() != null )
            {
                serializer.writeStartElement( "encodedPassword" );
                serializer.writeCharacters( jdoUser.getEncodedPassword() );
                serializer.writeEndElement();
            }
            if ( jdoUser.getFullName() != null )
            {
                serializer.writeStartElement( "fullName" );
                serializer.writeCharacters( jdoUser.getFullName() );
                serializer.writeEndElement();
            }
            if ( jdoUser.getEmail() != null )
            {
                serializer.writeStartElement( "email" );
                serializer.writeCharacters( jdoUser.getEmail() );
                serializer.writeEndElement();
            }
            if ( jdoUser.getLastPasswordChange() != null )
            {
                serializer.writeStartElement( "lastPasswordChange" );
                serializer.writeCharacters( String.valueOf( jdoUser.getLastPasswordChange().getTime() ) );
                serializer.writeEndElement();
            }
            if ( jdoUser.getLastLoginDate() != null )
            {
                serializer.writeStartElement( "lastLoginDate" );
                serializer.writeCharacters( String.valueOf( jdoUser.getLastLoginDate().getTime() ) );
                serializer.writeEndElement();
            }
            if ( jdoUser.getCountFailedLoginAttempts() != 0 )
            {
                serializer.writeStartElement( "countFailedLoginAttempts" );
                serializer.writeCharacters( String.valueOf( jdoUser.getCountFailedLoginAttempts() ) );
                serializer.writeEndElement();
            }
            if ( jdoUser.isLocked() != false )
            {
                serializer.writeStartElement( "locked" );
                serializer.writeCharacters( String.valueOf( jdoUser.isLocked() ) );
                serializer.writeEndElement();
            }
            if ( jdoUser.isPermanent() != false )
            {
                serializer.writeStartElement( "permanent" );
                serializer.writeCharacters( String.valueOf( jdoUser.isPermanent() ) );
                serializer.writeEndElement();
            }
            if ( jdoUser.isValidated() != false )
            {
                serializer.writeStartElement( "validated" );
                serializer.writeCharacters( String.valueOf( jdoUser.isValidated() ) );
                serializer.writeEndElement();
            }
            if ( jdoUser.isPasswordChangeRequired() != false )
            {
                serializer.writeStartElement( "passwordChangeRequired" );
                serializer.writeCharacters( String.valueOf( jdoUser.isPasswordChangeRequired() ) );
                serializer.writeEndElement();
            }
            if ( ( jdoUser.getPreviousEncodedPasswords() != null ) && ( jdoUser.getPreviousEncodedPasswords().size() > 0 ) )
            {
                serializer.writeStartElement( "previousEncodedPasswords" );
                for ( Iterator iter = jdoUser.getPreviousEncodedPasswords().iterator(); iter.hasNext(); )
                {
                    String previousEncodedPassword = (String) iter.next();
                    serializer.writeStartElement( "previousEncodedPassword" );
                    serializer.writeCharacters( previousEncodedPassword );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( jdoUser.getAccountCreationDate() != null )
            {
                serializer.writeStartElement( "accountCreationDate" );
                serializer.writeCharacters( String.valueOf( jdoUser.getAccountCreationDate().getTime() ) );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeJdoUser( JdoUser, String, XMLStreamWriter )

    /**
     * Method writeUserDatabase.
     * 
     * @param userDatabase
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     * @throws XMLStreamException
     */
    private void writeUserDatabase( UserDatabase userDatabase, String tagName, XMLStreamWriter serializer )
        throws java.io.IOException, XMLStreamException
    {
        if ( userDatabase != null )
        {
            serializer.writeStartElement( tagName );
            if ( ( userDatabase.getUsers() != null ) && ( userDatabase.getUsers().size() > 0 ) )
            {
                serializer.writeStartElement( "users" );
                for ( Iterator iter = userDatabase.getUsers().iterator(); iter.hasNext(); )
                {
                    JdoUser o = (JdoUser) iter.next();
                    writeJdoUser( o, "user", serializer );
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeUserDatabase( UserDatabase, String, XMLStreamWriter )

}
