// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.7,
// any modifications will be overwritten.
// ==============================================================

package org.apache.archiva.redback.users.jdo.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.*;
import org.apache.archiva.redback.users.jdo.JdoUser;
import org.apache.archiva.redback.users.jdo.UserDatabase;

/**
 * Class UsersManagementStaxReader.
 * 
 * @version $Revision$ $Date$
 */
public class UsersManagementStaxReader
{

      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method read.
     * 
     * @param reader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return UserDatabase
     */
    public UserDatabase read( Reader reader, boolean strict )
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );

        return read( xmlStreamReader, strict );
    } //-- UserDatabase read( Reader, boolean )

    /**
     * Method read.
     * 
     * @param reader
     * @throws IOException
     * @throws XMLStreamException
     * @return UserDatabase
     */
    public UserDatabase read( Reader reader )
        throws IOException, XMLStreamException
    {
        return read( reader, true );
    } //-- UserDatabase read( Reader )

    /**
     * Method read.
     * 
     * @param stream
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return UserDatabase
     */
    public UserDatabase read( InputStream stream, boolean strict )
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( stream );

        return read( xmlStreamReader, strict );
    } //-- UserDatabase read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param stream
     * @throws IOException
     * @throws XMLStreamException
     * @return UserDatabase
     */
    public UserDatabase read( InputStream stream )
        throws IOException, XMLStreamException
    {
        return read( stream, true );
    } //-- UserDatabase read( InputStream )

    /**
     * Method read.
     * 
     * @param filePath
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return UserDatabase
     */
    public UserDatabase read( String filePath, boolean strict )
        throws IOException, XMLStreamException
    {
        java.io.File file = new java.io.File( filePath );
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( file.toURI().toURL().toExternalForm(), new FileInputStream( file ) );

        return read( xmlStreamReader, strict );
    } //-- UserDatabase read( String, boolean )

    /**
     * Method read.
     * 
     * @param filePath
     * @throws IOException
     * @throws XMLStreamException
     * @return UserDatabase
     */
    public UserDatabase read( String filePath )
        throws IOException, XMLStreamException
    {
        return read( filePath, true );
    } //-- UserDatabase read( String )

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param xmlStreamReader
     * @param parsed
     * @param alias
     * @param tagName
     * @throws XMLStreamException
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XMLStreamReader xmlStreamReader, String tagName, String alias, java.util.Set parsed )
        throws XMLStreamException
    {
        if ( !( xmlStreamReader.getLocalName().equals( tagName ) || xmlStreamReader.getLocalName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XMLStreamException( "Duplicated tag: '" + tagName + "'", xmlStreamReader.getLocation() );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XMLStreamReader, String, String, java.util.Set )

    /**
     * Method checkUnknownElement.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws XMLStreamException
     */
    private void checkUnknownElement( XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( strict )
        {
            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
        }
        int unrecognizedTagCount = 1;
        while( unrecognizedTagCount != 0 )
        {
            xmlStreamReader.next();
            if ( xmlStreamReader.getEventType() == XMLStreamConstants.START_ELEMENT )
            {
                unrecognizedTagCount++;
            }
            else if ( xmlStreamReader.getEventType() == XMLStreamConstants.END_ELEMENT )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XMLStreamReader, boolean )

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XMLStreamReader )

    /**
     * Method getByteValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a byte but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XMLStreamReader )

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param dateFormat
     * @param attribute
     * @throws XMLStreamException
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XMLStreamException( e.getMessage(), xmlStreamReader.getLocation(), e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XMLStreamException( e.getMessage(), xmlStreamReader.getLocation(), e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XMLStreamReader )

    /**
     * Method getDefaultValue.
     * 
     * @param s
     * @param v
     * @return String
     */
    private String getDefaultValue( String s, String v )
    {
        if ( s == null )
        {
            s = v;
        }
        return s;
    } //-- String getDefaultValue( String, String )

    /**
     * Method getDoubleValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return float
     */
    private float getFloatValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return long
     */
    private long getLongValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XMLStreamException( "Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation() );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return short
     */
    private short getShortValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method nextTag.
     * 
     * @param xmlStreamReader
     * @throws XMLStreamException
     * @return int
     */
    private int nextTag( XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        while ( true )
        {
            int eventType = xmlStreamReader.next();
            switch ( eventType )
            {
                case XMLStreamConstants.CHARACTERS:
                case XMLStreamConstants.CDATA:
                case XMLStreamConstants.SPACE:
                case XMLStreamConstants.PROCESSING_INSTRUCTION:
                case XMLStreamConstants.COMMENT:
                    break;
                case XMLStreamConstants.START_ELEMENT:
                case XMLStreamConstants.END_ELEMENT:
                    return eventType;
                default:
                    throw new XMLStreamException( "expected start or end tag", xmlStreamReader.getLocation() );
            }
        }
    } //-- int nextTag( XMLStreamReader )

    /**
     * Method parseJdoUser.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoUser
     */
    private JdoUser parseJdoUser( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        JdoUser jdoUser = new JdoUser();
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "username", null, parsed ) )
            {
                jdoUser.setUsername( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "password", null, parsed ) )
            {
                jdoUser.setPassword( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "encodedPassword", null, parsed ) )
            {
                jdoUser.setEncodedPassword( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "fullName", null, parsed ) )
            {
                jdoUser.setFullName( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "email", null, parsed ) )
            {
                jdoUser.setEmail( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "lastPasswordChange", null, parsed ) )
            {
                String dateFormat = "long";
                jdoUser.setLastPasswordChange( getDateValue( getTrimmedValue( xmlStreamReader.getElementText() ), "lastPasswordChange", dateFormat, xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "lastLoginDate", null, parsed ) )
            {
                String dateFormat = "long";
                jdoUser.setLastLoginDate( getDateValue( getTrimmedValue( xmlStreamReader.getElementText() ), "lastLoginDate", dateFormat, xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "countFailedLoginAttempts", null, parsed ) )
            {
                jdoUser.setCountFailedLoginAttempts( getIntegerValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "0" ) ), "countFailedLoginAttempts", xmlStreamReader, strict ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "locked", null, parsed ) )
            {
                jdoUser.setLocked( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "locked", xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "permanent", null, parsed ) )
            {
                jdoUser.setPermanent( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "permanent", xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "validated", null, parsed ) )
            {
                jdoUser.setValidated( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "validated", xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "passwordChangeRequired", null, parsed ) )
            {
                jdoUser.setPasswordChangeRequired( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "passwordChangeRequired", xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "previousEncodedPasswords", null, parsed ) )
            {
                java.util.List previousEncodedPasswords = new java.util.ArrayList/*<String>*/();
                jdoUser.setPreviousEncodedPasswords( previousEncodedPasswords );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "previousEncodedPassword".equals( xmlStreamReader.getLocalName() ) )
                    {
                        previousEncodedPasswords.add( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()" ) ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "accountCreationDate", null, parsed ) )
            {
                String dateFormat = "long";
                jdoUser.setAccountCreationDate( getDateValue( getTrimmedValue( xmlStreamReader.getElementText() ), "accountCreationDate", dateFormat, xmlStreamReader ) );
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        return jdoUser;
    } //-- JdoUser parseJdoUser( XMLStreamReader, boolean )

    /**
     * Method parseUserDatabase.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return UserDatabase
     */
    private UserDatabase parseUserDatabase( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        UserDatabase userDatabase = new UserDatabase();
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "users", null, parsed ) )
            {
                java.util.List users = new java.util.ArrayList/*<JdoUser>*/();
                userDatabase.setUsers( users );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "user".equals( xmlStreamReader.getLocalName() ) )
                    {
                        userDatabase.addUser( parseJdoUser( xmlStreamReader, strict ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        return userDatabase;
    } //-- UserDatabase parseUserDatabase( XMLStreamReader, boolean )

    /**
     * Method read.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return UserDatabase
     */
    private UserDatabase read( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        int eventType = xmlStreamReader.getEventType();
        String encoding = null;
        while ( eventType != XMLStreamConstants.END_DOCUMENT )
        {
            if ( eventType == XMLStreamConstants.START_DOCUMENT )
            {
                encoding = xmlStreamReader.getCharacterEncodingScheme();
            }
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                if ( strict && ! "userDatabase".equals( xmlStreamReader.getLocalName() ) )
                {
                    throw new XMLStreamException( "Expected root element 'userDatabase' but found '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation(), null );
                }
                UserDatabase userDatabase = parseUserDatabase( xmlStreamReader, strict );
                userDatabase.setModelEncoding( encoding );
                resolveReferences( userDatabase );
                return userDatabase;
            }
            eventType = xmlStreamReader.next();
        }
        throw new XMLStreamException( "Expected root element 'userDatabase' but found no element at all: invalid XML document", xmlStreamReader.getLocation(), null );
    } //-- UserDatabase read( XMLStreamReader, boolean )

    /**
     * Method resolveReferences.
     * 
     * @param value
     */
    private void resolveReferences( UserDatabase value )
    {
        java.util.Map refs;
    } //-- void resolveReferences( UserDatabase )

}
