/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.users.ldap.service;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.common.ldap.user.LdapUser;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.users.ldap.service.LdapCacheService;
import org.springframework.stereotype.Service;

@Service
public class DefaultLdapCacheService
implements LdapCacheService {
    @Inject
    @Named(value="cache#ldapUser")
    private Cache<String, LdapUser> usersCache;
    @Inject
    @Named(value="cache#ldapUserDn")
    private Cache<String, String> ldapCacheDn;

    @Override
    public LdapUser getUser(String username) {
        return (LdapUser)this.usersCache.get((Object)username);
    }

    @Override
    public boolean removeUser(String username) {
        return this.usersCache.remove((Object)username) != null;
    }

    @Override
    public void removeAllUsers() {
        this.usersCache.clear();
    }

    @Override
    public void addUser(LdapUser user) {
        LdapUser existingUser = (LdapUser)this.usersCache.get((Object)user.getUsername());
        if (existingUser != null) {
            this.removeUser(user.getUsername());
        }
        this.usersCache.put((Object)user.getUsername(), (Object)user);
    }

    @Override
    public String getLdapUserDn(String username) {
        return (String)this.ldapCacheDn.get((Object)username);
    }

    @Override
    public boolean removeLdapUserDn(String username) {
        return this.ldapCacheDn.remove((Object)username) != null;
    }

    @Override
    public void removeAllLdapUserDn() {
        this.ldapCacheDn.clear();
    }

    @Override
    public void addLdapUserDn(String username, String userDn) {
        String existingUserDn = (String)this.ldapCacheDn.get((Object)username);
        if (existingUserDn != null) {
            this.removeUser(username);
        }
        this.ldapCacheDn.put((Object)username, (Object)userDn);
    }
}

