/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.checksum;

import java.io.File;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ChecksumAlgorithm {
    SHA1("SHA-1", "sha1", "SHA1"),
    MD5("MD5", "md5", "MD5");

    private String algorithm;
    private String ext;
    private String type;

    public static ChecksumAlgorithm getByExtension(File file) {
        String ext = FilenameUtils.getExtension((String)file.getName()).toLowerCase();
        if (SHA1.getExt().equals(ext)) {
            return SHA1;
        }
        if (MD5.getExt().equals(ext)) {
            return MD5;
        }
        throw new IllegalArgumentException("Filename " + file.getName() + " has no associated extension.");
    }

    private ChecksumAlgorithm(String algorithm, String ext, String type) {
        this.algorithm = algorithm;
        this.ext = ext;
        this.type = type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getExt() {
        return this.ext;
    }

    public String getType() {
        return this.type;
    }
}

