/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.checksum;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.archiva.checksum.Checksum;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksummedFile {
    private final Logger log = LoggerFactory.getLogger(ChecksummedFile.class);
    private static final Pattern METADATA_PATTERN = Pattern.compile("maven-metadata-\\S*.xml");
    private final File referenceFile;

    public ChecksummedFile(File referenceFile) {
        this.referenceFile = referenceFile;
    }

    public String calculateChecksum(ChecksumAlgorithm checksumAlgorithm) throws IOException {
        try (InputStream fis = Files.newInputStream(this.referenceFile.toPath(), new OpenOption[0]);){
            Checksum checksum = new Checksum(checksumAlgorithm);
            checksum.update(fis);
            String string = checksum.getChecksum();
            return string;
        }
    }

    public File createChecksum(ChecksumAlgorithm checksumAlgorithm) throws IOException {
        File checksumFile = new File(this.referenceFile.getAbsolutePath() + "." + checksumAlgorithm.getExt());
        Files.deleteIfExists(checksumFile.toPath());
        String checksum = this.calculateChecksum(checksumAlgorithm);
        Files.write(checksumFile.toPath(), (checksum + "  " + this.referenceFile.getName()).getBytes(), StandardOpenOption.CREATE_NEW);
        return checksumFile;
    }

    public File getChecksumFile(ChecksumAlgorithm checksumAlgorithm) {
        return new File(this.referenceFile.getAbsolutePath() + "." + checksumAlgorithm.getExt());
    }

    public boolean isValidChecksum(ChecksumAlgorithm algorithm) throws IOException {
        return this.isValidChecksums(new ChecksumAlgorithm[]{algorithm});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidChecksums(ChecksumAlgorithm[] algorithms) {
        try (InputStream fis = Files.newInputStream(this.referenceFile.toPath(), new OpenOption[0]);){
            File checksumFile;
            ArrayList<Checksum> checksums = new ArrayList<Checksum>(algorithms.length);
            for (ChecksumAlgorithm checksumAlgorithm : algorithms) {
                checksumFile = this.getChecksumFile(checksumAlgorithm);
                if (!checksumFile.exists()) continue;
                checksums.add(new Checksum(checksumAlgorithm));
            }
            if (checksums.isEmpty()) {
                boolean arr$ = false;
                return arr$;
            }
            try {
                Checksum.update(checksums, fis);
            }
            catch (IOException e) {
                this.log.warn("Unable to update checksum:{}", (Object)e.getMessage());
                boolean x2 = false;
                if (fis == null) return x2;
                if (var3_4 == null) {
                    fis.close();
                    return x2;
                }
                try {
                    fis.close();
                    return x2;
                }
                catch (Throwable x22) {
                    var3_4.addSuppressed(x22);
                    return x2;
                }
            }
            boolean valid = true;
            try {
                for (Checksum checksum : checksums) {
                    ChecksumAlgorithm checksumAlgorithm;
                    checksumAlgorithm = checksum.getAlgorithm();
                    checksumFile = this.getChecksumFile(checksumAlgorithm);
                    String rawChecksum = FileUtils.readFileToString((File)checksumFile);
                    String expectedChecksum = this.parseChecksum(rawChecksum, checksumAlgorithm, this.referenceFile.getName());
                    if (StringUtils.equalsIgnoreCase((String)expectedChecksum, (String)checksum.getChecksum())) continue;
                    valid = false;
                }
            }
            catch (IOException e) {
                this.log.warn("Unable to read / parse checksum: {}", (Object)e.getMessage());
                boolean checksum = false;
                if (fis == null) return checksum;
                if (var3_4 == null) {
                    fis.close();
                    return checksum;
                }
                try {
                    fis.close();
                    return checksum;
                }
                catch (Throwable x2) {
                    var3_4.addSuppressed(x2);
                    return checksum;
                }
            }
            boolean bl = valid;
            return bl;
        }
        catch (IOException e) {
            this.log.warn("Unable to read / parse checksum: {}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean fixChecksums(ChecksumAlgorithm[] algorithms) {
        ArrayList<Checksum> checksums = new ArrayList<Checksum>(algorithms.length);
        for (ChecksumAlgorithm checksumAlgorithm : algorithms) {
            checksums.add(new Checksum(checksumAlgorithm));
        }
        if (checksums.isEmpty()) {
            return true;
        }
        try (InputStream fis = Files.newInputStream(this.referenceFile.toPath(), new OpenOption[0]);){
            Checksum.update(checksums, fis);
        }
        catch (IOException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return false;
        }
        boolean valid = true;
        for (Checksum checksum : checksums) {
            ChecksumAlgorithm checksumAlgorithm;
            checksumAlgorithm = checksum.getAlgorithm();
            try {
                File checksumFile = this.getChecksumFile(checksumAlgorithm);
                String actualChecksum = checksum.getChecksum();
                if (checksumFile.exists()) {
                    String rawChecksum = FileUtils.readFileToString((File)checksumFile);
                    String expectedChecksum = this.parseChecksum(rawChecksum, checksumAlgorithm, this.referenceFile.getName());
                    if (StringUtils.equalsIgnoreCase((String)expectedChecksum, (String)actualChecksum)) continue;
                    FileUtils.writeStringToFile((File)checksumFile, (String)(actualChecksum + "  " + this.referenceFile.getName()));
                    continue;
                }
                FileUtils.writeStringToFile((File)checksumFile, (String)(actualChecksum + "  " + this.referenceFile.getName()));
            }
            catch (IOException e) {
                this.log.warn(e.getMessage(), (Throwable)e);
                valid = false;
            }
        }
        return valid;
    }

    private boolean isValidChecksumPattern(String filename, String path) {
        Matcher m = METADATA_PATTERN.matcher(path);
        if (m.matches()) {
            return filename.endsWith(path) || "-".equals(filename) || filename.endsWith("maven-metadata.xml");
        }
        return filename.endsWith(path) || "-".equals(filename);
    }

    public String parseChecksum(String rawChecksumString, ChecksumAlgorithm expectedHash, String expectedPath) throws IOException {
        String trimmedChecksum = rawChecksumString.replace('\n', ' ').trim();
        String regex = expectedHash.getType() + "\\s*\\(([^)]*)\\)\\s*=\\s*([a-fA-F0-9]+)";
        Matcher m = Pattern.compile(regex).matcher(trimmedChecksum);
        if (m.matches()) {
            String filename = m.group(1);
            if (!this.isValidChecksumPattern(filename, expectedPath)) {
                throw new IOException("Supplied checksum file '" + filename + "' does not match expected file: '" + expectedPath + "'");
            }
            trimmedChecksum = m.group(2);
        } else {
            m = Pattern.compile("([a-fA-F0-9]+)\\s+\\*?(.+)").matcher(trimmedChecksum);
            if (m.matches()) {
                String filename = m.group(2);
                if (!this.isValidChecksumPattern(filename, expectedPath)) {
                    throw new IOException("Supplied checksum file '" + filename + "' does not match expected file: '" + expectedPath + "'");
                }
                trimmedChecksum = m.group(1);
            }
        }
        return trimmedChecksum;
    }
}

