/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.common.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    public static String getDuration(long duration) {
        return DateUtil.getDuration(new Date(0L), new Date(duration));
    }

    public static String getDuration(long ms1, long ms2) {
        return DateUtil.getDuration(new Date(ms1), new Date(ms2));
    }

    public static String getDuration(Date d1, Date d2) {
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(d1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(d2);
        return DateUtil.getDuration(cal1, cal2);
    }

    public static String getDuration(Calendar cal1, Calendar cal2) {
        int year1 = cal1.get(1);
        int day1 = cal1.get(6);
        int hour1 = cal1.get(11);
        int min1 = cal1.get(12);
        int sec1 = cal1.get(13);
        int ms1 = cal1.get(14);
        int year2 = cal2.get(1);
        int day2 = cal2.get(6);
        int hour2 = cal2.get(11);
        int min2 = cal2.get(12);
        int sec2 = cal2.get(13);
        int ms2 = cal2.get(14);
        int leftDays = day1 - day2 + (year1 - year2) * 365;
        int leftHours = hour2 - hour1;
        int leftMins = min2 - min1;
        int leftSeconds = sec2 - sec1;
        int leftMilliSeconds = ms2 - ms1;
        if (leftMilliSeconds < 0) {
            leftMilliSeconds += 1000;
            --leftSeconds;
        }
        if (leftSeconds < 0) {
            leftSeconds += 60;
            --leftMins;
        }
        if (leftMins < 0) {
            leftMins += 60;
            --leftHours;
        }
        if (leftHours < 0) {
            leftHours += 24;
            --leftDays;
        }
        StringBuilder interval = new StringBuilder();
        DateUtil.appendInterval(interval, leftDays, "Day");
        DateUtil.appendInterval(interval, leftHours, "Hour");
        DateUtil.appendInterval(interval, leftMins, "Minute");
        DateUtil.appendInterval(interval, leftSeconds, "Second");
        DateUtil.appendInterval(interval, leftMilliSeconds, "Millisecond");
        return interval.toString();
    }

    private static void appendInterval(StringBuilder interval, int count, String type) {
        if (count > 0) {
            if (interval.length() > 0) {
                interval.append(" ");
            }
            interval.append(count);
            interval.append(" ").append(type);
            if (count > 1) {
                interval.append("s");
            }
        }
    }
}

