/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.common.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class VersionComparator
implements Comparator<String> {
    private static final Comparator<String> INSTANCE = new VersionComparator();
    private final List<String> specialWords = new ArrayList<String>(23);

    public VersionComparator() {
        this.specialWords.add("final");
        this.specialWords.add("release");
        this.specialWords.add("current");
        this.specialWords.add("latest");
        this.specialWords.add("g");
        this.specialWords.add("gold");
        this.specialWords.add("fcs");
        this.specialWords.add("a");
        this.specialWords.add("alpha");
        this.specialWords.add("b");
        this.specialWords.add("beta");
        this.specialWords.add("pre");
        this.specialWords.add("rc");
        this.specialWords.add("m");
        this.specialWords.add("milestone");
        this.specialWords.add("dev");
        this.specialWords.add("test");
        this.specialWords.add("debug");
        this.specialWords.add("unofficial");
        this.specialWords.add("nightly");
        this.specialWords.add("incubating");
        this.specialWords.add("incubator");
        this.specialWords.add("snapshot");
    }

    public static Comparator<String> getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(String o1, String o2) {
        int diff;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        String[] parts1 = VersionComparator.toParts(o1);
        String[] parts2 = VersionComparator.toParts(o2);
        int partLen = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < partLen; ++i) {
            diff = this.comparePart(this.safePart(parts1, i), this.safePart(parts2, i));
            if (diff == 0) continue;
            return diff;
        }
        diff = parts2.length - parts1.length;
        if (diff != 0) {
            return diff;
        }
        return o1.compareToIgnoreCase(o2);
    }

    private String safePart(String[] parts, int idx) {
        if (idx < parts.length) {
            return parts[idx];
        }
        return "0";
    }

    private int comparePart(String s1, String s2) {
        boolean is1Num = NumberUtils.isNumber((String)s1);
        boolean is2Num = NumberUtils.isNumber((String)s2);
        if (is1Num && is2Num) {
            int i1 = NumberUtils.toInt((String)s1);
            int i2 = NumberUtils.toInt((String)s2);
            return i1 - i2;
        }
        if (!is1Num && !is2Num) {
            int idx1 = this.specialWords.indexOf(s1.toLowerCase());
            int idx2 = this.specialWords.indexOf(s2.toLowerCase());
            if (idx1 >= 0 && idx2 >= 0) {
                return idx1 - idx2;
            }
        }
        if (!is1Num && is2Num) {
            return -1;
        }
        if (is1Num && !is2Num) {
            return 1;
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static String[] toParts(String version) {
        int i;
        if (StringUtils.isBlank((String)version)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int modeOther = 0;
        int modeDigit = 1;
        int modeText = 2;
        ArrayList<String> parts = new ArrayList<String>();
        int len = version.length();
        int start = 0;
        int mode = modeOther;
        for (i = 0; i < len; ++i) {
            char c = version.charAt(i);
            if (Character.isDigit(c)) {
                if (mode == modeDigit) continue;
                if (mode != modeOther) {
                    parts.add(version.substring(start, i));
                }
                mode = modeDigit;
                start = i;
                continue;
            }
            if (Character.isLetter(c)) {
                if (mode == modeText) continue;
                if (mode != modeOther) {
                    parts.add(version.substring(start, i));
                }
                mode = modeText;
                start = i;
                continue;
            }
            if (mode == modeOther) continue;
            parts.add(version.substring(start, i));
            mode = modeOther;
        }
        if (mode != modeOther) {
            parts.add(version.substring(start, i));
        }
        return parts.toArray(new String[parts.size()]);
    }
}

