/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class RepositoryGroupConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class RepositoryGroupConfiguration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The id of the repository group.
     */
    private String id;

    /**
     * Field repositories.
     */
    private java.util.List<String> repositories;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addRepository.
     * 
     * @param string
     */
    public void addRepository( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "RepositoryGroupConfiguration.addRepositories(string) parameter must be instanceof " + String.class.getName() );
        }
        getRepositories().add( string );
    } //-- void addRepository( String )

    /**
     * Get the id of the repository group.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId()

    /**
     * Method getRepositories.
     * 
     * @return List
     */
    public java.util.List<String> getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList<String>();
        }

        return this.repositories;
    } //-- java.util.List<String> getRepositories()

    /**
     * Method removeRepository.
     * 
     * @param string
     */
    public void removeRepository( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "RepositoryGroupConfiguration.removeRepositories(string) parameter must be instanceof " + String.class.getName() );
        }
        getRepositories().remove( string );
    } //-- void removeRepository( String )

    /**
     * Set the id of the repository group.
     * 
     * @param id
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String )

    /**
     * Set the list of repository ids under the group.
     * 
     * @param repositories
     */
    public void setRepositories( java.util.List<String> repositories )
    {
        this.repositories = repositories;
    } //-- void setRepositories( java.util.List )


}
