/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class RemoteRepositoryConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class RemoteRepositoryConfiguration
    extends AbstractRepositoryConfiguration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The URL for this repository.
     *           
     */
    private String url;

    /**
     * 
     *             The Username for this repository.
     *           
     */
    private String username;

    /**
     * 
     *             The Password for this repository.
     *           
     */
    private String password;

    /**
     * 
     *             Timeout in seconds for connections to this
     * repository
     *           .
     */
    private int timeout = 60;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The Password for this repository.
     *           
     * 
     * @return String
     */
    public String getPassword()
    {
        return this.password;
    } //-- String getPassword()

    /**
     * Get 
     *             Timeout in seconds for connections to this
     * repository
     *           .
     * 
     * @return int
     */
    public int getTimeout()
    {
        return this.timeout;
    } //-- int getTimeout()

    /**
     * Get 
     *             The URL for this repository.
     *           
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Get 
     *             The Username for this repository.
     *           
     * 
     * @return String
     */
    public String getUsername()
    {
        return this.username;
    } //-- String getUsername()

    /**
     * Set 
     *             The Password for this repository.
     *           
     * 
     * @param password
     */
    public void setPassword( String password )
    {
        this.password = password;
    } //-- void setPassword( String )

    /**
     * Set 
     *             Timeout in seconds for connections to this
     * repository
     *           .
     * 
     * @param timeout
     */
    public void setTimeout( int timeout )
    {
        this.timeout = timeout;
    } //-- void setTimeout( int )

    /**
     * Set 
     *             The URL for this repository.
     *           
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    /**
     * Set 
     *             The Username for this repository.
     *           
     * 
     * @param username
     */
    public void setUsername( String username )
    {
        this.username = username;
    } //-- void setUsername( String )


}
