/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.Configuration;
import org.apache.maven.archiva.configuration.ConfigurationEvent;
import org.apache.maven.archiva.configuration.ConfigurationListener;
import org.apache.maven.archiva.configuration.ConfigurationRuntimeException;
import org.apache.maven.archiva.configuration.DatabaseScanningConfiguration;
import org.apache.maven.archiva.configuration.IndeterminateConfigurationException;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.maven.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.maven.archiva.configuration.V1RepositoryConfiguration;
import org.apache.maven.archiva.configuration.functors.ProxyConnectorConfigurationOrderComparator;
import org.apache.maven.archiva.configuration.io.registry.ConfigurationRegistryReader;
import org.apache.maven.archiva.configuration.io.registry.ConfigurationRegistryWriter;
import org.apache.maven.archiva.policies.Policy;
import org.apache.maven.archiva.policies.PostDownloadPolicy;
import org.apache.maven.archiva.policies.PreDownloadPolicy;
import org.codehaus.plexus.evaluator.DefaultExpressionEvaluator;
import org.codehaus.plexus.evaluator.EvaluatorException;
import org.codehaus.plexus.evaluator.ExpressionSource;
import org.codehaus.plexus.evaluator.sources.SystemPropertyExpressionSource;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryException;
import org.codehaus.plexus.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArchivaConfiguration
implements ArchivaConfiguration,
RegistryListener,
Initializable {
    private Logger log = LoggerFactory.getLogger(DefaultArchivaConfiguration.class);
    private Registry registry;
    private Configuration configuration;
    private Map<String, PreDownloadPolicy> prePolicies;
    private Map<String, PostDownloadPolicy> postPolicies;
    private String userConfigFilename;
    private String altConfigFilename;
    private Set<ConfigurationListener> listeners = new HashSet<ConfigurationListener>();
    private Set<RegistryListener> registryListeners = new HashSet<RegistryListener>();
    private boolean isConfigurationDefaulted = false;
    private static final String KEY = "org.apache.maven.archiva";

    public Configuration getConfiguration() {
        return this.loadConfiguration();
    }

    private synchronized Configuration loadConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.load();
            this.configuration = this.unescapeExpressions(this.configuration);
            if (this.isConfigurationDefaulted) {
                this.configuration = this.checkRepositoryLocations(this.configuration);
            }
        }
        return this.configuration;
    }

    private Configuration load() {
        Configuration config;
        Registry subset = this.registry.getSubset(KEY);
        if (subset.getString("version") == null && subset.getSubset("repositoryScanning").isEmpty()) {
            subset = this.readDefaultConfiguration();
        }
        if (!(config = new ConfigurationRegistryReader().read(subset)).getRepositories().isEmpty()) {
            for (V1RepositoryConfiguration r : config.getRepositories()) {
                r.setScanned(r.isIndexed());
                if (r.getUrl().startsWith("file://")) {
                    r.setLocation(r.getUrl().substring(7));
                    config.addManagedRepository(r);
                    continue;
                }
                if (r.getUrl().startsWith("file:")) {
                    r.setLocation(r.getUrl().substring(5));
                    config.addManagedRepository(r);
                    continue;
                }
                RemoteRepositoryConfiguration repo = new RemoteRepositoryConfiguration();
                repo.setId(r.getId());
                repo.setLayout(r.getLayout());
                repo.setName(r.getName());
                repo.setUrl(r.getUrl());
                config.addRemoteRepository(repo);
            }
            config.getRepositories().clear();
            this.registry.removeSubset("org.apache.maven.archiva.repositories");
        }
        if (!CollectionUtils.isEmpty(config.getRemoteRepositories())) {
            List<RemoteRepositoryConfiguration> remoteRepos = config.getRemoteRepositories();
            for (RemoteRepositoryConfiguration repo : remoteRepos) {
                if (StringUtils.isBlank((String)repo.getUsername())) {
                    repo.setUsername(null);
                }
                if (!StringUtils.isBlank((String)repo.getPassword())) continue;
                repo.setPassword(null);
            }
        }
        if (!config.getProxyConnectors().isEmpty()) {
            ArrayList<ProxyConnectorConfiguration> proxyConnectorList = new ArrayList<ProxyConnectorConfiguration>();
            proxyConnectorList.addAll(config.getProxyConnectors());
            config.getProxyConnectors().clear();
            for (ProxyConnectorConfiguration connector : proxyConnectorList) {
                boolean connectorValid = true;
                HashMap policies = new HashMap();
                policies.putAll(connector.getPolicies());
                connector.getPolicies().clear();
                for (Map.Entry entry : policies.entrySet()) {
                    String policyId = (String)entry.getKey();
                    String setting = (String)entry.getValue();
                    if ("releases".equals(policyId) || "snapshots".equals(policyId)) {
                        if ("ignored".equals(setting)) {
                            setting = "always";
                        } else if ("disabled".equals(setting)) {
                            setting = "never";
                        }
                    } else if ("cache-failures".equals(policyId)) {
                        if ("ignored".equals(setting)) {
                            setting = "no";
                        } else if ("cached".equals(setting)) {
                            setting = "yes";
                        }
                    } else if ("checksum".equals(policyId) && "ignored".equals(setting)) {
                        setting = "ignore";
                    }
                    if (this.policyExists(policyId)) {
                        Policy policy = this.findPolicy(policyId);
                        if (!policy.getOptions().contains(setting)) {
                            setting = policy.getDefaultOption();
                        }
                        connector.addPolicy(policyId, setting);
                        continue;
                    }
                    this.log.warn("Policy [" + policyId + "] does not exist.");
                }
                if (!connectorValid) continue;
                config.addProxyConnector(connector);
            }
            Map<String, List<ProxyConnectorConfiguration>> proxyConnectorMap = config.getProxyConnectorAsMap();
            for (String key : proxyConnectorMap.keySet()) {
                List<ProxyConnectorConfiguration> connectors = proxyConnectorMap.get(key);
                Collections.sort(connectors, ProxyConnectorConfigurationOrderComparator.getInstance());
                int order = 1;
                for (ProxyConnectorConfiguration connector : connectors) {
                    connector.setOrder(order++);
                }
            }
        }
        return config;
    }

    private Policy findPolicy(String policyId) {
        if (MapUtils.isEmpty(this.prePolicies)) {
            this.log.error("No PreDownloadPolicies found!");
            return null;
        }
        if (MapUtils.isEmpty(this.postPolicies)) {
            this.log.error("No PostDownloadPolicies found!");
            return null;
        }
        Policy policy = (Policy)this.prePolicies.get(policyId);
        if (policy != null) {
            return policy;
        }
        policy = (Policy)this.postPolicies.get(policyId);
        if (policy != null) {
            return policy;
        }
        return null;
    }

    private boolean policyExists(String policyId) {
        if (MapUtils.isEmpty(this.prePolicies)) {
            this.log.error("No PreDownloadPolicies found!");
            return false;
        }
        if (MapUtils.isEmpty(this.postPolicies)) {
            this.log.error("No PostDownloadPolicies found!");
            return false;
        }
        return this.prePolicies.containsKey(policyId) || this.postPolicies.containsKey(policyId);
    }

    private Registry readDefaultConfiguration() {
        this.registry.removeSubset(KEY);
        try {
            this.registry.addConfigurationFromResource("org/apache/maven/archiva/configuration/default-archiva.xml", KEY);
            this.isConfigurationDefaulted = true;
        }
        catch (RegistryException e) {
            throw new ConfigurationRuntimeException("Fatal error: Unable to find the built-in default configuration and load it into the registry", e);
        }
        return this.registry.getSubset(KEY);
    }

    public synchronized void save(Configuration configuration) throws RegistryException, IndeterminateConfigurationException {
        Registry section = this.registry.getSection("org.apache.maven.archiva.user");
        Registry baseSection = this.registry.getSection("org.apache.maven.archiva.base");
        if (section == null) {
            section = baseSection;
            if (section == null) {
                section = this.createDefaultConfigurationFile();
            }
        } else if (baseSection != null) {
            Collection keys = baseSection.getKeys();
            boolean foundList = false;
            Iterator i = keys.iterator();
            while (i.hasNext() && !foundList) {
                String key = (String)i.next();
                if (!key.startsWith("repositories") && !key.startsWith("proxyConnectors") && !key.startsWith("networkProxies") && !key.startsWith("repositoryScanning") && !key.startsWith("databaseScanning") && !key.startsWith("remoteRepositories") && !key.startsWith("managedRepositories") && !key.startsWith("repositoryGroups")) continue;
                foundList = true;
            }
            if (foundList) {
                this.configuration = null;
                throw new IndeterminateConfigurationException("Configuration can not be saved when it is loaded from two sources");
            }
        }
        this.escapeCronExpressions(configuration);
        if (configuration.getManagedRepositories().isEmpty()) {
            section.removeSubset("managedRepositories");
        }
        if (configuration.getRemoteRepositories().isEmpty()) {
            section.removeSubset("remoteRepositories");
        }
        if (configuration.getProxyConnectors().isEmpty()) {
            section.removeSubset("proxyConnectors");
        }
        if (configuration.getNetworkProxies().isEmpty()) {
            section.removeSubset("networkProxies");
        }
        if (configuration.getLegacyArtifactPaths().isEmpty()) {
            section.removeSubset("legacyArtifactPaths");
        }
        if (configuration.getRepositoryGroups().isEmpty()) {
            section.removeSubset("repositoryGroups");
        }
        if (configuration.getRepositoryScanning() != null) {
            if (configuration.getRepositoryScanning().getKnownContentConsumers().isEmpty()) {
                section.removeSubset("repositoryScanning.knownContentConsumers");
            }
            if (configuration.getRepositoryScanning().getInvalidContentConsumers().isEmpty()) {
                section.removeSubset("repositoryScanning.invalidContentConsumers");
            }
        }
        if (configuration.getDatabaseScanning() != null) {
            if (configuration.getDatabaseScanning().getCleanupConsumers().isEmpty()) {
                section.removeSubset("databaseScanning.cleanupConsumers");
            }
            if (configuration.getDatabaseScanning().getUnprocessedConsumers().isEmpty()) {
                section.removeSubset("databaseScanning.unprocessedConsumers");
            }
        }
        new ConfigurationRegistryWriter().write(configuration, section);
        section.save();
        this.configuration = this.unescapeExpressions(configuration);
        this.triggerEvent(1);
    }

    private void escapeCronExpressions(Configuration configuration) {
        for (ManagedRepositoryConfiguration c : configuration.getManagedRepositories()) {
            c.setRefreshCronExpression(this.escapeCronExpression(c.getRefreshCronExpression()));
        }
        DatabaseScanningConfiguration scanning = configuration.getDatabaseScanning();
        if (scanning != null) {
            scanning.setCronExpression(this.escapeCronExpression(scanning.getCronExpression()));
        }
    }

    private Registry createDefaultConfigurationFile() throws RegistryException {
        String contents = "<configuration />";
        if (!this.writeFile("user configuration", this.userConfigFilename, contents) && !this.writeFile("alternative configuration", this.altConfigFilename, contents)) {
            throw new RegistryException("Unable to create configuration file in either user [" + this.userConfigFilename + "] or alternative [" + this.altConfigFilename + "] locations on disk, usually happens when not allowed to write to those locations.");
        }
        try {
            ((Initializable)this.registry).initialize();
            for (RegistryListener regListener : this.registryListeners) {
                this.addRegistryChangeListener(regListener);
            }
        }
        catch (InitializationException e) {
            throw new RegistryException("Unable to reinitialize configuration: " + e.getMessage(), (Throwable)e);
        }
        this.triggerEvent(1);
        return this.registry.getSection("org.apache.maven.archiva.user");
    }

    private boolean writeFile(String filetype, String path, String contents) {
        File file = new File(path);
        try {
            if (!(file.getParentFile() == null || file.getParentFile().exists() && file.getParentFile().isDirectory())) {
                return false;
            }
            FileUtils.writeStringToFile((File)file, (String)contents, (String)"UTF-8");
            return true;
        }
        catch (IOException e) {
            this.log.error("Unable to create " + filetype + " file: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void triggerEvent(int type) {
        ConfigurationEvent evt = new ConfigurationEvent(type);
        for (ConfigurationListener listener : this.listeners) {
            listener.configurationEvent(evt);
        }
    }

    public void addListener(ConfigurationListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(ConfigurationListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void addChangeListener(RegistryListener listener) {
        this.addRegistryChangeListener(listener);
        this.registryListeners.add(listener);
    }

    private void addRegistryChangeListener(RegistryListener listener) {
        Registry section = this.registry.getSection("org.apache.maven.archiva.user");
        if (section != null) {
            section.addChangeListener(listener);
        }
        if ((section = this.registry.getSection("org.apache.maven.archiva.base")) != null) {
            section.addChangeListener(listener);
        }
    }

    public void initialize() throws InitializationException {
        try {
            DefaultExpressionEvaluator expressionEvaluator = new DefaultExpressionEvaluator();
            expressionEvaluator.addExpressionSource((ExpressionSource)new SystemPropertyExpressionSource());
            this.userConfigFilename = expressionEvaluator.expand(this.userConfigFilename);
            this.altConfigFilename = expressionEvaluator.expand(this.altConfigFilename);
            this.loadConfiguration();
        }
        catch (EvaluatorException e) {
            throw new InitializationException("Unable to evaluate expressions found in userConfigFilename or altConfigFilename.");
        }
        this.registry.addChangeListener((RegistryListener)this);
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    public synchronized void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        this.configuration = null;
    }

    private String removeExpressions(String directory) {
        String value = StringUtils.replace((String)directory, (String)"${appserver.base}", (String)this.registry.getString("appserver.base", "${appserver.base}"));
        value = StringUtils.replace((String)value, (String)"${appserver.home}", (String)this.registry.getString("appserver.home", "${appserver.home}"));
        return value;
    }

    private String unescapeCronExpression(String cronExpression) {
        return StringUtils.replace((String)cronExpression, (String)"\\,", (String)",");
    }

    private String escapeCronExpression(String cronExpression) {
        return StringUtils.replace((String)cronExpression, (String)",", (String)"\\,");
    }

    private Configuration unescapeExpressions(Configuration config) {
        for (ManagedRepositoryConfiguration c : config.getManagedRepositories()) {
            c.setLocation(this.removeExpressions(c.getLocation()));
            c.setRefreshCronExpression(this.unescapeCronExpression(c.getRefreshCronExpression()));
        }
        DatabaseScanningConfiguration databaseScanning = config.getDatabaseScanning();
        if (databaseScanning != null) {
            String cron = databaseScanning.getCronExpression();
            databaseScanning.setCronExpression(this.unescapeCronExpression(cron));
        }
        return config;
    }

    private Configuration checkRepositoryLocations(Configuration config) {
        for (ManagedRepositoryConfiguration repo : config.getManagedRepositories()) {
            String repoPath = repo.getLocation();
            File repoLocation = new File(repoPath);
            if (!repoLocation.exists() || !repoLocation.isDirectory() || repoPath.endsWith("data/repositories/" + repo.getId())) continue;
            repo.setLocation(repoPath + "/data/repositories/" + repo.getId());
        }
        return config;
    }

    public String getUserConfigFilename() {
        return this.userConfigFilename;
    }

    public String getAltConfigFilename() {
        return this.altConfigFilename;
    }

    public boolean isDefaulted() {
        return this.isConfigurationDefaulted;
    }
}

