/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.configuration.Configuration;
import org.apache.maven.archiva.configuration.InvalidConfigurationException;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.configuration.NetworkProxyConfiguration;
import org.apache.maven.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.maven.archiva.configuration.RemoteRepositoryConfiguration;

public class MavenProxyPropertyLoader {
    private static final String REPO_LOCAL_STORE = "repo.local.store";
    private static final String PROXY_LIST = "proxy.list";
    private static final String REPO_LIST = "repo.list";

    public void load(Properties props, Configuration configuration) throws InvalidConfigurationException {
        String localCachePath = this.getMandatoryProperty(props, REPO_LOCAL_STORE);
        ManagedRepositoryConfiguration config = new ManagedRepositoryConfiguration();
        config.setLocation(localCachePath);
        config.setName("Imported Maven-Proxy Cache");
        config.setId("maven-proxy");
        config.setScanned(false);
        config.setReleases(true);
        config.setSnapshots(false);
        configuration.addManagedRepository(config);
        String propertyList = props.getProperty(PROXY_LIST);
        if (propertyList != null) {
            StringTokenizer tok = new StringTokenizer(propertyList, ",");
            while (tok.hasMoreTokens()) {
                String key = tok.nextToken();
                if (!StringUtils.isNotEmpty((String)key)) continue;
                NetworkProxyConfiguration proxy = new NetworkProxyConfiguration();
                proxy.setHost(this.getMandatoryProperty(props, "proxy." + key + ".host"));
                proxy.setPort(Integer.parseInt(this.getMandatoryProperty(props, "proxy." + key + ".port")));
                proxy.setUsername(props.getProperty("proxy." + key + ".username"));
                proxy.setPassword(props.getProperty("proxy." + key + ".password"));
                configuration.addNetworkProxy(proxy);
            }
        }
        String repoList = this.getMandatoryProperty(props, REPO_LIST);
        StringTokenizer tok = new StringTokenizer(repoList, ",");
        while (tok.hasMoreTokens()) {
            String key = tok.nextToken();
            Properties repoProps = this.getSubset(props, "repo." + key + ".");
            String url = this.getMandatoryProperty(props, "repo." + key + ".url");
            String proxyKey = repoProps.getProperty("proxy");
            RemoteRepositoryConfiguration repository = new RemoteRepositoryConfiguration();
            repository.setId(key);
            repository.setName("Imported Maven-Proxy Remote Proxy");
            repository.setUrl(url);
            repository.setLayout("legacy");
            configuration.addRemoteRepository(repository);
            ProxyConnectorConfiguration proxyConnector = new ProxyConnectorConfiguration();
            proxyConnector.setSourceRepoId("maven-proxy");
            proxyConnector.setTargetRepoId(key);
            proxyConnector.setProxyId(proxyKey);
            proxyConnector.addPolicy("snapshots", "daily");
            proxyConnector.addPolicy("releases", "always");
            configuration.addProxyConnector(proxyConnector);
        }
    }

    private Properties getSubset(Properties props, String prefix) {
        Enumeration<Object> keys = props.keys();
        Properties result = new Properties();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            if (!key.startsWith(prefix)) continue;
            String newKey = key.substring(prefix.length());
            result.setProperty(newKey, value);
        }
        return result;
    }

    public void load(InputStream is, Configuration configuration) throws IOException, InvalidConfigurationException {
        Properties props = new Properties();
        props.load(is);
        this.load(props, configuration);
    }

    private String getMandatoryProperty(Properties props, String key) throws InvalidConfigurationException {
        String value = props.getProperty(key);
        if (value == null) {
            throw new InvalidConfigurationException(key, "Missing required field: " + key);
        }
        return value;
    }
}

