/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         The scanning configuration for unprocessed
 * ArchivaArtifact database objects.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class DatabaseScanningConfiguration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * When to run the database scanning mechanism. Default is
     * every two hours on the hour.
     *           
     */
    private String cronExpression = "0 0 0/2 * * ?";

    /**
     * Field unprocessedConsumers.
     */
    private java.util.List<String> unprocessedConsumers;

    /**
     * Field cleanupConsumers.
     */
    private java.util.List<String> cleanupConsumers;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addCleanupConsumer.
     * 
     * @param string
     */
    public void addCleanupConsumer( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "DatabaseScanningConfiguration.addCleanupConsumers(string) parameter must be instanceof " + String.class.getName() );
        }
        getCleanupConsumers().add( string );
    } //-- void addCleanupConsumer( String )

    /**
     * Method addUnprocessedConsumer.
     * 
     * @param string
     */
    public void addUnprocessedConsumer( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "DatabaseScanningConfiguration.addUnprocessedConsumers(string) parameter must be instanceof " + String.class.getName() );
        }
        getUnprocessedConsumers().add( string );
    } //-- void addUnprocessedConsumer( String )

    /**
     * Method getCleanupConsumers.
     * 
     * @return List
     */
    public java.util.List<String> getCleanupConsumers()
    {
        if ( this.cleanupConsumers == null )
        {
            this.cleanupConsumers = new java.util.ArrayList<String>();
        }

        return this.cleanupConsumers;
    } //-- java.util.List<String> getCleanupConsumers()

    /**
     * Get when to run the database scanning mechanism. Default is
     * every two hours on the hour.
     *           
     * 
     * @return String
     */
    public String getCronExpression()
    {
        return this.cronExpression;
    } //-- String getCronExpression()

    /**
     * Method getUnprocessedConsumers.
     * 
     * @return List
     */
    public java.util.List<String> getUnprocessedConsumers()
    {
        if ( this.unprocessedConsumers == null )
        {
            this.unprocessedConsumers = new java.util.ArrayList<String>();
        }

        return this.unprocessedConsumers;
    } //-- java.util.List<String> getUnprocessedConsumers()

    /**
     * Method removeCleanupConsumer.
     * 
     * @param string
     */
    public void removeCleanupConsumer( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "DatabaseScanningConfiguration.removeCleanupConsumers(string) parameter must be instanceof " + String.class.getName() );
        }
        getCleanupConsumers().remove( string );
    } //-- void removeCleanupConsumer( String )

    /**
     * Method removeUnprocessedConsumer.
     * 
     * @param string
     */
    public void removeUnprocessedConsumer( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "DatabaseScanningConfiguration.removeUnprocessedConsumers(string) parameter must be instanceof " + String.class.getName() );
        }
        getUnprocessedConsumers().remove( string );
    } //-- void removeUnprocessedConsumer( String )

    /**
     * Set 
     *             The list of consumers for previously processed
     * ArchivaArtifact database
     *             objects that no longer exist on the filesystem,
     * and might need to
     *             undergo a cleanup.
     *           
     * 
     * @param cleanupConsumers
     */
    public void setCleanupConsumers( java.util.List<String> cleanupConsumers )
    {
        this.cleanupConsumers = cleanupConsumers;
    } //-- void setCleanupConsumers( java.util.List )

    /**
     * Set when to run the database scanning mechanism. Default is
     * every two hours on the hour.
     *           
     * 
     * @param cronExpression
     */
    public void setCronExpression( String cronExpression )
    {
        this.cronExpression = cronExpression;
    } //-- void setCronExpression( String )

    /**
     * Set 
     *             The list of consumers for the unprocessed
     * ArchivaArtifact database objects.
     *           
     * 
     * @param unprocessedConsumers
     */
    public void setUnprocessedConsumers( java.util.List<String> unprocessedConsumers )
    {
        this.unprocessedConsumers = unprocessedConsumers;
    } //-- void setUnprocessedConsumers( java.util.List )


}
