/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * The FileType object.
 * 
 * @version $Revision$ $Date$
 */
public class FileType
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private String id;

    /**
     * Field patterns.
     */
    private java.util.List<String> patterns;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPattern.
     * 
     * @param string
     */
    public void addPattern( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "FileType.addPatterns(string) parameter must be instanceof " + String.class.getName() );
        }
        getPatterns().add( string );
    } //-- void addPattern( String )

    /**
     * Get the id field.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId()

    /**
     * Method getPatterns.
     * 
     * @return List
     */
    public java.util.List<String> getPatterns()
    {
        if ( this.patterns == null )
        {
            this.patterns = new java.util.ArrayList<String>();
        }

        return this.patterns;
    } //-- java.util.List<String> getPatterns()

    /**
     * Method removePattern.
     * 
     * @param string
     */
    public void removePattern( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "FileType.removePatterns(string) parameter must be instanceof " + String.class.getName() );
        }
        getPatterns().remove( string );
    } //-- void removePattern( String )

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String )

    /**
     * Set the patterns field.
     * 
     * @param patterns
     */
    public void setPatterns( java.util.List<String> patterns )
    {
        this.patterns = patterns;
    } //-- void setPatterns( java.util.List )


}
