package org.apache.maven.archiva.configuration.io.registry;

import org.codehaus.plexus.registry.Registry;

// Util imports
import java.util.*;

// Model class imports
import org.apache.maven.archiva.configuration.Configuration;
import org.apache.maven.archiva.configuration.AbstractRepositoryConfiguration;
import org.apache.maven.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.configuration.V1RepositoryConfiguration;
import org.apache.maven.archiva.configuration.LegacyArtifactPath;
import org.apache.maven.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.maven.archiva.configuration.AbstractRepositoryConnectorConfiguration;
import org.apache.maven.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.maven.archiva.configuration.SyncConnectorConfiguration;
import org.apache.maven.archiva.configuration.NetworkProxyConfiguration;
import org.apache.maven.archiva.configuration.RepositoryScanningConfiguration;
import org.apache.maven.archiva.configuration.FileType;
import org.apache.maven.archiva.configuration.DatabaseScanningConfiguration;
import org.apache.maven.archiva.configuration.OrganisationInformation;
import org.apache.maven.archiva.configuration.WebappConfiguration;
import org.apache.maven.archiva.configuration.UserInterfaceOptions;




/**
 * Generate Plexus Registry input mechanism for model 'Configuration'.
 */
public class ConfigurationRegistryReader
{
    public Configuration read( Registry registry )
    {
        return readConfiguration( "", registry );
    }

    private Configuration readConfiguration( String prefix, Registry registry )
    {
        Configuration value = new Configuration();

        String version = registry.getString( prefix + "version", value.getVersion() );
        value.setVersion( version );
        java.util.List repositories = new java.util.ArrayList/*<V1RepositoryConfiguration>*/();
        List repositoriesSubsets = registry.getSubsetList( prefix + "repositories.repository" );
        for ( Iterator i = repositoriesSubsets.iterator(); i.hasNext(); )
        {
            V1RepositoryConfiguration v = readV1RepositoryConfiguration( "", (Registry) i.next() );
            repositories.add( v );
        }
        value.setRepositories( repositories );
        java.util.List repositoryGroups = new java.util.ArrayList/*<RepositoryGroupConfiguration>*/();
        List repositoryGroupsSubsets = registry.getSubsetList( prefix + "repositoryGroups.repositoryGroup" );
        for ( Iterator i = repositoryGroupsSubsets.iterator(); i.hasNext(); )
        {
            RepositoryGroupConfiguration v = readRepositoryGroupConfiguration( "", (Registry) i.next() );
            repositoryGroups.add( v );
        }
        value.setRepositoryGroups( repositoryGroups );
        java.util.List managedRepositories = new java.util.ArrayList/*<ManagedRepositoryConfiguration>*/();
        List managedRepositoriesSubsets = registry.getSubsetList( prefix + "managedRepositories.managedRepository" );
        for ( Iterator i = managedRepositoriesSubsets.iterator(); i.hasNext(); )
        {
            ManagedRepositoryConfiguration v = readManagedRepositoryConfiguration( "", (Registry) i.next() );
            managedRepositories.add( v );
        }
        value.setManagedRepositories( managedRepositories );
        java.util.List remoteRepositories = new java.util.ArrayList/*<RemoteRepositoryConfiguration>*/();
        List remoteRepositoriesSubsets = registry.getSubsetList( prefix + "remoteRepositories.remoteRepository" );
        for ( Iterator i = remoteRepositoriesSubsets.iterator(); i.hasNext(); )
        {
            RemoteRepositoryConfiguration v = readRemoteRepositoryConfiguration( "", (Registry) i.next() );
            remoteRepositories.add( v );
        }
        value.setRemoteRepositories( remoteRepositories );
        java.util.List proxyConnectors = new java.util.ArrayList/*<ProxyConnectorConfiguration>*/();
        List proxyConnectorsSubsets = registry.getSubsetList( prefix + "proxyConnectors.proxyConnector" );
        for ( Iterator i = proxyConnectorsSubsets.iterator(); i.hasNext(); )
        {
            ProxyConnectorConfiguration v = readProxyConnectorConfiguration( "", (Registry) i.next() );
            proxyConnectors.add( v );
        }
        value.setProxyConnectors( proxyConnectors );
        java.util.List networkProxies = new java.util.ArrayList/*<NetworkProxyConfiguration>*/();
        List networkProxiesSubsets = registry.getSubsetList( prefix + "networkProxies.networkProxy" );
        for ( Iterator i = networkProxiesSubsets.iterator(); i.hasNext(); )
        {
            NetworkProxyConfiguration v = readNetworkProxyConfiguration( "", (Registry) i.next() );
            networkProxies.add( v );
        }
        value.setNetworkProxies( networkProxies );
        java.util.List legacyArtifactPaths = new java.util.ArrayList/*<LegacyArtifactPath>*/();
        List legacyArtifactPathsSubsets = registry.getSubsetList( prefix + "legacyArtifactPaths.legacyArtifactPath" );
        for ( Iterator i = legacyArtifactPathsSubsets.iterator(); i.hasNext(); )
        {
            LegacyArtifactPath v = readLegacyArtifactPath( "", (Registry) i.next() );
            legacyArtifactPaths.add( v );
        }
        value.setLegacyArtifactPaths( legacyArtifactPaths );
        RepositoryScanningConfiguration repositoryScanning = readRepositoryScanningConfiguration( prefix + "repositoryScanning.", registry );
        value.setRepositoryScanning( repositoryScanning );
        DatabaseScanningConfiguration databaseScanning = readDatabaseScanningConfiguration( prefix + "databaseScanning.", registry );
        value.setDatabaseScanning( databaseScanning );
        WebappConfiguration webapp = readWebappConfiguration( prefix + "webapp.", registry );
        value.setWebapp( webapp );
        OrganisationInformation organisationInfo = readOrganisationInformation( prefix + "organisationInfo.", registry );
        value.setOrganisationInfo( organisationInfo );

        return value;
    }
    
    private AbstractRepositoryConfiguration readAbstractRepositoryConfiguration( String prefix, Registry registry )
    {
        AbstractRepositoryConfiguration value = new AbstractRepositoryConfiguration();

        String id = registry.getString( prefix + "id", value.getId() );
        value.setId( id );
        String name = registry.getString( prefix + "name", value.getName() );
        value.setName( name );
        String layout = registry.getString( prefix + "layout", value.getLayout() );
        value.setLayout( layout );

        return value;
    }
    
    private RemoteRepositoryConfiguration readRemoteRepositoryConfiguration( String prefix, Registry registry )
    {
        RemoteRepositoryConfiguration value = new RemoteRepositoryConfiguration();

        String url = registry.getString( prefix + "url", value.getUrl() );
        value.setUrl( url );
        String username = registry.getString( prefix + "username", value.getUsername() );
        value.setUsername( username );
        String password = registry.getString( prefix + "password", value.getPassword() );
        value.setPassword( password );
        int timeout = registry.getInt( prefix + "timeout", value.getTimeout() );
        value.setTimeout( timeout );
        String id = registry.getString( prefix + "id", value.getId() );
        value.setId( id );
        String name = registry.getString( prefix + "name", value.getName() );
        value.setName( name );
        String layout = registry.getString( prefix + "layout", value.getLayout() );
        value.setLayout( layout );

        return value;
    }
    
    private ManagedRepositoryConfiguration readManagedRepositoryConfiguration( String prefix, Registry registry )
    {
        ManagedRepositoryConfiguration value = new ManagedRepositoryConfiguration();

        String location = registry.getString( prefix + "location", value.getLocation() );
        value.setLocation( location );
        boolean releases = registry.getBoolean( prefix + "releases", value.isReleases() );
        value.setReleases( releases );
        boolean blockRedeployments = registry.getBoolean( prefix + "blockRedeployments", value.isBlockRedeployments() );
        value.setBlockRedeployments( blockRedeployments );
        boolean snapshots = registry.getBoolean( prefix + "snapshots", value.isSnapshots() );
        value.setSnapshots( snapshots );
        boolean scanned = registry.getBoolean( prefix + "scanned", value.isScanned() );
        value.setScanned( scanned );
        String indexDir = registry.getString( prefix + "indexDir", value.getIndexDir() );
        value.setIndexDir( indexDir );
        String refreshCronExpression = registry.getString( prefix + "refreshCronExpression", value.getRefreshCronExpression() );
        value.setRefreshCronExpression( refreshCronExpression );
        int retentionCount = registry.getInt( prefix + "retentionCount", value.getRetentionCount() );
        value.setRetentionCount( retentionCount );
        int daysOlder = registry.getInt( prefix + "daysOlder", value.getDaysOlder() );
        value.setDaysOlder( daysOlder );
        boolean deleteReleasedSnapshots = registry.getBoolean( prefix + "deleteReleasedSnapshots", value.isDeleteReleasedSnapshots() );
        value.setDeleteReleasedSnapshots( deleteReleasedSnapshots );
        String id = registry.getString( prefix + "id", value.getId() );
        value.setId( id );
        String name = registry.getString( prefix + "name", value.getName() );
        value.setName( name );
        String layout = registry.getString( prefix + "layout", value.getLayout() );
        value.setLayout( layout );

        return value;
    }
    
    private V1RepositoryConfiguration readV1RepositoryConfiguration( String prefix, Registry registry )
    {
        V1RepositoryConfiguration value = new V1RepositoryConfiguration();

        String url = registry.getString( prefix + "url", value.getUrl() );
        value.setUrl( url );
        boolean indexed = registry.getBoolean( prefix + "indexed", value.isIndexed() );
        value.setIndexed( indexed );
        String location = registry.getString( prefix + "location", value.getLocation() );
        value.setLocation( location );
        boolean releases = registry.getBoolean( prefix + "releases", value.isReleases() );
        value.setReleases( releases );
        boolean blockRedeployments = registry.getBoolean( prefix + "blockRedeployments", value.isBlockRedeployments() );
        value.setBlockRedeployments( blockRedeployments );
        boolean snapshots = registry.getBoolean( prefix + "snapshots", value.isSnapshots() );
        value.setSnapshots( snapshots );
        boolean scanned = registry.getBoolean( prefix + "scanned", value.isScanned() );
        value.setScanned( scanned );
        String indexDir = registry.getString( prefix + "indexDir", value.getIndexDir() );
        value.setIndexDir( indexDir );
        String refreshCronExpression = registry.getString( prefix + "refreshCronExpression", value.getRefreshCronExpression() );
        value.setRefreshCronExpression( refreshCronExpression );
        int retentionCount = registry.getInt( prefix + "retentionCount", value.getRetentionCount() );
        value.setRetentionCount( retentionCount );
        int daysOlder = registry.getInt( prefix + "daysOlder", value.getDaysOlder() );
        value.setDaysOlder( daysOlder );
        boolean deleteReleasedSnapshots = registry.getBoolean( prefix + "deleteReleasedSnapshots", value.isDeleteReleasedSnapshots() );
        value.setDeleteReleasedSnapshots( deleteReleasedSnapshots );
        String id = registry.getString( prefix + "id", value.getId() );
        value.setId( id );
        String name = registry.getString( prefix + "name", value.getName() );
        value.setName( name );
        String layout = registry.getString( prefix + "layout", value.getLayout() );
        value.setLayout( layout );

        return value;
    }
    
    private LegacyArtifactPath readLegacyArtifactPath( String prefix, Registry registry )
    {
        LegacyArtifactPath value = new LegacyArtifactPath();

        String path = registry.getString( prefix + "path", value.getPath() );
        value.setPath( path );
        String artifact = registry.getString( prefix + "artifact", value.getArtifact() );
        value.setArtifact( artifact );

        return value;
    }
    
    private RepositoryGroupConfiguration readRepositoryGroupConfiguration( String prefix, Registry registry )
    {
        RepositoryGroupConfiguration value = new RepositoryGroupConfiguration();

        String id = registry.getString( prefix + "id", value.getId() );
        value.setId( id );
        java.util.List repositories = new java.util.ArrayList/*<String>*/();
        repositories.addAll( registry.getList( prefix + "repositories.repository" ) );
        value.setRepositories( repositories );

        return value;
    }
    
    private AbstractRepositoryConnectorConfiguration readAbstractRepositoryConnectorConfiguration( String prefix, Registry registry )
    {
        AbstractRepositoryConnectorConfiguration value = new AbstractRepositoryConnectorConfiguration();

        String sourceRepoId = registry.getString( prefix + "sourceRepoId", value.getSourceRepoId() );
        value.setSourceRepoId( sourceRepoId );
        String targetRepoId = registry.getString( prefix + "targetRepoId", value.getTargetRepoId() );
        value.setTargetRepoId( targetRepoId );
        String proxyId = registry.getString( prefix + "proxyId", value.getProxyId() );
        value.setProxyId( proxyId );
        java.util.List blackListPatterns = new java.util.ArrayList/*<String>*/();
        blackListPatterns.addAll( registry.getList( prefix + "blackListPatterns.blackListPattern" ) );
        value.setBlackListPatterns( blackListPatterns );
        java.util.List whiteListPatterns = new java.util.ArrayList/*<String>*/();
        whiteListPatterns.addAll( registry.getList( prefix + "whiteListPatterns.whiteListPattern" ) );
        value.setWhiteListPatterns( whiteListPatterns );
        java.util.Map policies = registry.getProperties( prefix + "policies" );
        value.setPolicies( policies );
        java.util.Map properties = registry.getProperties( prefix + "properties" );
        value.setProperties( properties );
        boolean disabled = registry.getBoolean( prefix + "disabled", value.isDisabled() );
        value.setDisabled( disabled );

        return value;
    }
    
    private ProxyConnectorConfiguration readProxyConnectorConfiguration( String prefix, Registry registry )
    {
        ProxyConnectorConfiguration value = new ProxyConnectorConfiguration();

        int order = registry.getInt( prefix + "order", value.getOrder() );
        value.setOrder( order );
        String sourceRepoId = registry.getString( prefix + "sourceRepoId", value.getSourceRepoId() );
        value.setSourceRepoId( sourceRepoId );
        String targetRepoId = registry.getString( prefix + "targetRepoId", value.getTargetRepoId() );
        value.setTargetRepoId( targetRepoId );
        String proxyId = registry.getString( prefix + "proxyId", value.getProxyId() );
        value.setProxyId( proxyId );
        java.util.List blackListPatterns = new java.util.ArrayList/*<String>*/();
        blackListPatterns.addAll( registry.getList( prefix + "blackListPatterns.blackListPattern" ) );
        value.setBlackListPatterns( blackListPatterns );
        java.util.List whiteListPatterns = new java.util.ArrayList/*<String>*/();
        whiteListPatterns.addAll( registry.getList( prefix + "whiteListPatterns.whiteListPattern" ) );
        value.setWhiteListPatterns( whiteListPatterns );
        java.util.Map policies = registry.getProperties( prefix + "policies" );
        value.setPolicies( policies );
        java.util.Map properties = registry.getProperties( prefix + "properties" );
        value.setProperties( properties );
        boolean disabled = registry.getBoolean( prefix + "disabled", value.isDisabled() );
        value.setDisabled( disabled );

        return value;
    }
    
    private SyncConnectorConfiguration readSyncConnectorConfiguration( String prefix, Registry registry )
    {
        SyncConnectorConfiguration value = new SyncConnectorConfiguration();

        String cronExpression = registry.getString( prefix + "cronExpression", value.getCronExpression() );
        value.setCronExpression( cronExpression );
        String method = registry.getString( prefix + "method", value.getMethod() );
        value.setMethod( method );
        String sourceRepoId = registry.getString( prefix + "sourceRepoId", value.getSourceRepoId() );
        value.setSourceRepoId( sourceRepoId );
        String targetRepoId = registry.getString( prefix + "targetRepoId", value.getTargetRepoId() );
        value.setTargetRepoId( targetRepoId );
        String proxyId = registry.getString( prefix + "proxyId", value.getProxyId() );
        value.setProxyId( proxyId );
        java.util.List blackListPatterns = new java.util.ArrayList/*<String>*/();
        blackListPatterns.addAll( registry.getList( prefix + "blackListPatterns.blackListPattern" ) );
        value.setBlackListPatterns( blackListPatterns );
        java.util.List whiteListPatterns = new java.util.ArrayList/*<String>*/();
        whiteListPatterns.addAll( registry.getList( prefix + "whiteListPatterns.whiteListPattern" ) );
        value.setWhiteListPatterns( whiteListPatterns );
        java.util.Map policies = registry.getProperties( prefix + "policies" );
        value.setPolicies( policies );
        java.util.Map properties = registry.getProperties( prefix + "properties" );
        value.setProperties( properties );
        boolean disabled = registry.getBoolean( prefix + "disabled", value.isDisabled() );
        value.setDisabled( disabled );

        return value;
    }
    
    private NetworkProxyConfiguration readNetworkProxyConfiguration( String prefix, Registry registry )
    {
        NetworkProxyConfiguration value = new NetworkProxyConfiguration();

        String id = registry.getString( prefix + "id", value.getId() );
        value.setId( id );
        String protocol = registry.getString( prefix + "protocol", value.getProtocol() );
        value.setProtocol( protocol );
        String host = registry.getString( prefix + "host", value.getHost() );
        value.setHost( host );
        int port = registry.getInt( prefix + "port", value.getPort() );
        value.setPort( port );
        String username = registry.getString( prefix + "username", value.getUsername() );
        value.setUsername( username );
        String password = registry.getString( prefix + "password", value.getPassword() );
        value.setPassword( password );

        return value;
    }
    
    private RepositoryScanningConfiguration readRepositoryScanningConfiguration( String prefix, Registry registry )
    {
        RepositoryScanningConfiguration value = new RepositoryScanningConfiguration();

        java.util.List fileTypes = new java.util.ArrayList/*<FileType>*/();
        List fileTypesSubsets = registry.getSubsetList( prefix + "fileTypes.fileType" );
        for ( Iterator i = fileTypesSubsets.iterator(); i.hasNext(); )
        {
            FileType v = readFileType( "", (Registry) i.next() );
            fileTypes.add( v );
        }
        value.setFileTypes( fileTypes );
        java.util.List knownContentConsumers = new java.util.ArrayList/*<String>*/();
        knownContentConsumers.addAll( registry.getList( prefix + "knownContentConsumers.knownContentConsumer" ) );
        value.setKnownContentConsumers( knownContentConsumers );
        java.util.List invalidContentConsumers = new java.util.ArrayList/*<String>*/();
        invalidContentConsumers.addAll( registry.getList( prefix + "invalidContentConsumers.invalidContentConsumer" ) );
        value.setInvalidContentConsumers( invalidContentConsumers );

        return value;
    }
    
    private FileType readFileType( String prefix, Registry registry )
    {
        FileType value = new FileType();

        String id = registry.getString( prefix + "id", value.getId() );
        value.setId( id );
        java.util.List patterns = new java.util.ArrayList/*<String>*/();
        patterns.addAll( registry.getList( prefix + "patterns.pattern" ) );
        value.setPatterns( patterns );

        return value;
    }
    
    private DatabaseScanningConfiguration readDatabaseScanningConfiguration( String prefix, Registry registry )
    {
        DatabaseScanningConfiguration value = new DatabaseScanningConfiguration();

        String cronExpression = registry.getString( prefix + "cronExpression", value.getCronExpression() );
        value.setCronExpression( cronExpression );
        java.util.List unprocessedConsumers = new java.util.ArrayList/*<String>*/();
        unprocessedConsumers.addAll( registry.getList( prefix + "unprocessedConsumers.unprocessedConsumer" ) );
        value.setUnprocessedConsumers( unprocessedConsumers );
        java.util.List cleanupConsumers = new java.util.ArrayList/*<String>*/();
        cleanupConsumers.addAll( registry.getList( prefix + "cleanupConsumers.cleanupConsumer" ) );
        value.setCleanupConsumers( cleanupConsumers );

        return value;
    }
    
    private OrganisationInformation readOrganisationInformation( String prefix, Registry registry )
    {
        OrganisationInformation value = new OrganisationInformation();

        String name = registry.getString( prefix + "name", value.getName() );
        value.setName( name );
        String url = registry.getString( prefix + "url", value.getUrl() );
        value.setUrl( url );
        String logoLocation = registry.getString( prefix + "logoLocation", value.getLogoLocation() );
        value.setLogoLocation( logoLocation );

        return value;
    }
    
    private WebappConfiguration readWebappConfiguration( String prefix, Registry registry )
    {
        WebappConfiguration value = new WebappConfiguration();

        UserInterfaceOptions ui = readUserInterfaceOptions( prefix + "ui.", registry );
        value.setUi( ui );

        return value;
    }
    
    private UserInterfaceOptions readUserInterfaceOptions( String prefix, Registry registry )
    {
        UserInterfaceOptions value = new UserInterfaceOptions();

        boolean showFindArtifacts = registry.getBoolean( prefix + "showFindArtifacts", value.isShowFindArtifacts() );
        value.setShowFindArtifacts( showFindArtifacts );
        boolean appletFindEnabled = registry.getBoolean( prefix + "appletFindEnabled", value.isAppletFindEnabled() );
        value.setAppletFindEnabled( appletFindEnabled );
        boolean disableEasterEggs = registry.getBoolean( prefix + "disableEasterEggs", value.isDisableEasterEggs() );
        value.setDisableEasterEggs( disableEasterEggs );

        return value;
    }
    
}
