/*
 * $Id$
 */

package org.apache.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class ProxyConnectorRuleConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class ProxyConnectorRuleConfiguration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The type if this rule: whiteList, blackList
     * etc..
     *           
     */
    private String ruleType;

    /**
     * 
     *             The pattern for this rule: whiteList, blackList
     * etc..
     *           
     */
    private String pattern;

    /**
     * Field proxyConnectors.
     */
    private java.util.List<ProxyConnectorConfiguration> proxyConnectors;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addProxyConnector.
     * 
     * @param proxyConnectorConfiguration
     */
    public void addProxyConnector( ProxyConnectorConfiguration proxyConnectorConfiguration )
    {
        if ( !(proxyConnectorConfiguration instanceof ProxyConnectorConfiguration) )
        {
            throw new ClassCastException( "ProxyConnectorRuleConfiguration.addProxyConnectors(proxyConnectorConfiguration) parameter must be instanceof " + ProxyConnectorConfiguration.class.getName() );
        }
        getProxyConnectors().add( proxyConnectorConfiguration );
    } //-- void addProxyConnector( ProxyConnectorConfiguration )

    /**
     * Get 
     *             The pattern for this rule: whiteList, blackList
     * etc..
     *           
     * 
     * @return String
     */
    public String getPattern()
    {
        return this.pattern;
    } //-- String getPattern()

    /**
     * Method getProxyConnectors.
     * 
     * @return List
     */
    public java.util.List<ProxyConnectorConfiguration> getProxyConnectors()
    {
        if ( this.proxyConnectors == null )
        {
            this.proxyConnectors = new java.util.ArrayList<ProxyConnectorConfiguration>();
        }

        return this.proxyConnectors;
    } //-- java.util.List<ProxyConnectorConfiguration> getProxyConnectors()

    /**
     * Get 
     *             The type if this rule: whiteList, blackList
     * etc..
     *           
     * 
     * @return String
     */
    public String getRuleType()
    {
        return this.ruleType;
    } //-- String getRuleType()

    /**
     * Method removeProxyConnector.
     * 
     * @param proxyConnectorConfiguration
     */
    public void removeProxyConnector( ProxyConnectorConfiguration proxyConnectorConfiguration )
    {
        if ( !(proxyConnectorConfiguration instanceof ProxyConnectorConfiguration) )
        {
            throw new ClassCastException( "ProxyConnectorRuleConfiguration.removeProxyConnectors(proxyConnectorConfiguration) parameter must be instanceof " + ProxyConnectorConfiguration.class.getName() );
        }
        getProxyConnectors().remove( proxyConnectorConfiguration );
    } //-- void removeProxyConnector( ProxyConnectorConfiguration )

    /**
     * Set 
     *             The pattern for this rule: whiteList, blackList
     * etc..
     *           
     * 
     * @param pattern
     */
    public void setPattern( String pattern )
    {
        this.pattern = pattern;
    } //-- void setPattern( String )

    /**
     * Set associated proxyConnectors configuration.
     * 
     * @param proxyConnectors
     */
    public void setProxyConnectors( java.util.List<ProxyConnectorConfiguration> proxyConnectors )
    {
        this.proxyConnectors = proxyConnectors;
    } //-- void setProxyConnectors( java.util.List )

    /**
     * Set 
     *             The type if this rule: whiteList, blackList
     * etc..
     *           
     * 
     * @param ruleType
     */
    public void setRuleType( String ruleType )
    {
        this.ruleType = ruleType;
    } //-- void setRuleType( String )


}
