/*
 * $Id$
 */

package org.apache.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class SyncConnectorConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class SyncConnectorConfiguration
    extends AbstractRepositoryConnectorConfiguration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * When to run the sync mechanism. Default is every hour on the
     * hour.
     */
    private String cronExpression = "0 0 * * * ?";

    /**
     * The type of synchronization to use.
     */
    private String method = "rsync";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get when to run the sync mechanism. Default is every hour on
     * the hour.
     * 
     * @return String
     */
    public String getCronExpression()
    {
        return this.cronExpression;
    } //-- String getCronExpression()

    /**
     * Get the type of synchronization to use.
     * 
     * @return String
     */
    public String getMethod()
    {
        return this.method;
    } //-- String getMethod()

    /**
     * Set when to run the sync mechanism. Default is every hour on
     * the hour.
     * 
     * @param cronExpression
     */
    public void setCronExpression( String cronExpression )
    {
        this.cronExpression = cronExpression;
    } //-- void setCronExpression( String )

    /**
     * Set the type of synchronization to use.
     * 
     * @param method
     */
    public void setMethod( String method )
    {
        this.method = method;
    } //-- void setMethod( String )


}
