/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.configuration.io.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.archiva.configuration.AbstractRepositoryConfiguration;
import org.apache.archiva.configuration.AbstractRepositoryConnectorConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.FileType;
import org.apache.archiva.configuration.LegacyArtifactPath;
import org.apache.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.archiva.configuration.NetworkConfiguration;
import org.apache.archiva.configuration.NetworkProxyConfiguration;
import org.apache.archiva.configuration.OrganisationInformation;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.ProxyConnectorRuleConfiguration;
import org.apache.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.archiva.configuration.RepositoryScanningConfiguration;
import org.apache.archiva.configuration.SyncConnectorConfiguration;
import org.apache.archiva.configuration.UserInterfaceOptions;
import org.apache.archiva.configuration.V1RepositoryConfiguration;
import org.apache.archiva.configuration.WebappConfiguration;
import org.apache.archiva.redback.components.registry.Registry;

public class ConfigurationRegistryReader {
    public Configuration read(Registry registry) {
        return this.readConfiguration("", registry);
    }

    private Configuration readConfiguration(String prefix, Registry registry) {
        Configuration value = new Configuration();
        String version = registry.getString(prefix + "version", value.getVersion());
        value.setVersion(version);
        ArrayList<V1RepositoryConfiguration> repositories = new ArrayList<V1RepositoryConfiguration>();
        List repositoriesSubsets = registry.getSubsetList(prefix + "repositories.repository");
        Iterator i = repositoriesSubsets.iterator();
        while (i.hasNext()) {
            V1RepositoryConfiguration v = this.readV1RepositoryConfiguration("", (Registry)i.next());
            repositories.add(v);
        }
        value.setRepositories(repositories);
        ArrayList<RepositoryGroupConfiguration> repositoryGroups = new ArrayList<RepositoryGroupConfiguration>();
        List repositoryGroupsSubsets = registry.getSubsetList(prefix + "repositoryGroups.repositoryGroup");
        Iterator i2 = repositoryGroupsSubsets.iterator();
        while (i2.hasNext()) {
            RepositoryGroupConfiguration v = this.readRepositoryGroupConfiguration("", (Registry)i2.next());
            repositoryGroups.add(v);
        }
        value.setRepositoryGroups(repositoryGroups);
        ArrayList<ManagedRepositoryConfiguration> managedRepositories = new ArrayList<ManagedRepositoryConfiguration>();
        List managedRepositoriesSubsets = registry.getSubsetList(prefix + "managedRepositories.managedRepository");
        Iterator i3 = managedRepositoriesSubsets.iterator();
        while (i3.hasNext()) {
            ManagedRepositoryConfiguration v = this.readManagedRepositoryConfiguration("", (Registry)i3.next());
            managedRepositories.add(v);
        }
        value.setManagedRepositories(managedRepositories);
        ArrayList<RemoteRepositoryConfiguration> remoteRepositories = new ArrayList<RemoteRepositoryConfiguration>();
        List remoteRepositoriesSubsets = registry.getSubsetList(prefix + "remoteRepositories.remoteRepository");
        Iterator i4 = remoteRepositoriesSubsets.iterator();
        while (i4.hasNext()) {
            RemoteRepositoryConfiguration v = this.readRemoteRepositoryConfiguration("", (Registry)i4.next());
            remoteRepositories.add(v);
        }
        value.setRemoteRepositories(remoteRepositories);
        ArrayList<ProxyConnectorConfiguration> proxyConnectors = new ArrayList<ProxyConnectorConfiguration>();
        List proxyConnectorsSubsets = registry.getSubsetList(prefix + "proxyConnectors.proxyConnector");
        Iterator i5 = proxyConnectorsSubsets.iterator();
        while (i5.hasNext()) {
            ProxyConnectorConfiguration v = this.readProxyConnectorConfiguration("", (Registry)i5.next());
            proxyConnectors.add(v);
        }
        value.setProxyConnectors(proxyConnectors);
        ArrayList<NetworkProxyConfiguration> networkProxies = new ArrayList<NetworkProxyConfiguration>();
        List networkProxiesSubsets = registry.getSubsetList(prefix + "networkProxies.networkProxy");
        Iterator i6 = networkProxiesSubsets.iterator();
        while (i6.hasNext()) {
            NetworkProxyConfiguration v = this.readNetworkProxyConfiguration("", (Registry)i6.next());
            networkProxies.add(v);
        }
        value.setNetworkProxies(networkProxies);
        ArrayList<LegacyArtifactPath> legacyArtifactPaths = new ArrayList<LegacyArtifactPath>();
        List legacyArtifactPathsSubsets = registry.getSubsetList(prefix + "legacyArtifactPaths.legacyArtifactPath");
        Iterator i7 = legacyArtifactPathsSubsets.iterator();
        while (i7.hasNext()) {
            LegacyArtifactPath v = this.readLegacyArtifactPath("", (Registry)i7.next());
            legacyArtifactPaths.add(v);
        }
        value.setLegacyArtifactPaths(legacyArtifactPaths);
        RepositoryScanningConfiguration repositoryScanning = this.readRepositoryScanningConfiguration(prefix + "repositoryScanning.", registry);
        value.setRepositoryScanning(repositoryScanning);
        WebappConfiguration webapp = this.readWebappConfiguration(prefix + "webapp.", registry);
        value.setWebapp(webapp);
        OrganisationInformation organisationInfo = this.readOrganisationInformation(prefix + "organisationInfo.", registry);
        value.setOrganisationInfo(organisationInfo);
        NetworkConfiguration networkConfiguration = this.readNetworkConfiguration(prefix + "networkConfiguration.", registry);
        value.setNetworkConfiguration(networkConfiguration);
        ArrayList<ProxyConnectorRuleConfiguration> proxyConnectorRuleConfigurations = new ArrayList<ProxyConnectorRuleConfiguration>();
        List proxyConnectorRuleConfigurationsSubsets = registry.getSubsetList(prefix + "proxyConnectorRuleConfigurations.proxyConnectorRuleConfiguration");
        Iterator i8 = proxyConnectorRuleConfigurationsSubsets.iterator();
        while (i8.hasNext()) {
            ProxyConnectorRuleConfiguration v = this.readProxyConnectorRuleConfiguration("", (Registry)i8.next());
            proxyConnectorRuleConfigurations.add(v);
        }
        value.setProxyConnectorRuleConfigurations(proxyConnectorRuleConfigurations);
        return value;
    }

    private AbstractRepositoryConfiguration readAbstractRepositoryConfiguration(String prefix, Registry registry) {
        AbstractRepositoryConfiguration value = new AbstractRepositoryConfiguration();
        String id = registry.getString(prefix + "id", value.getId());
        value.setId(id);
        String name = registry.getString(prefix + "name", value.getName());
        value.setName(name);
        String layout = registry.getString(prefix + "layout", value.getLayout());
        value.setLayout(layout);
        String indexDir = registry.getString(prefix + "indexDir", value.getIndexDir());
        value.setIndexDir(indexDir);
        String description = registry.getString(prefix + "description", value.getDescription());
        value.setDescription(description);
        return value;
    }

    private RemoteRepositoryConfiguration readRemoteRepositoryConfiguration(String prefix, Registry registry) {
        RemoteRepositoryConfiguration value = new RemoteRepositoryConfiguration();
        String url = registry.getString(prefix + "url", value.getUrl());
        value.setUrl(url);
        String username = registry.getString(prefix + "username", value.getUsername());
        value.setUsername(username);
        String password = registry.getString(prefix + "password", value.getPassword());
        value.setPassword(password);
        int timeout = registry.getInt(prefix + "timeout", value.getTimeout());
        value.setTimeout(timeout);
        String refreshCronExpression = registry.getString(prefix + "refreshCronExpression", value.getRefreshCronExpression());
        value.setRefreshCronExpression(refreshCronExpression);
        boolean downloadRemoteIndex = registry.getBoolean(prefix + "downloadRemoteIndex", value.isDownloadRemoteIndex());
        value.setDownloadRemoteIndex(downloadRemoteIndex);
        String remoteIndexUrl = registry.getString(prefix + "remoteIndexUrl", value.getRemoteIndexUrl());
        value.setRemoteIndexUrl(remoteIndexUrl);
        String remoteDownloadNetworkProxyId = registry.getString(prefix + "remoteDownloadNetworkProxyId", value.getRemoteDownloadNetworkProxyId());
        value.setRemoteDownloadNetworkProxyId(remoteDownloadNetworkProxyId);
        int remoteDownloadTimeout = registry.getInt(prefix + "remoteDownloadTimeout", value.getRemoteDownloadTimeout());
        value.setRemoteDownloadTimeout(remoteDownloadTimeout);
        boolean downloadRemoteIndexOnStartup = registry.getBoolean(prefix + "downloadRemoteIndexOnStartup", value.isDownloadRemoteIndexOnStartup());
        value.setDownloadRemoteIndexOnStartup(downloadRemoteIndexOnStartup);
        String id = registry.getString(prefix + "id", value.getId());
        value.setId(id);
        String name = registry.getString(prefix + "name", value.getName());
        value.setName(name);
        String layout = registry.getString(prefix + "layout", value.getLayout());
        value.setLayout(layout);
        String indexDir = registry.getString(prefix + "indexDir", value.getIndexDir());
        value.setIndexDir(indexDir);
        String description = registry.getString(prefix + "description", value.getDescription());
        value.setDescription(description);
        return value;
    }

    private ManagedRepositoryConfiguration readManagedRepositoryConfiguration(String prefix, Registry registry) {
        ManagedRepositoryConfiguration value = new ManagedRepositoryConfiguration();
        String location = registry.getString(prefix + "location", value.getLocation());
        value.setLocation(location);
        boolean releases = registry.getBoolean(prefix + "releases", value.isReleases());
        value.setReleases(releases);
        boolean blockRedeployments = registry.getBoolean(prefix + "blockRedeployments", value.isBlockRedeployments());
        value.setBlockRedeployments(blockRedeployments);
        boolean snapshots = registry.getBoolean(prefix + "snapshots", value.isSnapshots());
        value.setSnapshots(snapshots);
        boolean scanned = registry.getBoolean(prefix + "scanned", value.isScanned());
        value.setScanned(scanned);
        String refreshCronExpression = registry.getString(prefix + "refreshCronExpression", value.getRefreshCronExpression());
        value.setRefreshCronExpression(refreshCronExpression);
        int retentionCount = registry.getInt(prefix + "retentionCount", value.getRetentionCount());
        value.setRetentionCount(retentionCount);
        int daysOlder = registry.getInt(prefix + "daysOlder", value.getDaysOlder());
        value.setDaysOlder(daysOlder);
        boolean deleteReleasedSnapshots = registry.getBoolean(prefix + "deleteReleasedSnapshots", value.isDeleteReleasedSnapshots());
        value.setDeleteReleasedSnapshots(deleteReleasedSnapshots);
        boolean skipPackedIndexCreation = registry.getBoolean(prefix + "skipPackedIndexCreation", value.isSkipPackedIndexCreation());
        value.setSkipPackedIndexCreation(skipPackedIndexCreation);
        boolean stageRepoNeeded = registry.getBoolean(prefix + "stageRepoNeeded", value.isStageRepoNeeded());
        value.setStageRepoNeeded(stageRepoNeeded);
        String id = registry.getString(prefix + "id", value.getId());
        value.setId(id);
        String name = registry.getString(prefix + "name", value.getName());
        value.setName(name);
        String layout = registry.getString(prefix + "layout", value.getLayout());
        value.setLayout(layout);
        String indexDir = registry.getString(prefix + "indexDir", value.getIndexDir());
        value.setIndexDir(indexDir);
        String description = registry.getString(prefix + "description", value.getDescription());
        value.setDescription(description);
        return value;
    }

    private V1RepositoryConfiguration readV1RepositoryConfiguration(String prefix, Registry registry) {
        V1RepositoryConfiguration value = new V1RepositoryConfiguration();
        String url = registry.getString(prefix + "url", value.getUrl());
        value.setUrl(url);
        boolean indexed = registry.getBoolean(prefix + "indexed", value.isIndexed());
        value.setIndexed(indexed);
        String location = registry.getString(prefix + "location", value.getLocation());
        value.setLocation(location);
        boolean releases = registry.getBoolean(prefix + "releases", value.isReleases());
        value.setReleases(releases);
        boolean blockRedeployments = registry.getBoolean(prefix + "blockRedeployments", value.isBlockRedeployments());
        value.setBlockRedeployments(blockRedeployments);
        boolean snapshots = registry.getBoolean(prefix + "snapshots", value.isSnapshots());
        value.setSnapshots(snapshots);
        boolean scanned = registry.getBoolean(prefix + "scanned", value.isScanned());
        value.setScanned(scanned);
        String refreshCronExpression = registry.getString(prefix + "refreshCronExpression", value.getRefreshCronExpression());
        value.setRefreshCronExpression(refreshCronExpression);
        int retentionCount = registry.getInt(prefix + "retentionCount", value.getRetentionCount());
        value.setRetentionCount(retentionCount);
        int daysOlder = registry.getInt(prefix + "daysOlder", value.getDaysOlder());
        value.setDaysOlder(daysOlder);
        boolean deleteReleasedSnapshots = registry.getBoolean(prefix + "deleteReleasedSnapshots", value.isDeleteReleasedSnapshots());
        value.setDeleteReleasedSnapshots(deleteReleasedSnapshots);
        boolean skipPackedIndexCreation = registry.getBoolean(prefix + "skipPackedIndexCreation", value.isSkipPackedIndexCreation());
        value.setSkipPackedIndexCreation(skipPackedIndexCreation);
        boolean stageRepoNeeded = registry.getBoolean(prefix + "stageRepoNeeded", value.isStageRepoNeeded());
        value.setStageRepoNeeded(stageRepoNeeded);
        String id = registry.getString(prefix + "id", value.getId());
        value.setId(id);
        String name = registry.getString(prefix + "name", value.getName());
        value.setName(name);
        String layout = registry.getString(prefix + "layout", value.getLayout());
        value.setLayout(layout);
        String indexDir = registry.getString(prefix + "indexDir", value.getIndexDir());
        value.setIndexDir(indexDir);
        String description = registry.getString(prefix + "description", value.getDescription());
        value.setDescription(description);
        return value;
    }

    private LegacyArtifactPath readLegacyArtifactPath(String prefix, Registry registry) {
        LegacyArtifactPath value = new LegacyArtifactPath();
        String path = registry.getString(prefix + "path", value.getPath());
        value.setPath(path);
        String artifact = registry.getString(prefix + "artifact", value.getArtifact());
        value.setArtifact(artifact);
        return value;
    }

    private RepositoryGroupConfiguration readRepositoryGroupConfiguration(String prefix, Registry registry) {
        RepositoryGroupConfiguration value = new RepositoryGroupConfiguration();
        String id = registry.getString(prefix + "id", value.getId());
        value.setId(id);
        ArrayList<String> repositories = new ArrayList<String>();
        repositories.addAll(registry.getList(prefix + "repositories.repository"));
        value.setRepositories(repositories);
        return value;
    }

    private AbstractRepositoryConnectorConfiguration readAbstractRepositoryConnectorConfiguration(String prefix, Registry registry) {
        AbstractRepositoryConnectorConfiguration value = new AbstractRepositoryConnectorConfiguration();
        String sourceRepoId = registry.getString(prefix + "sourceRepoId", value.getSourceRepoId());
        value.setSourceRepoId(sourceRepoId);
        String targetRepoId = registry.getString(prefix + "targetRepoId", value.getTargetRepoId());
        value.setTargetRepoId(targetRepoId);
        String proxyId = registry.getString(prefix + "proxyId", value.getProxyId());
        value.setProxyId(proxyId);
        ArrayList<String> blackListPatterns = new ArrayList<String>();
        blackListPatterns.addAll(registry.getList(prefix + "blackListPatterns.blackListPattern"));
        value.setBlackListPatterns(blackListPatterns);
        ArrayList<String> whiteListPatterns = new ArrayList<String>();
        whiteListPatterns.addAll(registry.getList(prefix + "whiteListPatterns.whiteListPattern"));
        value.setWhiteListPatterns(whiteListPatterns);
        Properties policies = registry.getProperties(prefix + "policies");
        value.setPolicies(policies);
        Properties properties = registry.getProperties(prefix + "properties");
        value.setProperties(properties);
        boolean disabled = registry.getBoolean(prefix + "disabled", value.isDisabled());
        value.setDisabled(disabled);
        return value;
    }

    private ProxyConnectorRuleConfiguration readProxyConnectorRuleConfiguration(String prefix, Registry registry) {
        ProxyConnectorRuleConfiguration value = new ProxyConnectorRuleConfiguration();
        String ruleType = registry.getString(prefix + "ruleType", value.getRuleType());
        value.setRuleType(ruleType);
        String pattern = registry.getString(prefix + "pattern", value.getPattern());
        value.setPattern(pattern);
        ArrayList<ProxyConnectorConfiguration> proxyConnectors = new ArrayList<ProxyConnectorConfiguration>();
        List proxyConnectorsSubsets = registry.getSubsetList(prefix + "proxyConnectors.proxyConnector");
        Iterator i = proxyConnectorsSubsets.iterator();
        while (i.hasNext()) {
            ProxyConnectorConfiguration v = this.readProxyConnectorConfiguration("", (Registry)i.next());
            proxyConnectors.add(v);
        }
        value.setProxyConnectors(proxyConnectors);
        return value;
    }

    private ProxyConnectorConfiguration readProxyConnectorConfiguration(String prefix, Registry registry) {
        ProxyConnectorConfiguration value = new ProxyConnectorConfiguration();
        int order = registry.getInt(prefix + "order", value.getOrder());
        value.setOrder(order);
        String sourceRepoId = registry.getString(prefix + "sourceRepoId", value.getSourceRepoId());
        value.setSourceRepoId(sourceRepoId);
        String targetRepoId = registry.getString(prefix + "targetRepoId", value.getTargetRepoId());
        value.setTargetRepoId(targetRepoId);
        String proxyId = registry.getString(prefix + "proxyId", value.getProxyId());
        value.setProxyId(proxyId);
        ArrayList<String> blackListPatterns = new ArrayList<String>();
        blackListPatterns.addAll(registry.getList(prefix + "blackListPatterns.blackListPattern"));
        value.setBlackListPatterns(blackListPatterns);
        ArrayList<String> whiteListPatterns = new ArrayList<String>();
        whiteListPatterns.addAll(registry.getList(prefix + "whiteListPatterns.whiteListPattern"));
        value.setWhiteListPatterns(whiteListPatterns);
        Properties policies = registry.getProperties(prefix + "policies");
        value.setPolicies(policies);
        Properties properties = registry.getProperties(prefix + "properties");
        value.setProperties(properties);
        boolean disabled = registry.getBoolean(prefix + "disabled", value.isDisabled());
        value.setDisabled(disabled);
        return value;
    }

    private SyncConnectorConfiguration readSyncConnectorConfiguration(String prefix, Registry registry) {
        SyncConnectorConfiguration value = new SyncConnectorConfiguration();
        String cronExpression = registry.getString(prefix + "cronExpression", value.getCronExpression());
        value.setCronExpression(cronExpression);
        String method = registry.getString(prefix + "method", value.getMethod());
        value.setMethod(method);
        String sourceRepoId = registry.getString(prefix + "sourceRepoId", value.getSourceRepoId());
        value.setSourceRepoId(sourceRepoId);
        String targetRepoId = registry.getString(prefix + "targetRepoId", value.getTargetRepoId());
        value.setTargetRepoId(targetRepoId);
        String proxyId = registry.getString(prefix + "proxyId", value.getProxyId());
        value.setProxyId(proxyId);
        ArrayList<String> blackListPatterns = new ArrayList<String>();
        blackListPatterns.addAll(registry.getList(prefix + "blackListPatterns.blackListPattern"));
        value.setBlackListPatterns(blackListPatterns);
        ArrayList<String> whiteListPatterns = new ArrayList<String>();
        whiteListPatterns.addAll(registry.getList(prefix + "whiteListPatterns.whiteListPattern"));
        value.setWhiteListPatterns(whiteListPatterns);
        Properties policies = registry.getProperties(prefix + "policies");
        value.setPolicies(policies);
        Properties properties = registry.getProperties(prefix + "properties");
        value.setProperties(properties);
        boolean disabled = registry.getBoolean(prefix + "disabled", value.isDisabled());
        value.setDisabled(disabled);
        return value;
    }

    private NetworkProxyConfiguration readNetworkProxyConfiguration(String prefix, Registry registry) {
        NetworkProxyConfiguration value = new NetworkProxyConfiguration();
        String id = registry.getString(prefix + "id", value.getId());
        value.setId(id);
        String protocol = registry.getString(prefix + "protocol", value.getProtocol());
        value.setProtocol(protocol);
        String host = registry.getString(prefix + "host", value.getHost());
        value.setHost(host);
        int port = registry.getInt(prefix + "port", value.getPort());
        value.setPort(port);
        String username = registry.getString(prefix + "username", value.getUsername());
        value.setUsername(username);
        String password = registry.getString(prefix + "password", value.getPassword());
        value.setPassword(password);
        boolean useNtlm = registry.getBoolean(prefix + "useNtlm", value.isUseNtlm());
        value.setUseNtlm(useNtlm);
        return value;
    }

    private RepositoryScanningConfiguration readRepositoryScanningConfiguration(String prefix, Registry registry) {
        RepositoryScanningConfiguration value = new RepositoryScanningConfiguration();
        ArrayList<FileType> fileTypes = new ArrayList<FileType>();
        List fileTypesSubsets = registry.getSubsetList(prefix + "fileTypes.fileType");
        Iterator i = fileTypesSubsets.iterator();
        while (i.hasNext()) {
            FileType v = this.readFileType("", (Registry)i.next());
            fileTypes.add(v);
        }
        value.setFileTypes(fileTypes);
        ArrayList<String> knownContentConsumers = new ArrayList<String>();
        knownContentConsumers.addAll(registry.getList(prefix + "knownContentConsumers.knownContentConsumer"));
        value.setKnownContentConsumers(knownContentConsumers);
        ArrayList<String> invalidContentConsumers = new ArrayList<String>();
        invalidContentConsumers.addAll(registry.getList(prefix + "invalidContentConsumers.invalidContentConsumer"));
        value.setInvalidContentConsumers(invalidContentConsumers);
        return value;
    }

    private FileType readFileType(String prefix, Registry registry) {
        FileType value = new FileType();
        String id = registry.getString(prefix + "id", value.getId());
        value.setId(id);
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.addAll(registry.getList(prefix + "patterns.pattern"));
        value.setPatterns(patterns);
        return value;
    }

    private OrganisationInformation readOrganisationInformation(String prefix, Registry registry) {
        OrganisationInformation value = new OrganisationInformation();
        String name = registry.getString(prefix + "name", value.getName());
        value.setName(name);
        String url = registry.getString(prefix + "url", value.getUrl());
        value.setUrl(url);
        String logoLocation = registry.getString(prefix + "logoLocation", value.getLogoLocation());
        value.setLogoLocation(logoLocation);
        return value;
    }

    private WebappConfiguration readWebappConfiguration(String prefix, Registry registry) {
        WebappConfiguration value = new WebappConfiguration();
        UserInterfaceOptions ui = this.readUserInterfaceOptions(prefix + "ui.", registry);
        value.setUi(ui);
        return value;
    }

    private UserInterfaceOptions readUserInterfaceOptions(String prefix, Registry registry) {
        UserInterfaceOptions value = new UserInterfaceOptions();
        boolean showFindArtifacts = registry.getBoolean(prefix + "showFindArtifacts", value.isShowFindArtifacts());
        value.setShowFindArtifacts(showFindArtifacts);
        boolean appletFindEnabled = registry.getBoolean(prefix + "appletFindEnabled", value.isAppletFindEnabled());
        value.setAppletFindEnabled(appletFindEnabled);
        boolean disableEasterEggs = registry.getBoolean(prefix + "disableEasterEggs", value.isDisableEasterEggs());
        value.setDisableEasterEggs(disableEasterEggs);
        String applicationUrl = registry.getString(prefix + "applicationUrl", value.getApplicationUrl());
        value.setApplicationUrl(applicationUrl);
        boolean disableRegistration = registry.getBoolean(prefix + "disableRegistration", value.isDisableRegistration());
        value.setDisableRegistration(disableRegistration);
        return value;
    }

    private NetworkConfiguration readNetworkConfiguration(String prefix, Registry registry) {
        NetworkConfiguration value = new NetworkConfiguration();
        int maxTotal = registry.getInt(prefix + "maxTotal", value.getMaxTotal());
        value.setMaxTotal(maxTotal);
        int maxTotalPerHost = registry.getInt(prefix + "maxTotalPerHost", value.getMaxTotalPerHost());
        value.setMaxTotalPerHost(maxTotalPerHost);
        boolean usePooling = registry.getBoolean(prefix + "usePooling", value.isUsePooling());
        value.setUsePooling(usePooling);
        return value;
    }
}

