// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.7,
// any modifications will be overwritten.
// ==============================================================

package org.apache.archiva.configuration;

/**
 * Class LegacyArtifactPath.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class LegacyArtifactPath
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The legacy path.
     *           
     */
    private String path;

    /**
     * 
     *             The artifact reference, as " [groupId] :
     * [artifactId] : [version] : [classifier] : [type] ".
     *           
     */
    private String artifact;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the artifact reference, as " [groupId] : [artifactId] :
     * [version] : [classifier] : [type] ".
     * 
     * @return String
     */
    public String getArtifact()
    {
        return this.artifact;
    } //-- String getArtifact()

    /**
     * Get the legacy path.
     * 
     * @return String
     */
    public String getPath()
    {
        return this.path;
    } //-- String getPath()

    /**
     * Set the artifact reference, as " [groupId] : [artifactId] :
     * [version] : [classifier] : [type] ".
     * 
     * @param artifact
     */
    public void setArtifact( String artifact )
    {
        this.artifact = artifact;
    } //-- void setArtifact( String )

    /**
     * Set the legacy path.
     * 
     * @param path
     */
    public void setPath( String path )
    {
        this.path = path;
    } //-- void setPath( String )

    
    public boolean match( String path )
    {
        return path.equals( this.path );
    }

    public String getGroupId()
    {
        return artifact.split( ":" )[0];
    }

    public String getArtifactId()
    {
        return artifact.split( ":" )[1];
    }
        
    public String getVersion()
    {
        return artifact.split( ":" )[2];
    }
    
    public String getClassifier()
    {
        String classifier = artifact.split( ":" )[3];
        return classifier.length() > 0 ? classifier : null;
    }
    
    public String getType()
    {
        return artifact.split( ":" )[4];
    }

    @Override
    public boolean equals( Object o )
    {
        if ( this == o )
        {
            return true;
        }
        if ( o == null || getClass() != o.getClass() )
        {
            return false;
        }

        LegacyArtifactPath that = (LegacyArtifactPath) o;

        if ( path != null ? !path.equals( that.path ) : that.path != null )
        {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode()
    {
        return path != null ? 37 + path.hashCode() : 0;
    }
       
}
