/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.configuration.io.registry;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.archiva.configuration.AbstractRepositoryConfiguration;
import org.apache.archiva.configuration.AbstractRepositoryConnectorConfiguration;
import org.apache.archiva.configuration.ArchivaRuntimeConfiguration;
import org.apache.archiva.configuration.CacheConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.FileType;
import org.apache.archiva.configuration.LdapConfiguration;
import org.apache.archiva.configuration.LdapGroupMapping;
import org.apache.archiva.configuration.LegacyArtifactPath;
import org.apache.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.archiva.configuration.NetworkConfiguration;
import org.apache.archiva.configuration.NetworkProxyConfiguration;
import org.apache.archiva.configuration.OrganisationInformation;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.ProxyConnectorRuleConfiguration;
import org.apache.archiva.configuration.RedbackRuntimeConfiguration;
import org.apache.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.archiva.configuration.RepositoryScanningConfiguration;
import org.apache.archiva.configuration.SyncConnectorConfiguration;
import org.apache.archiva.configuration.UserInterfaceOptions;
import org.apache.archiva.configuration.V1RepositoryConfiguration;
import org.apache.archiva.configuration.WebappConfiguration;
import org.apache.archiva.redback.components.registry.Registry;

public class ConfigurationRegistryWriter {
    public void write(Configuration model, Registry registry) {
        this.writeConfiguration("", model, registry);
    }

    private void writeConfiguration(String prefix, Configuration value, Registry registry) {
        if (value != null) {
            Serializable o;
            String name;
            Iterator<Serializable> iter;
            if (value.getVersion() != null) {
                String version = "version";
                registry.setString(prefix + version, value.getVersion());
            }
            if (value.getRepositories() != null && value.getRepositories().size() > 0) {
                registry.removeSubset(prefix + "repositories");
                int count = 0;
                iter = value.getRepositories().iterator();
                while (iter.hasNext()) {
                    name = "repositories.repository(" + count + ")";
                    o = (V1RepositoryConfiguration)iter.next();
                    this.writeV1RepositoryConfiguration(prefix + name + ".", (V1RepositoryConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getRepositoryGroups() != null && value.getRepositoryGroups().size() > 0) {
                registry.removeSubset(prefix + "repositoryGroups");
                int count = 0;
                iter = value.getRepositoryGroups().iterator();
                while (iter.hasNext()) {
                    name = "repositoryGroups.repositoryGroup(" + count + ")";
                    o = (RepositoryGroupConfiguration)iter.next();
                    this.writeRepositoryGroupConfiguration(prefix + name + ".", (RepositoryGroupConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getManagedRepositories() != null && value.getManagedRepositories().size() > 0) {
                registry.removeSubset(prefix + "managedRepositories");
                int count = 0;
                iter = value.getManagedRepositories().iterator();
                while (iter.hasNext()) {
                    name = "managedRepositories.managedRepository(" + count + ")";
                    o = (ManagedRepositoryConfiguration)iter.next();
                    this.writeManagedRepositoryConfiguration(prefix + name + ".", (ManagedRepositoryConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getRemoteRepositories() != null && value.getRemoteRepositories().size() > 0) {
                registry.removeSubset(prefix + "remoteRepositories");
                int count = 0;
                iter = value.getRemoteRepositories().iterator();
                while (iter.hasNext()) {
                    name = "remoteRepositories.remoteRepository(" + count + ")";
                    o = (RemoteRepositoryConfiguration)iter.next();
                    this.writeRemoteRepositoryConfiguration(prefix + name + ".", (RemoteRepositoryConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getProxyConnectors() != null && value.getProxyConnectors().size() > 0) {
                registry.removeSubset(prefix + "proxyConnectors");
                int count = 0;
                iter = value.getProxyConnectors().iterator();
                while (iter.hasNext()) {
                    name = "proxyConnectors.proxyConnector(" + count + ")";
                    o = (ProxyConnectorConfiguration)iter.next();
                    this.writeProxyConnectorConfiguration(prefix + name + ".", (ProxyConnectorConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getNetworkProxies() != null && value.getNetworkProxies().size() > 0) {
                registry.removeSubset(prefix + "networkProxies");
                int count = 0;
                iter = value.getNetworkProxies().iterator();
                while (iter.hasNext()) {
                    name = "networkProxies.networkProxy(" + count + ")";
                    o = (NetworkProxyConfiguration)iter.next();
                    this.writeNetworkProxyConfiguration(prefix + name + ".", (NetworkProxyConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getLegacyArtifactPaths() != null && value.getLegacyArtifactPaths().size() > 0) {
                registry.removeSubset(prefix + "legacyArtifactPaths");
                int count = 0;
                iter = value.getLegacyArtifactPaths().iterator();
                while (iter.hasNext()) {
                    name = "legacyArtifactPaths.legacyArtifactPath(" + count + ")";
                    o = (LegacyArtifactPath)iter.next();
                    this.writeLegacyArtifactPath(prefix + name + ".", (LegacyArtifactPath)o, registry);
                    ++count;
                }
            }
            if (value.getRepositoryScanning() != null) {
                this.writeRepositoryScanningConfiguration(prefix + "repositoryScanning.", value.getRepositoryScanning(), registry);
            }
            if (value.getWebapp() != null) {
                this.writeWebappConfiguration(prefix + "webapp.", value.getWebapp(), registry);
            }
            if (value.getOrganisationInfo() != null) {
                this.writeOrganisationInformation(prefix + "organisationInfo.", value.getOrganisationInfo(), registry);
            }
            if (value.getNetworkConfiguration() != null) {
                this.writeNetworkConfiguration(prefix + "networkConfiguration.", value.getNetworkConfiguration(), registry);
            }
            if (value.getRedbackRuntimeConfiguration() != null) {
                this.writeRedbackRuntimeConfiguration(prefix + "redbackRuntimeConfiguration.", value.getRedbackRuntimeConfiguration(), registry);
            }
            if (value.getArchivaRuntimeConfiguration() != null) {
                this.writeArchivaRuntimeConfiguration(prefix + "archivaRuntimeConfiguration.", value.getArchivaRuntimeConfiguration(), registry);
            }
            if (value.getProxyConnectorRuleConfigurations() != null && value.getProxyConnectorRuleConfigurations().size() > 0) {
                registry.removeSubset(prefix + "proxyConnectorRuleConfigurations");
                int count = 0;
                iter = value.getProxyConnectorRuleConfigurations().iterator();
                while (iter.hasNext()) {
                    name = "proxyConnectorRuleConfigurations.proxyConnectorRuleConfiguration(" + count + ")";
                    o = (ProxyConnectorRuleConfiguration)iter.next();
                    this.writeProxyConnectorRuleConfiguration(prefix + name + ".", (ProxyConnectorRuleConfiguration)o, registry);
                    ++count;
                }
            }
        }
    }

    private void writeAbstractRepositoryConfiguration(String prefix, AbstractRepositoryConfiguration value, Registry registry) {
        if (value != null) {
            if (value.getId() != null) {
                String id = "id";
                registry.setString(prefix + id, value.getId());
            }
            if (value.getName() != null) {
                String name = "name";
                registry.setString(prefix + name, value.getName());
            }
            if (value.getLayout() != null && !value.getLayout().equals("default")) {
                String layout = "layout";
                registry.setString(prefix + layout, value.getLayout());
            }
            if (value.getIndexDir() != null) {
                String indexDir = "indexDir";
                registry.setString(prefix + indexDir, value.getIndexDir());
            }
            if (value.getDescription() != null) {
                String description = "description";
                registry.setString(prefix + description, value.getDescription());
            }
        }
    }

    private void writeRemoteRepositoryConfiguration(String prefix, RemoteRepositoryConfiguration value, Registry registry) {
        if (value != null) {
            String v;
            if (value.getUrl() != null) {
                String url = "url";
                registry.setString(prefix + url, value.getUrl());
            }
            if (value.getUsername() != null) {
                String username = "username";
                registry.setString(prefix + username, value.getUsername());
            }
            if (value.getPassword() != null) {
                String password = "password";
                registry.setString(prefix + password, value.getPassword());
            }
            if (value.getTimeout() != 60) {
                String timeout = "timeout";
                registry.setInt(prefix + timeout, value.getTimeout());
            }
            if (value.getRefreshCronExpression() != null && !value.getRefreshCronExpression().equals("0 0 08 ? * SUN")) {
                String refreshCronExpression = "refreshCronExpression";
                registry.setString(prefix + refreshCronExpression, value.getRefreshCronExpression());
            }
            String downloadRemoteIndex = "downloadRemoteIndex";
            registry.setBoolean(prefix + downloadRemoteIndex, value.isDownloadRemoteIndex());
            if (value.getRemoteIndexUrl() != null) {
                String remoteIndexUrl = "remoteIndexUrl";
                registry.setString(prefix + remoteIndexUrl, value.getRemoteIndexUrl());
            }
            if (value.getRemoteDownloadNetworkProxyId() != null) {
                String remoteDownloadNetworkProxyId = "remoteDownloadNetworkProxyId";
                registry.setString(prefix + remoteDownloadNetworkProxyId, value.getRemoteDownloadNetworkProxyId());
            }
            if (value.getRemoteDownloadTimeout() != 300) {
                String remoteDownloadTimeout = "remoteDownloadTimeout";
                registry.setInt(prefix + remoteDownloadTimeout, value.getRemoteDownloadTimeout());
            }
            String downloadRemoteIndexOnStartup = "downloadRemoteIndexOnStartup";
            registry.setBoolean(prefix + downloadRemoteIndexOnStartup, value.isDownloadRemoteIndexOnStartup());
            if (value.getExtraParameters() != null && value.getExtraParameters().size() > 0) {
                registry.removeSubset(prefix + "extraParameters");
                for (String key : value.getExtraParameters().keySet()) {
                    v = (String)value.getExtraParameters().get(key);
                    registry.setString(prefix + "extraParameters." + key, v);
                }
            }
            if (value.getExtraHeaders() != null && value.getExtraHeaders().size() > 0) {
                registry.removeSubset(prefix + "extraHeaders");
                for (String key : value.getExtraHeaders().keySet()) {
                    v = (String)value.getExtraHeaders().get(key);
                    registry.setString(prefix + "extraHeaders." + key, v);
                }
            }
            if (value.getId() != null) {
                String id = "id";
                registry.setString(prefix + id, value.getId());
            }
            if (value.getName() != null) {
                String name = "name";
                registry.setString(prefix + name, value.getName());
            }
            if (value.getLayout() != null && !value.getLayout().equals("default")) {
                String layout = "layout";
                registry.setString(prefix + layout, value.getLayout());
            }
            if (value.getIndexDir() != null) {
                String indexDir = "indexDir";
                registry.setString(prefix + indexDir, value.getIndexDir());
            }
            if (value.getDescription() != null) {
                String description = "description";
                registry.setString(prefix + description, value.getDescription());
            }
        }
    }

    private void writeManagedRepositoryConfiguration(String prefix, ManagedRepositoryConfiguration value, Registry registry) {
        if (value != null) {
            if (value.getLocation() != null) {
                String location = "location";
                registry.setString(prefix + location, value.getLocation());
            }
            String releases = "releases";
            registry.setBoolean(prefix + releases, value.isReleases());
            String blockRedeployments = "blockRedeployments";
            registry.setBoolean(prefix + blockRedeployments, value.isBlockRedeployments());
            String snapshots = "snapshots";
            registry.setBoolean(prefix + snapshots, value.isSnapshots());
            String scanned = "scanned";
            registry.setBoolean(prefix + scanned, value.isScanned());
            if (value.getRefreshCronExpression() != null && !value.getRefreshCronExpression().equals("0 0 * * * ?")) {
                String refreshCronExpression = "refreshCronExpression";
                registry.setString(prefix + refreshCronExpression, value.getRefreshCronExpression());
            }
            if (value.getRetentionCount() != 2) {
                String retentionCount = "retentionCount";
                registry.setInt(prefix + retentionCount, value.getRetentionCount());
            }
            if (value.getDaysOlder() != 100) {
                String daysOlder = "daysOlder";
                registry.setInt(prefix + daysOlder, value.getDaysOlder());
            }
            String deleteReleasedSnapshots = "deleteReleasedSnapshots";
            registry.setBoolean(prefix + deleteReleasedSnapshots, value.isDeleteReleasedSnapshots());
            String skipPackedIndexCreation = "skipPackedIndexCreation";
            registry.setBoolean(prefix + skipPackedIndexCreation, value.isSkipPackedIndexCreation());
            String stageRepoNeeded = "stageRepoNeeded";
            registry.setBoolean(prefix + stageRepoNeeded, value.isStageRepoNeeded());
            if (value.getId() != null) {
                String id = "id";
                registry.setString(prefix + id, value.getId());
            }
            if (value.getName() != null) {
                String name = "name";
                registry.setString(prefix + name, value.getName());
            }
            if (value.getLayout() != null && !value.getLayout().equals("default")) {
                String layout = "layout";
                registry.setString(prefix + layout, value.getLayout());
            }
            if (value.getIndexDir() != null) {
                String indexDir = "indexDir";
                registry.setString(prefix + indexDir, value.getIndexDir());
            }
            if (value.getDescription() != null) {
                String description = "description";
                registry.setString(prefix + description, value.getDescription());
            }
        }
    }

    private void writeV1RepositoryConfiguration(String prefix, V1RepositoryConfiguration value, Registry registry) {
        if (value != null) {
            if (value.getUrl() != null) {
                String url = "url";
                registry.setString(prefix + url, value.getUrl());
            }
            String indexed = "indexed";
            registry.setBoolean(prefix + indexed, value.isIndexed());
            if (value.getLocation() != null) {
                String location = "location";
                registry.setString(prefix + location, value.getLocation());
            }
            String releases = "releases";
            registry.setBoolean(prefix + releases, value.isReleases());
            String blockRedeployments = "blockRedeployments";
            registry.setBoolean(prefix + blockRedeployments, value.isBlockRedeployments());
            String snapshots = "snapshots";
            registry.setBoolean(prefix + snapshots, value.isSnapshots());
            String scanned = "scanned";
            registry.setBoolean(prefix + scanned, value.isScanned());
            if (value.getRefreshCronExpression() != null && !value.getRefreshCronExpression().equals("0 0 * * * ?")) {
                String refreshCronExpression = "refreshCronExpression";
                registry.setString(prefix + refreshCronExpression, value.getRefreshCronExpression());
            }
            if (value.getRetentionCount() != 2) {
                String retentionCount = "retentionCount";
                registry.setInt(prefix + retentionCount, value.getRetentionCount());
            }
            if (value.getDaysOlder() != 100) {
                String daysOlder = "daysOlder";
                registry.setInt(prefix + daysOlder, value.getDaysOlder());
            }
            String deleteReleasedSnapshots = "deleteReleasedSnapshots";
            registry.setBoolean(prefix + deleteReleasedSnapshots, value.isDeleteReleasedSnapshots());
            String skipPackedIndexCreation = "skipPackedIndexCreation";
            registry.setBoolean(prefix + skipPackedIndexCreation, value.isSkipPackedIndexCreation());
            String stageRepoNeeded = "stageRepoNeeded";
            registry.setBoolean(prefix + stageRepoNeeded, value.isStageRepoNeeded());
            if (value.getId() != null) {
                String id = "id";
                registry.setString(prefix + id, value.getId());
            }
            if (value.getName() != null) {
                String name = "name";
                registry.setString(prefix + name, value.getName());
            }
            if (value.getLayout() != null && !value.getLayout().equals("default")) {
                String layout = "layout";
                registry.setString(prefix + layout, value.getLayout());
            }
            if (value.getIndexDir() != null) {
                String indexDir = "indexDir";
                registry.setString(prefix + indexDir, value.getIndexDir());
            }
            if (value.getDescription() != null) {
                String description = "description";
                registry.setString(prefix + description, value.getDescription());
            }
        }
    }

    private void writeLegacyArtifactPath(String prefix, LegacyArtifactPath value, Registry registry) {
        if (value != null) {
            if (value.getPath() != null) {
                String path = "path";
                registry.setString(prefix + path, value.getPath());
            }
            if (value.getArtifact() != null) {
                String artifact = "artifact";
                registry.setString(prefix + artifact, value.getArtifact());
            }
        }
    }

    private void writeRepositoryGroupConfiguration(String prefix, RepositoryGroupConfiguration value, Registry registry) {
        if (value != null) {
            if (value.getId() != null) {
                String id = "id";
                registry.setString(prefix + id, value.getId());
            }
            if (value.getMergedIndexPath() != null && !value.getMergedIndexPath().equals("/.indexer")) {
                String mergedIndexPath = "mergedIndexPath";
                registry.setString(prefix + mergedIndexPath, value.getMergedIndexPath());
            }
            if (value.getMergedIndexTtl() != 30) {
                String mergedIndexTtl = "mergedIndexTtl";
                registry.setInt(prefix + mergedIndexTtl, value.getMergedIndexTtl());
            }
            if (value.getRepositories() != null && value.getRepositories().size() > 0) {
                registry.removeSubset(prefix + "repositories");
                int count = 0;
                Iterator<String> iter = value.getRepositories().iterator();
                while (iter.hasNext()) {
                    String name = "repositories.repository(" + count + ")";
                    String repository = iter.next();
                    registry.setString(prefix + name, repository);
                    ++count;
                }
            }
        }
    }

    private void writeAbstractRepositoryConnectorConfiguration(String prefix, AbstractRepositoryConnectorConfiguration value, Registry registry) {
        if (value != null) {
            String v;
            String name;
            Iterator<String> iter;
            if (value.getSourceRepoId() != null) {
                String sourceRepoId = "sourceRepoId";
                registry.setString(prefix + sourceRepoId, value.getSourceRepoId());
            }
            if (value.getTargetRepoId() != null) {
                String targetRepoId = "targetRepoId";
                registry.setString(prefix + targetRepoId, value.getTargetRepoId());
            }
            if (value.getProxyId() != null) {
                String proxyId = "proxyId";
                registry.setString(prefix + proxyId, value.getProxyId());
            }
            if (value.getBlackListPatterns() != null && value.getBlackListPatterns().size() > 0) {
                registry.removeSubset(prefix + "blackListPatterns");
                int count = 0;
                iter = value.getBlackListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "blackListPatterns.blackListPattern(" + count + ")";
                    String blackListPattern = iter.next();
                    registry.setString(prefix + name, blackListPattern);
                    ++count;
                }
            }
            if (value.getWhiteListPatterns() != null && value.getWhiteListPatterns().size() > 0) {
                registry.removeSubset(prefix + "whiteListPatterns");
                int count = 0;
                iter = value.getWhiteListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "whiteListPatterns.whiteListPattern(" + count + ")";
                    String whiteListPattern = iter.next();
                    registry.setString(prefix + name, whiteListPattern);
                    ++count;
                }
            }
            if (value.getPolicies() != null && value.getPolicies().size() > 0) {
                registry.removeSubset(prefix + "policies");
                for (String key : value.getPolicies().keySet()) {
                    v = (String)value.getPolicies().get(key);
                    registry.setString(prefix + "policies." + key, v);
                }
            }
            if (value.getProperties() != null && value.getProperties().size() > 0) {
                registry.removeSubset(prefix + "properties");
                for (String key : value.getProperties().keySet()) {
                    v = (String)value.getProperties().get(key);
                    registry.setString(prefix + "properties." + key, v);
                }
            }
            String disabled = "disabled";
            registry.setBoolean(prefix + disabled, value.isDisabled());
        }
    }

    private void writeProxyConnectorRuleConfiguration(String prefix, ProxyConnectorRuleConfiguration value, Registry registry) {
        if (value != null) {
            if (value.getRuleType() != null) {
                String ruleType = "ruleType";
                registry.setString(prefix + ruleType, value.getRuleType());
            }
            if (value.getPattern() != null) {
                String pattern = "pattern";
                registry.setString(prefix + pattern, value.getPattern());
            }
            if (value.getProxyConnectors() != null && value.getProxyConnectors().size() > 0) {
                registry.removeSubset(prefix + "proxyConnectors");
                int count = 0;
                Iterator<ProxyConnectorConfiguration> iter = value.getProxyConnectors().iterator();
                while (iter.hasNext()) {
                    String name = "proxyConnectors.proxyConnector(" + count + ")";
                    ProxyConnectorConfiguration o = iter.next();
                    this.writeProxyConnectorConfiguration(prefix + name + ".", o, registry);
                    ++count;
                }
            }
        }
    }

    private void writeProxyConnectorConfiguration(String prefix, ProxyConnectorConfiguration value, Registry registry) {
        if (value != null) {
            String v;
            String name;
            Iterator<String> iter;
            if (value.getOrder() != 0) {
                String order = "order";
                registry.setInt(prefix + order, value.getOrder());
            }
            if (value.getSourceRepoId() != null) {
                String sourceRepoId = "sourceRepoId";
                registry.setString(prefix + sourceRepoId, value.getSourceRepoId());
            }
            if (value.getTargetRepoId() != null) {
                String targetRepoId = "targetRepoId";
                registry.setString(prefix + targetRepoId, value.getTargetRepoId());
            }
            if (value.getProxyId() != null) {
                String proxyId = "proxyId";
                registry.setString(prefix + proxyId, value.getProxyId());
            }
            if (value.getBlackListPatterns() != null && value.getBlackListPatterns().size() > 0) {
                registry.removeSubset(prefix + "blackListPatterns");
                int count = 0;
                iter = value.getBlackListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "blackListPatterns.blackListPattern(" + count + ")";
                    String blackListPattern = iter.next();
                    registry.setString(prefix + name, blackListPattern);
                    ++count;
                }
            }
            if (value.getWhiteListPatterns() != null && value.getWhiteListPatterns().size() > 0) {
                registry.removeSubset(prefix + "whiteListPatterns");
                int count = 0;
                iter = value.getWhiteListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "whiteListPatterns.whiteListPattern(" + count + ")";
                    String whiteListPattern = iter.next();
                    registry.setString(prefix + name, whiteListPattern);
                    ++count;
                }
            }
            if (value.getPolicies() != null && value.getPolicies().size() > 0) {
                registry.removeSubset(prefix + "policies");
                for (String key : value.getPolicies().keySet()) {
                    v = (String)value.getPolicies().get(key);
                    registry.setString(prefix + "policies." + key, v);
                }
            }
            if (value.getProperties() != null && value.getProperties().size() > 0) {
                registry.removeSubset(prefix + "properties");
                for (String key : value.getProperties().keySet()) {
                    v = (String)value.getProperties().get(key);
                    registry.setString(prefix + "properties." + key, v);
                }
            }
            String disabled = "disabled";
            registry.setBoolean(prefix + disabled, value.isDisabled());
        }
    }

    private void writeSyncConnectorConfiguration(String prefix, SyncConnectorConfiguration value, Registry registry) {
        if (value != null) {
            String v;
            String name;
            Iterator<String> iter;
            if (value.getCronExpression() != null && !value.getCronExpression().equals("0 0 * * * ?")) {
                String cronExpression = "cronExpression";
                registry.setString(prefix + cronExpression, value.getCronExpression());
            }
            if (value.getMethod() != null && !value.getMethod().equals("rsync")) {
                String method = "method";
                registry.setString(prefix + method, value.getMethod());
            }
            if (value.getSourceRepoId() != null) {
                String sourceRepoId = "sourceRepoId";
                registry.setString(prefix + sourceRepoId, value.getSourceRepoId());
            }
            if (value.getTargetRepoId() != null) {
                String targetRepoId = "targetRepoId";
                registry.setString(prefix + targetRepoId, value.getTargetRepoId());
            }
            if (value.getProxyId() != null) {
                String proxyId = "proxyId";
                registry.setString(prefix + proxyId, value.getProxyId());
            }
            if (value.getBlackListPatterns() != null && value.getBlackListPatterns().size() > 0) {
                registry.removeSubset(prefix + "blackListPatterns");
                int count = 0;
                iter = value.getBlackListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "blackListPatterns.blackListPattern(" + count + ")";
                    String blackListPattern = iter.next();
                    registry.setString(prefix + name, blackListPattern);
                    ++count;
                }
            }
            if (value.getWhiteListPatterns() != null && value.getWhiteListPatterns().size() > 0) {
                registry.removeSubset(prefix + "whiteListPatterns");
                int count = 0;
                iter = value.getWhiteListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "whiteListPatterns.whiteListPattern(" + count + ")";
                    String whiteListPattern = iter.next();
                    registry.setString(prefix + name, whiteListPattern);
                    ++count;
                }
            }
            if (value.getPolicies() != null && value.getPolicies().size() > 0) {
                registry.removeSubset(prefix + "policies");
                for (String key : value.getPolicies().keySet()) {
                    v = (String)value.getPolicies().get(key);
                    registry.setString(prefix + "policies." + key, v);
                }
            }
            if (value.getProperties() != null && value.getProperties().size() > 0) {
                registry.removeSubset(prefix + "properties");
                for (String key : value.getProperties().keySet()) {
                    v = (String)value.getProperties().get(key);
                    registry.setString(prefix + "properties." + key, v);
                }
            }
            String disabled = "disabled";
            registry.setBoolean(prefix + disabled, value.isDisabled());
        }
    }

    private void writeNetworkProxyConfiguration(String prefix, NetworkProxyConfiguration value, Registry registry) {
        if (value != null) {
            if (value.getId() != null) {
                String id = "id";
                registry.setString(prefix + id, value.getId());
            }
            if (value.getProtocol() != null && !value.getProtocol().equals("http")) {
                String protocol = "protocol";
                registry.setString(prefix + protocol, value.getProtocol());
            }
            if (value.getHost() != null) {
                String host = "host";
                registry.setString(prefix + host, value.getHost());
            }
            if (value.getPort() != 8080) {
                String port = "port";
                registry.setInt(prefix + port, value.getPort());
            }
            if (value.getUsername() != null) {
                String username = "username";
                registry.setString(prefix + username, value.getUsername());
            }
            if (value.getPassword() != null) {
                String password = "password";
                registry.setString(prefix + password, value.getPassword());
            }
            String useNtlm = "useNtlm";
            registry.setBoolean(prefix + useNtlm, value.isUseNtlm());
        }
    }

    private void writeRepositoryScanningConfiguration(String prefix, RepositoryScanningConfiguration value, Registry registry) {
        if (value != null) {
            String name;
            Iterator<Object> iter;
            int count;
            if (value.getFileTypes() != null && value.getFileTypes().size() > 0) {
                registry.removeSubset(prefix + "fileTypes");
                count = 0;
                iter = value.getFileTypes().iterator();
                while (iter.hasNext()) {
                    name = "fileTypes.fileType(" + count + ")";
                    FileType o = (FileType)iter.next();
                    this.writeFileType(prefix + name + ".", o, registry);
                    ++count;
                }
            }
            if (value.getKnownContentConsumers() != null && value.getKnownContentConsumers().size() > 0) {
                registry.removeSubset(prefix + "knownContentConsumers");
                count = 0;
                iter = value.getKnownContentConsumers().iterator();
                while (iter.hasNext()) {
                    name = "knownContentConsumers.knownContentConsumer(" + count + ")";
                    String knownContentConsumer = (String)iter.next();
                    registry.setString(prefix + name, knownContentConsumer);
                    ++count;
                }
            }
            if (value.getInvalidContentConsumers() != null && value.getInvalidContentConsumers().size() > 0) {
                registry.removeSubset(prefix + "invalidContentConsumers");
                count = 0;
                iter = value.getInvalidContentConsumers().iterator();
                while (iter.hasNext()) {
                    name = "invalidContentConsumers.invalidContentConsumer(" + count + ")";
                    String invalidContentConsumer = (String)iter.next();
                    registry.setString(prefix + name, invalidContentConsumer);
                    ++count;
                }
            }
        }
    }

    private void writeFileType(String prefix, FileType value, Registry registry) {
        if (value != null) {
            if (value.getId() != null) {
                String id = "id";
                registry.setString(prefix + id, value.getId());
            }
            if (value.getPatterns() != null && value.getPatterns().size() > 0) {
                registry.removeSubset(prefix + "patterns");
                int count = 0;
                Iterator<String> iter = value.getPatterns().iterator();
                while (iter.hasNext()) {
                    String name = "patterns.pattern(" + count + ")";
                    String pattern = iter.next();
                    registry.setString(prefix + name, pattern);
                    ++count;
                }
            }
        }
    }

    private void writeOrganisationInformation(String prefix, OrganisationInformation value, Registry registry) {
        if (value != null) {
            if (value.getName() != null) {
                String name = "name";
                registry.setString(prefix + name, value.getName());
            }
            if (value.getUrl() != null) {
                String url = "url";
                registry.setString(prefix + url, value.getUrl());
            }
            if (value.getLogoLocation() != null) {
                String logoLocation = "logoLocation";
                registry.setString(prefix + logoLocation, value.getLogoLocation());
            }
        }
    }

    private void writeWebappConfiguration(String prefix, WebappConfiguration value, Registry registry) {
        if (value != null && value.getUi() != null) {
            this.writeUserInterfaceOptions(prefix + "ui.", value.getUi(), registry);
        }
    }

    private void writeUserInterfaceOptions(String prefix, UserInterfaceOptions value, Registry registry) {
        if (value != null) {
            String showFindArtifacts = "showFindArtifacts";
            registry.setBoolean(prefix + showFindArtifacts, value.isShowFindArtifacts());
            String appletFindEnabled = "appletFindEnabled";
            registry.setBoolean(prefix + appletFindEnabled, value.isAppletFindEnabled());
            String disableEasterEggs = "disableEasterEggs";
            registry.setBoolean(prefix + disableEasterEggs, value.isDisableEasterEggs());
            if (value.getApplicationUrl() != null) {
                String applicationUrl = "applicationUrl";
                registry.setString(prefix + applicationUrl, value.getApplicationUrl());
            }
            String disableRegistration = "disableRegistration";
            registry.setBoolean(prefix + disableRegistration, value.isDisableRegistration());
        }
    }

    private void writeNetworkConfiguration(String prefix, NetworkConfiguration value, Registry registry) {
        if (value != null) {
            if (value.getMaxTotal() != 30) {
                String maxTotal = "maxTotal";
                registry.setInt(prefix + maxTotal, value.getMaxTotal());
            }
            if (value.getMaxTotalPerHost() != 30) {
                String maxTotalPerHost = "maxTotalPerHost";
                registry.setInt(prefix + maxTotalPerHost, value.getMaxTotalPerHost());
            }
            String usePooling = "usePooling";
            registry.setBoolean(prefix + usePooling, value.isUsePooling());
        }
    }

    private void writeArchivaRuntimeConfiguration(String prefix, ArchivaRuntimeConfiguration value, Registry registry) {
        if (value != null && value.getUrlFailureCacheConfiguration() != null) {
            this.writeCacheConfiguration(prefix + "urlFailureCacheConfiguration.", value.getUrlFailureCacheConfiguration(), registry);
        }
    }

    private void writeRedbackRuntimeConfiguration(String prefix, RedbackRuntimeConfiguration value, Registry registry) {
        if (value != null) {
            String name;
            Iterator<Object> iter;
            int count;
            String migratedFromRedbackConfiguration = "migratedFromRedbackConfiguration";
            registry.setBoolean(prefix + migratedFromRedbackConfiguration, value.isMigratedFromRedbackConfiguration());
            if (value.getUserManagerImpls() != null && value.getUserManagerImpls().size() > 0) {
                registry.removeSubset(prefix + "userManagerImpls");
                count = 0;
                iter = value.getUserManagerImpls().iterator();
                while (iter.hasNext()) {
                    name = "userManagerImpls.userManagerImpl(" + count + ")";
                    String userManagerImpl = (String)iter.next();
                    registry.setString(prefix + name, userManagerImpl);
                    ++count;
                }
            }
            if (value.getRbacManagerImpls() != null && value.getRbacManagerImpls().size() > 0) {
                registry.removeSubset(prefix + "rbacManagerImpls");
                count = 0;
                iter = value.getRbacManagerImpls().iterator();
                while (iter.hasNext()) {
                    name = "rbacManagerImpls.rbacManagerImpl(" + count + ")";
                    String rbacManagerImpl = (String)iter.next();
                    registry.setString(prefix + name, rbacManagerImpl);
                    ++count;
                }
            }
            if (value.getLdapConfiguration() != null) {
                this.writeLdapConfiguration(prefix + "ldapConfiguration.", value.getLdapConfiguration(), registry);
            }
            if (value.getLdapGroupMappings() != null && value.getLdapGroupMappings().size() > 0) {
                registry.removeSubset(prefix + "ldapGroupMappings");
                count = 0;
                iter = value.getLdapGroupMappings().iterator();
                while (iter.hasNext()) {
                    name = "ldapGroupMappings.ldapGroupMapping(" + count + ")";
                    LdapGroupMapping o = (LdapGroupMapping)iter.next();
                    this.writeLdapGroupMapping(prefix + name + ".", o, registry);
                    ++count;
                }
            }
            if (value.getConfigurationProperties() != null && value.getConfigurationProperties().size() > 0) {
                registry.removeSubset(prefix + "configurationProperties");
                for (String key : value.getConfigurationProperties().keySet()) {
                    String v = (String)value.getConfigurationProperties().get(key);
                    registry.setString(prefix + "configurationProperties." + key, v);
                }
            }
            String useUsersCache = "useUsersCache";
            registry.setBoolean(prefix + useUsersCache, value.isUseUsersCache());
            if (value.getUsersCacheConfiguration() != null) {
                this.writeCacheConfiguration(prefix + "usersCacheConfiguration.", value.getUsersCacheConfiguration(), registry);
            }
        }
    }

    private void writeLdapConfiguration(String prefix, LdapConfiguration value, Registry registry) {
        if (value != null) {
            if (value.getHostName() != null) {
                String hostName = "hostName";
                registry.setString(prefix + hostName, value.getHostName());
            }
            if (value.getPort() != 0) {
                String port = "port";
                registry.setInt(prefix + port, value.getPort());
            }
            String ssl = "ssl";
            registry.setBoolean(prefix + ssl, value.isSsl());
            if (value.getBaseDn() != null) {
                String baseDn = "baseDn";
                registry.setString(prefix + baseDn, value.getBaseDn());
            }
            if (value.getBaseGroupsDn() != null) {
                String baseGroupsDn = "baseGroupsDn";
                registry.setString(prefix + baseGroupsDn, value.getBaseGroupsDn());
            }
            if (value.getContextFactory() != null) {
                String contextFactory = "contextFactory";
                registry.setString(prefix + contextFactory, value.getContextFactory());
            }
            if (value.getBindDn() != null) {
                String bindDn = "bindDn";
                registry.setString(prefix + bindDn, value.getBindDn());
            }
            if (value.getPassword() != null) {
                String password = "password";
                registry.setString(prefix + password, value.getPassword());
            }
            if (value.getAuthenticationMethod() != null) {
                String authenticationMethod = "authenticationMethod";
                registry.setString(prefix + authenticationMethod, value.getAuthenticationMethod());
            }
            String bindAuthenticatorEnabled = "bindAuthenticatorEnabled";
            registry.setBoolean(prefix + bindAuthenticatorEnabled, value.isBindAuthenticatorEnabled());
            String writable = "writable";
            registry.setBoolean(prefix + writable, value.isWritable());
            String useRoleNameAsGroup = "useRoleNameAsGroup";
            registry.setBoolean(prefix + useRoleNameAsGroup, value.isUseRoleNameAsGroup());
            if (value.getExtraProperties() != null && value.getExtraProperties().size() > 0) {
                registry.removeSubset(prefix + "extraProperties");
                for (String key : value.getExtraProperties().keySet()) {
                    String v = (String)value.getExtraProperties().get(key);
                    registry.setString(prefix + "extraProperties." + key, v);
                }
            }
        }
    }

    private void writeCacheConfiguration(String prefix, CacheConfiguration value, Registry registry) {
        if (value != null) {
            if (value.getTimeToIdleSeconds() != -1) {
                String timeToIdleSeconds = "timeToIdleSeconds";
                registry.setInt(prefix + timeToIdleSeconds, value.getTimeToIdleSeconds());
            }
            if (value.getTimeToLiveSeconds() != -1) {
                String timeToLiveSeconds = "timeToLiveSeconds";
                registry.setInt(prefix + timeToLiveSeconds, value.getTimeToLiveSeconds());
            }
            if (value.getMaxElementsInMemory() != -1) {
                String maxElementsInMemory = "maxElementsInMemory";
                registry.setInt(prefix + maxElementsInMemory, value.getMaxElementsInMemory());
            }
            if (value.getMaxElementsOnDisk() != -1) {
                String maxElementsOnDisk = "maxElementsOnDisk";
                registry.setInt(prefix + maxElementsOnDisk, value.getMaxElementsOnDisk());
            }
        }
    }

    private void writeLdapGroupMapping(String prefix, LdapGroupMapping value, Registry registry) {
        if (value != null) {
            if (value.getGroup() != null) {
                String group = "group";
                registry.setString(prefix + group, value.getGroup());
            }
            if (value.getRoleNames() != null && value.getRoleNames().size() > 0) {
                registry.removeSubset(prefix + "roleNames");
                int count = 0;
                Iterator<String> iter = value.getRoleNames().iterator();
                while (iter.hasNext()) {
                    String name = "roleNames.roleName(" + count + ")";
                    String roleName = iter.next();
                    registry.setString(prefix + name, roleName);
                    ++count;
                }
            }
        }
    }
}

