// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.7,
// any modifications will be overwritten.
// ==============================================================

package org.apache.archiva.configuration;

/**
 * Class RepositoryGroupConfiguration.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class RepositoryGroupConfiguration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The id of the repository group.
     */
    private String id;

    /**
     * The path of the merged index.
     */
    private String mergedIndexPath = "/.indexer";

    /**
     * The time to live of the merged index of the repository group.
     */
    private int mergedIndexTtl = 30;

    /**
     * 
     *           When to run the index merging for this group.
     *           No default value.
     *           
     */
    private String cronExpression = "";

    /**
     * Field repositories.
     */
    private java.util.List<String> repositories;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addRepository.
     * 
     * @param string
     */
    public void addRepository( String string )
    {
        getRepositories().add( string );
    } //-- void addRepository( String )

    /**
     * Get when to run the index merging for this group.
     *           No default value.
     * 
     * @return String
     */
    public String getCronExpression()
    {
        return this.cronExpression;
    } //-- String getCronExpression()

    /**
     * Get the id of the repository group.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId()

    /**
     * Get the path of the merged index.
     * 
     * @return String
     */
    public String getMergedIndexPath()
    {
        return this.mergedIndexPath;
    } //-- String getMergedIndexPath()

    /**
     * Get the time to live of the merged index of the repository
     * group.
     * 
     * @return int
     */
    public int getMergedIndexTtl()
    {
        return this.mergedIndexTtl;
    } //-- int getMergedIndexTtl()

    /**
     * Method getRepositories.
     * 
     * @return List
     */
    public java.util.List<String> getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList<String>();
        }

        return this.repositories;
    } //-- java.util.List<String> getRepositories()

    /**
     * Method removeRepository.
     * 
     * @param string
     */
    public void removeRepository( String string )
    {
        getRepositories().remove( string );
    } //-- void removeRepository( String )

    /**
     * Set when to run the index merging for this group.
     *           No default value.
     * 
     * @param cronExpression
     */
    public void setCronExpression( String cronExpression )
    {
        this.cronExpression = cronExpression;
    } //-- void setCronExpression( String )

    /**
     * Set the id of the repository group.
     * 
     * @param id
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String )

    /**
     * Set the path of the merged index.
     * 
     * @param mergedIndexPath
     */
    public void setMergedIndexPath( String mergedIndexPath )
    {
        this.mergedIndexPath = mergedIndexPath;
    } //-- void setMergedIndexPath( String )

    /**
     * Set the time to live of the merged index of the repository
     * group.
     * 
     * @param mergedIndexTtl
     */
    public void setMergedIndexTtl( int mergedIndexTtl )
    {
        this.mergedIndexTtl = mergedIndexTtl;
    } //-- void setMergedIndexTtl( int )

    /**
     * Set the list of repository ids under the group.
     * 
     * @param repositories
     */
    public void setRepositories( java.util.List<String> repositories )
    {
        this.repositories = repositories;
    } //-- void setRepositories( java.util.List )

}
