package org.apache.maven.archiva.database.constraints;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.model.RepositoryContentStatistics;

/**
 * MostRecentRepositoryScanStatistics
 *
 * @version $Id: MostRecentRepositoryScanStatistics.java 755266 2009-03-17 14:28:40Z brett $
 */
public class MostRecentRepositoryScanStatistics
    extends AbstractSimpleConstraint
{
    private String sql;

    public MostRecentRepositoryScanStatistics( String repoId )
    {
        sql = "SELECT FROM " + RepositoryContentStatistics.class.getName() +
            " WHERE repositoryId == repoId PARAMETERS String repoId" + " ORDER BY whenGathered DESCENDING" +
            " RANGE 0,1";

        super.params = new Object[]{repoId};
    }

    public Class<?> getResultClass()
    {
        return RepositoryContentStatistics.class;
    }

    public String getSelectSql()
    {
        return sql;
    }
}
