/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.dependencytree;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.DefaultMavenProjectBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.StateDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.traversal.BuildingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.FilteringDependencyNodeVisitor;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyTreeGeneratorConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer {
    private File generatedRepositoryLocation;
    private File localRepository;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private MavenProjectBuilder projectBuilder;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private String repositoryLocation;
    private final DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
    private ArtifactRepository localArtifactRepository;
    private Field rawProjectCacheField;
    private Field processedProjectCacheField;
    private List<String> includes = Collections.singletonList("**/*.pom");

    public String getDescription() {
        return "Generate dependency tree metadata for tracking changes across algorithms";
    }

    public String getId() {
        return "dependency-tree-generator";
    }

    public boolean isPermanent() {
        return false;
    }

    public void setGeneratedRepositoryLocation(File generatedRepositoryLocation) {
        this.generatedRepositoryLocation = generatedRepositoryLocation;
    }

    public void beginScan(ManagedRepositoryConfiguration repository, Date whenGathered) throws ConsumerException {
        this.repositoryLocation = repository.getLocation();
        if (this.generatedRepositoryLocation == null) {
            this.generatedRepositoryLocation = new File(this.repositoryLocation);
        }
        if (this.localRepository == null) {
            this.localRepository = new File(System.getProperty("user.home"), ".m2/repository");
            try {
                this.localArtifactRepository = this.artifactRepositoryFactory.createArtifactRepository("local", this.localRepository.toURL().toExternalForm(), (ArtifactRepositoryLayout)this.layout, null, null);
            }
            catch (MalformedURLException e) {
                throw new ConsumerException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void beginScan(ManagedRepositoryConfiguration repository, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        this.beginScan(repository, whenGathered);
    }

    public void completeScan() {
    }

    public void completeScan(boolean executeOnEntireRepo) {
        this.completeScan();
    }

    public List<String> getExcludes() {
        return null;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void processFile(String path) throws ConsumerException {
        DependencyNode rootNode;
        MavenProject project;
        try {
            project = this.projectBuilder.build(new File(this.repositoryLocation, path), this.localArtifactRepository, null, false);
            this.flushProjectCache(this.projectBuilder);
        }
        catch (ProjectBuildingException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
        try {
            ArtifactFilter artifactFilter = null;
            rootNode = this.dependencyTreeBuilder.buildDependencyTree(project, this.localArtifactRepository, this.artifactFactory, this.artifactMetadataSource, artifactFilter, this.artifactCollector);
        }
        catch (DependencyTreeBuilderException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
        Document document = DocumentHelper.createDocument();
        XmlSerializingDependencyNodeVisitor visitor = new XmlSerializingDependencyNodeVisitor(document);
        visitor = new BuildingDependencyNodeVisitor((DependencyNodeVisitor)visitor);
        CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
        FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, (DependencyNodeFilter)StateDependencyNodeFilter.INCLUDED);
        rootNode.accept((DependencyNodeVisitor)firstPassVisitor);
        AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
        visitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)visitor, (DependencyNodeFilter)secondPassFilter);
        rootNode.accept((DependencyNodeVisitor)visitor);
        FileWriter writer = null;
        try {
            Artifact artifact = this.artifactFactory.createProjectArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion());
            String p = this.layout.pathOf(artifact);
            if (!p.equals(path)) {
                throw new ConsumerException("Bad path: " + p + "; should be: " + path);
            }
            File generatedFile = new File(this.generatedRepositoryLocation, p + ".xml");
            generatedFile.getParentFile().mkdirs();
            writer = new FileWriter(generatedFile);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter w = new XMLWriter((Writer)writer, format);
            w.write(document);
        }
        catch (IOException e) {
            try {
                throw new ConsumerException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws ConsumerException {
        this.processFile(path);
    }

    private void flushProjectCache(MavenProjectBuilder projectBuilder) {
        try {
            if (this.rawProjectCacheField == null) {
                this.rawProjectCacheField = DefaultMavenProjectBuilder.class.getDeclaredField("rawProjectCache");
                this.rawProjectCacheField.setAccessible(true);
            }
            if (this.processedProjectCacheField == null) {
                this.processedProjectCacheField = DefaultMavenProjectBuilder.class.getDeclaredField("processedProjectCache");
                this.processedProjectCacheField.setAccessible(true);
            }
            this.rawProjectCacheField.set(projectBuilder, new HashMap());
            this.processedProjectCacheField.set(projectBuilder, new HashMap());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    private static class XmlSerializingDependencyNodeVisitor
    implements DependencyNodeVisitor {
        private Element xmlNode;

        public XmlSerializingDependencyNodeVisitor(Document document) {
            this.xmlNode = document.addElement("tree");
        }

        public boolean visit(DependencyNode node) {
            Element dependency = this.xmlNode.addElement("dependency");
            Artifact artifact = node.getArtifact();
            dependency.addElement("groupId").setText(artifact.getGroupId());
            dependency.addElement("artifactId").setText(artifact.getArtifactId());
            dependency.addElement("type").setText(artifact.getType());
            dependency.addElement("version").setText(artifact.getVersion());
            if (artifact.getScope() != null) {
                dependency.addElement("scope").setText(artifact.getScope());
            }
            if (artifact.getClassifier() != null) {
                dependency.addElement("classifier").setText(artifact.getClassifier());
            }
            this.xmlNode = dependency.addElement("dependencies");
            return true;
        }

        public boolean endVisit(DependencyNode node) {
            Element e = this.xmlNode.getParent();
            if (!this.xmlNode.hasContent()) {
                e.remove(this.xmlNode);
            }
            this.xmlNode = e.getParent();
            return true;
        }
    }
}

