/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.indexer.merger;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import org.apache.archiva.common.plexusbridge.MavenIndexerUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.indexer.merger.IndexMerger;
import org.apache.archiva.indexer.merger.IndexMergerException;
import org.apache.archiva.indexer.merger.IndexMergerRequest;
import org.apache.archiva.indexer.merger.TemporaryGroupIndex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.apache.maven.index.packer.IndexPacker;
import org.apache.maven.index.packer.IndexPackingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="indexMerger#default")
public class DefaultIndexMerger
implements IndexMerger {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MavenIndexerUtils mavenIndexerUtils;
    private NexusIndexer indexer;
    private IndexPacker indexPacker;
    private List<TemporaryGroupIndex> temporaryGroupIndexes = new CopyOnWriteArrayList<TemporaryGroupIndex>();
    private List<String> runningGroups = new CopyOnWriteArrayList<String>();

    @Inject
    public DefaultIndexMerger(PlexusSisuBridge plexusSisuBridge, MavenIndexerUtils mavenIndexerUtils) throws PlexusSisuBridgeException {
        this.indexer = (NexusIndexer)plexusSisuBridge.lookup(NexusIndexer.class);
        this.mavenIndexerUtils = mavenIndexerUtils;
        this.indexPacker = (IndexPacker)plexusSisuBridge.lookup(IndexPacker.class, "default");
    }

    @Override
    public IndexingContext buildMergedIndex(IndexMergerRequest indexMergerRequest) throws IndexMergerException {
        String groupId = indexMergerRequest.getGroupId();
        if (this.runningGroups.contains(groupId)) {
            this.log.info("skip build merge remote indexes for id: '{}' as already running", (Object)groupId);
            return null;
        }
        this.runningGroups.add(groupId);
        StopWatch stopWatch = new StopWatch();
        stopWatch.reset();
        stopWatch.start();
        File mergedIndexDirectory = indexMergerRequest.getMergedIndexDirectory();
        String tempRepoId = mergedIndexDirectory.getName();
        try {
            File indexLocation = new File(mergedIndexDirectory, indexMergerRequest.getMergedIndexPath());
            IndexingContext indexingContext = this.indexer.addIndexingContext(tempRepoId, tempRepoId, mergedIndexDirectory, indexLocation, null, null, this.mavenIndexerUtils.getAllIndexCreators());
            for (String repoId : indexMergerRequest.getRepositoriesIds()) {
                IndexingContext idxToMerge = (IndexingContext)this.indexer.getIndexingContexts().get(repoId);
                if (idxToMerge == null) continue;
                indexingContext.merge(idxToMerge.getIndexDirectory());
            }
            indexingContext.optimize();
            if (indexMergerRequest.isPackIndex()) {
                IndexPackingRequest request = new IndexPackingRequest(indexingContext, indexLocation);
                this.indexPacker.packIndex(request);
            }
            if (indexMergerRequest.isTemporary()) {
                this.temporaryGroupIndexes.add(new TemporaryGroupIndex(mergedIndexDirectory, tempRepoId, groupId, indexMergerRequest.getMergedIndexTtl()));
            }
            stopWatch.stop();
            this.log.info("merged index for repos {} in {} s", indexMergerRequest.getRepositoriesIds(), (Object)stopWatch.getTime());
            IndexingContext indexingContext2 = indexingContext;
            return indexingContext2;
        }
        catch (IOException e) {
            throw new IndexMergerException(e.getMessage(), e);
        }
        catch (UnsupportedExistingLuceneIndexException e) {
            throw new IndexMergerException(e.getMessage(), e);
        }
        finally {
            this.runningGroups.remove(groupId);
        }
    }

    @Override
    @Async
    public void cleanTemporaryGroupIndex(TemporaryGroupIndex temporaryGroupIndex) {
        if (temporaryGroupIndex == null) {
            return;
        }
        try {
            File directory;
            IndexingContext indexingContext = (IndexingContext)this.indexer.getIndexingContexts().get(temporaryGroupIndex.getIndexId());
            if (indexingContext != null) {
                this.indexer.removeIndexingContext(indexingContext, true);
            }
            if ((directory = temporaryGroupIndex.getDirectory()) != null && directory.exists()) {
                FileUtils.deleteDirectory((File)directory);
            }
            this.temporaryGroupIndexes.remove(temporaryGroupIndex);
        }
        catch (IOException e) {
            this.log.warn("fail to delete temporary group index {}", (Object)temporaryGroupIndex.getIndexId(), (Object)e);
        }
    }

    @Override
    public Collection<TemporaryGroupIndex> getTemporaryGroupIndexes() {
        return this.temporaryGroupIndexes;
    }
}

