/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.lucene;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.database.updater.DatabaseCleanupConsumer;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;
import org.apache.maven.archiva.scheduled.ArchivaTaskScheduler;
import org.apache.maven.archiva.scheduled.tasks.ArtifactIndexingTask;
import org.apache.maven.archiva.scheduled.tasks.TaskCreator;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneCleanupRemoveIndexedConsumer
extends AbstractMonitoredConsumer
implements DatabaseCleanupConsumer {
    private static final Logger log = LoggerFactory.getLogger(LuceneCleanupRemoveIndexedConsumer.class);
    private RepositoryContentFactory repoFactory;
    private ArchivaTaskScheduler scheduler;

    public LuceneCleanupRemoveIndexedConsumer(RepositoryContentFactory repoFactory, ArchivaTaskScheduler scheduler) {
        this.repoFactory = repoFactory;
        this.scheduler = scheduler;
    }

    public void beginScan() {
    }

    public void completeScan() {
    }

    public List<String> getIncludedTypes() {
        return null;
    }

    public void processArchivaArtifact(ArchivaArtifact artifact) throws ConsumerException {
        ManagedRepositoryContent repoContent = null;
        try {
            repoContent = this.repoFactory.getManagedRepositoryContent(artifact.getModel().getRepositoryId());
        }
        catch (RepositoryException e) {
            throw new ConsumerException("Can't run index cleanup consumer: " + e.getMessage());
        }
        ManagedRepositoryConfiguration repository = repoContent.getRepository();
        IndexingContext context = null;
        try {
            File artifactFile = new File(repoContent.getRepoRoot(), repoContent.toPath(artifact));
            if (!artifactFile.exists()) {
                context = TaskCreator.createContext((ManagedRepositoryConfiguration)repository);
                ArtifactIndexingTask task = TaskCreator.createIndexingTask((ManagedRepositoryConfiguration)repository, (File)artifactFile, (ArtifactIndexingTask.Action)ArtifactIndexingTask.Action.DELETE, (IndexingContext)context);
                log.debug("Queueing indexing task '" + task + "' to remove the artifact from the index.");
                this.scheduler.queueIndexingTask(task);
                task = TaskCreator.createIndexingTask((ManagedRepositoryConfiguration)repository, (File)artifactFile, (ArtifactIndexingTask.Action)ArtifactIndexingTask.Action.FINISH, (IndexingContext)context);
                log.debug("Queueing indexing task + '" + task + "' to finish indexing.");
                this.scheduler.queueIndexingTask(task);
            }
        }
        catch (TaskQueueException e) {
            throw new ConsumerException(e.getMessage());
        }
        catch (IOException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedExistingLuceneIndexException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
    }

    public String getDescription() {
        return "Remove indexed content if not present on filesystem.";
    }

    public String getId() {
        return "not-present-remove-indexed";
    }

    public boolean isPermanent() {
        return false;
    }

    public void setRepositoryContentFactory(RepositoryContentFactory repoFactory) {
        this.repoFactory = repoFactory;
    }
}

