/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ConfigurationNames;
import org.apache.maven.archiva.configuration.FileTypes;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.maven.archiva.repository.content.ManagedDefaultRepositoryContent;
import org.apache.maven.archiva.scheduled.ArchivaTaskScheduler;
import org.apache.maven.archiva.scheduled.tasks.ArtifactIndexingTask;
import org.apache.maven.archiva.scheduled.tasks.TaskCreator;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryListener;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusIndexerConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer,
RegistryListener,
Initializable {
    private static final Logger log = LoggerFactory.getLogger(NexusIndexerConsumer.class);
    private ArchivaConfiguration configuration;
    private FileTypes filetypes;
    private ManagedDefaultRepositoryContent repositoryContent;
    private File managedRepository;
    private ArchivaTaskScheduler scheduler;
    private IndexingContext context;
    private List<String> includes = new ArrayList<String>();
    private ManagedRepositoryConfiguration repository;

    public NexusIndexerConsumer(ArchivaTaskScheduler scheduler, ArchivaConfiguration configuration, FileTypes filetypes) {
        this.configuration = configuration;
        this.filetypes = filetypes;
        this.scheduler = scheduler;
    }

    public String getDescription() {
        return "Indexes the repository to provide search and IDE integration features";
    }

    public String getId() {
        return "index-content";
    }

    public boolean isPermanent() {
        return false;
    }

    public void beginScan(ManagedRepositoryConfiguration repository, Date whenGathered) throws ConsumerException {
        this.managedRepository = new File(repository.getLocation());
        this.repositoryContent = new ManagedDefaultRepositoryContent();
        this.repositoryContent.setRepository(repository);
        try {
            log.info("Creating indexing context for repo : " + repository.getId());
            this.context = TaskCreator.createContext((ManagedRepositoryConfiguration)repository);
        }
        catch (IOException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedExistingLuceneIndexException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
    }

    public void beginScan(ManagedRepositoryConfiguration repository, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        if (executeOnEntireRepo) {
            this.beginScan(repository, whenGathered);
        } else {
            this.repository = repository;
            this.managedRepository = new File(repository.getLocation());
        }
    }

    public void processFile(String path) throws ConsumerException {
        File artifactFile = new File(this.managedRepository, path);
        ArtifactIndexingTask task = TaskCreator.createIndexingTask((ManagedRepositoryConfiguration)this.repositoryContent.getRepository(), (File)artifactFile, (ArtifactIndexingTask.Action)ArtifactIndexingTask.Action.ADD, (IndexingContext)this.context);
        try {
            log.debug("Queueing indexing task + '" + task + "' to add or update the artifact in the index.");
            this.scheduler.queueIndexingTask(task);
        }
        catch (TaskQueueException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws Exception {
        if (executeOnEntireRepo) {
            this.processFile(path);
        } else {
            File artifactFile = new File(this.managedRepository, path);
            ArtifactIndexingTask task = new ArtifactIndexingTask(this.repository, artifactFile, ArtifactIndexingTask.Action.ADD, this.context, false);
            try {
                log.debug("Queueing indexing task + '" + task + "' to add or update the artifact in the index.");
                this.scheduler.queueIndexingTask(task);
            }
            catch (TaskQueueException e) {
                throw new ConsumerException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void completeScan() {
        ArtifactIndexingTask task = TaskCreator.createIndexingTask((ManagedRepositoryConfiguration)this.repositoryContent.getRepository(), null, (ArtifactIndexingTask.Action)ArtifactIndexingTask.Action.FINISH, (IndexingContext)this.context);
        try {
            log.debug("Queueing indexing task + '" + task + "' to finish indexing.");
            this.scheduler.queueIndexingTask(task);
        }
        catch (TaskQueueException e) {
            log.error("Error queueing task: " + task + ": " + e.getMessage(), (Throwable)e);
        }
        this.context = null;
    }

    public void completeScan(boolean executeOnEntireRepo) {
        if (executeOnEntireRepo) {
            this.completeScan();
        }
    }

    public List<String> getExcludes() {
        return Collections.emptyList();
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isRepositoryScanning((String)propertyName)) {
            this.initIncludes();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    private void initIncludes() {
        this.includes.clear();
        this.includes.addAll(this.filetypes.getFileTypePatterns("indexable-content"));
        this.includes.addAll(this.filetypes.getFileTypePatterns("artifacts"));
    }

    public void initialize() throws InitializationException {
        this.configuration.addChangeListener((RegistryListener)this);
        this.initIncludes();
    }

    public List<String> getIncludes() {
        return this.includes;
    }
}

