/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.lucene;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.common.plexusbridge.MavenIndexerUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationNames;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.archiva.redback.components.taskqueue.Task;
import org.apache.archiva.redback.components.taskqueue.TaskQueueException;
import org.apache.archiva.scheduler.ArchivaTaskScheduler;
import org.apache.archiva.scheduler.indexing.ArtifactIndexingTask;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="knownRepositoryContentConsumer#index-content")
@Scope(value="prototype")
public class NexusIndexerConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer,
RegistryListener {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ArchivaConfiguration configuration;
    private FileTypes filetypes;
    private File managedRepository;
    private ArchivaTaskScheduler<ArtifactIndexingTask> scheduler;
    private IndexingContext indexingContext;
    private NexusIndexer nexusIndexer;
    private List<String> includes = new ArrayList<String>(0);
    private ManagedRepository repository;
    private List<? extends IndexCreator> allIndexCreators;
    private ManagedRepositoryAdmin managedRepositoryAdmin;

    @Inject
    public NexusIndexerConsumer(@Named(value="archivaTaskScheduler#indexing") ArchivaTaskScheduler<ArtifactIndexingTask> scheduler, @Named(value="archivaConfiguration") ArchivaConfiguration configuration, FileTypes filetypes, PlexusSisuBridge plexusSisuBridge, MavenIndexerUtils mavenIndexerUtils, ManagedRepositoryAdmin managedRepositoryAdmin) throws PlexusSisuBridgeException {
        this.configuration = configuration;
        this.filetypes = filetypes;
        this.scheduler = scheduler;
        this.nexusIndexer = (NexusIndexer)plexusSisuBridge.lookup(NexusIndexer.class);
        this.allIndexCreators = mavenIndexerUtils.getAllIndexCreators();
        this.managedRepositoryAdmin = managedRepositoryAdmin;
    }

    public String getDescription() {
        return "Indexes the repository to provide search and IDE integration features";
    }

    public String getId() {
        return "index-content";
    }

    public void beginScan(ManagedRepository repository, Date whenGathered) throws ConsumerException {
        this.repository = repository;
        this.managedRepository = new File(repository.getLocation());
        try {
            this.log.info("Creating indexing context for repo : {}", (Object)repository.getId());
            this.indexingContext = this.managedRepositoryAdmin.createIndexContext(repository);
        }
        catch (RepositoryAdminException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
    }

    public void beginScan(ManagedRepository repository, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        if (executeOnEntireRepo) {
            this.beginScan(repository, whenGathered);
        } else {
            this.repository = repository;
            this.managedRepository = new File(repository.getLocation());
        }
    }

    public void processFile(String path) throws ConsumerException {
        File artifactFile = new File(this.managedRepository, path);
        ArtifactIndexingTask task = new ArtifactIndexingTask(this.repository, artifactFile, ArtifactIndexingTask.Action.ADD, this.getIndexingContext());
        try {
            this.log.debug("Queueing indexing task '{}' to add or update the artifact in the index.", (Object)task);
            this.scheduler.queueTask((Task)task);
        }
        catch (TaskQueueException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws Exception {
        if (executeOnEntireRepo) {
            this.processFile(path);
        } else {
            File artifactFile = new File(this.managedRepository, path);
            ArtifactIndexingTask task = new ArtifactIndexingTask(this.repository, artifactFile, ArtifactIndexingTask.Action.ADD, this.getIndexingContext(), false);
            task.setOnlyUpdate(true);
            try {
                this.log.debug("Queueing indexing task '{}' to add or update the artifact in the index.", (Object)task);
                this.scheduler.queueTask((Task)task);
            }
            catch (TaskQueueException e) {
                throw new ConsumerException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void completeScan() {
        IndexingContext context = this.indexingContext;
        if (context == null) {
            try {
                context = this.getIndexingContext();
            }
            catch (ConsumerException e) {
                this.log.warn("failed to get an IndexingContext:{}", (Object)e.getMessage());
                return;
            }
        }
        ArtifactIndexingTask task = new ArtifactIndexingTask(this.repository, null, ArtifactIndexingTask.Action.FINISH, context);
        try {
            this.log.debug("Queueing indexing task '{}' to finish indexing.", (Object)task);
            this.scheduler.queueTask((Task)task);
        }
        catch (TaskQueueException e) {
            this.log.error("Error queueing task: " + task + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void completeScan(boolean executeOnEntireRepo) {
        if (executeOnEntireRepo) {
            this.completeScan();
        }
    }

    public List<String> getExcludes() {
        return Collections.emptyList();
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isRepositoryScanning((String)propertyName)) {
            this.initIncludes();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    private void initIncludes() {
        List indexable = this.filetypes.getFileTypePatterns("indexable-content");
        List artifacts = this.filetypes.getFileTypePatterns("artifacts");
        this.includes = new ArrayList<String>(indexable.size() + artifacts.size());
        this.includes.addAll(indexable);
        this.includes.addAll(artifacts);
    }

    @PostConstruct
    public void initialize() {
        this.configuration.addChangeListener((RegistryListener)this);
        this.initIncludes();
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    private IndexingContext getIndexingContext() throws ConsumerException {
        if (this.indexingContext == null) {
            try {
                this.indexingContext = this.managedRepositoryAdmin.createIndexContext(this.repository);
            }
            catch (RepositoryAdminException e) {
                throw new ConsumerException(e.getMessage(), (Throwable)e);
            }
        }
        return this.indexingContext;
    }
}

