/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.metadata;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationNames;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.ProjectMetadata;
import org.apache.archiva.metadata.model.ProjectVersionMetadata;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.metadata.repository.storage.RepositoryStorage;
import org.apache.archiva.metadata.repository.storage.RepositoryStorageMetadataInvalidException;
import org.apache.archiva.metadata.repository.storage.RepositoryStorageMetadataNotFoundException;
import org.apache.archiva.metadata.repository.storage.RepositoryStorageRuntimeException;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="knownRepositoryContentConsumer#create-archiva-metadata")
@Scope(value="prototype")
public class ArchivaMetadataCreationConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer,
RegistryListener {
    private String id = "create-archiva-metadata";
    private String description = "Create basic metadata for Archiva to be able to reference the artifact";
    @Inject
    private ArchivaConfiguration configuration;
    @Inject
    private FileTypes filetypes;
    private Date whenGathered;
    private List<String> includes = new ArrayList<String>(0);
    @Inject
    private RepositorySessionFactory repositorySessionFactory;
    @Inject
    @Named(value="repositoryStorage#maven2")
    private RepositoryStorage repositoryStorage;
    private static final Logger log = LoggerFactory.getLogger(ArchivaMetadataCreationConsumer.class);
    private String repoId;

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPermanent() {
        return true;
    }

    public List<String> getExcludes() {
        return this.getDefaultArtifactExclusions();
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void beginScan(ManagedRepository repo, Date whenGathered) throws ConsumerException {
        this.repoId = repo.getId();
        this.whenGathered = whenGathered;
    }

    public void beginScan(ManagedRepository repository, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        this.beginScan(repository, whenGathered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFile(String path) throws ConsumerException {
        RepositorySession repositorySession = this.repositorySessionFactory.createSession();
        try {
            ArtifactMetadata artifact = this.repositoryStorage.readArtifactMetadataFromPath(this.repoId, path);
            ProjectMetadata project = new ProjectMetadata();
            project.setNamespace(artifact.getNamespace());
            project.setId(artifact.getProject());
            String projectVersion = VersionUtil.getBaseVersion((String)artifact.getVersion());
            MetadataRepository metadataRepository = repositorySession.getRepository();
            boolean createVersionMetadata = false;
            ProjectVersionMetadata versionMetadata = null;
            try {
                versionMetadata = this.repositoryStorage.readProjectVersionMetadata(this.repoId, artifact.getNamespace(), artifact.getProject(), projectVersion);
                createVersionMetadata = true;
            }
            catch (RepositoryStorageMetadataNotFoundException e) {
                log.warn("Missing or invalid POM for artifact:{} (repository:{}); creating empty metadata", (Object)path, (Object)this.repoId);
                versionMetadata = new ProjectVersionMetadata();
                versionMetadata.setId(projectVersion);
                versionMetadata.setIncomplete(true);
                createVersionMetadata = true;
            }
            catch (RepositoryStorageMetadataInvalidException e) {
                log.warn("Error occurred resolving POM for artifact:{} (repository:{}); message: {}", new Object[]{path, this.repoId, e.getMessage()});
            }
            artifact.setWhenGathered(this.whenGathered);
            metadataRepository.updateArtifact(this.repoId, project.getNamespace(), project.getId(), projectVersion, artifact);
            if (createVersionMetadata) {
                metadataRepository.updateProjectVersion(this.repoId, project.getNamespace(), project.getId(), versionMetadata);
            }
            metadataRepository.updateProject(this.repoId, project);
            repositorySession.save();
        }
        catch (MetadataRepositoryException e) {
            log.warn("Error occurred persisting metadata for artifact:{} (repository:{}); message: {}" + e.getMessage(), (Object)new Object[]{path, this.repoId, e.getMessage()}, (Object)e);
            repositorySession.revert();
        }
        catch (RepositoryStorageRuntimeException e) {
            log.warn("Error occurred persisting metadata for artifact:{} (repository:{}); message: {}" + e.getMessage(), (Object)new Object[]{path, this.repoId, e.getMessage()}, (Object)e);
            repositorySession.revert();
        }
        finally {
            repositorySession.close();
        }
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws ConsumerException {
        this.processFile(path);
    }

    public void completeScan() {
    }

    public void completeScan(boolean executeOnEntireRepo) {
        this.completeScan();
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isRepositoryScanning((String)propertyName)) {
            this.initIncludes();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    private void initIncludes() {
        this.includes = new ArrayList<String>(this.filetypes.getFileTypePatterns("artifacts"));
    }

    @PostConstruct
    public void initialize() {
        this.configuration.addChangeListener((RegistryListener)this);
        this.initIncludes();
    }
}

