/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Description of a person who has contributed to the
 * project.
 *         This includes contributors and commitors.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Individual
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The generated id for the object. Due to problems in
     * upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     */
    private String email;

    /**
     * The email address of the individual.
     */
    private String individualEmail;

    /**
     * The full name of the individual.
     */
    private String name;

    /**
     * 
     *             The RedBack (plexus security) principal
     * associated with this Invididual.
     *           
     */
    private String principal;

    /**
     * 
     *             The flag if this user is a developer and/or
     * commitor.
     *           
     */
    private boolean commitor = false;

    /**
     * The URL for the homepage of the individual.
     */
    private String url;

    /**
     * The organization to which the individual belongs.
     */
    private String organization;

    /**
     * The URL of the organization.
     */
    private String organizationUrl;

    /**
     * Field roles.
     */
    private java.util.List<String> roles;

    /**
     * 
     *             The timezone the individual is in. This is a
     * number in the range -11 to 12.
     *           
     */
    private String timezone;

    /**
     * Field properties.
     */
    private java.util.Properties properties;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addProperty.
     * 
     * @param key
     * @param value
     */
    public void addProperty( String key, String value )
    {
        getProperties().put( key, value );
    } //-- void addProperty( String, String )

    /**
     * Method addRole.
     * 
     * @param string
     */
    public void addRole( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Individual.addRoles(string) parameter must be instanceof " + String.class.getName() );
        }
        getRoles().add( string );
    } //-- void addRole( String )

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof Individual ) )
        {
            return false;
        }

        Individual that = (Individual) other;
        boolean result = true;

        result = result && ( getEmail() == null ? that.getEmail() == null : getEmail().equals( that.getEmail() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get the generated id for the object. Due to problems in
     * upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     * 
     * @return String
     */
    public String getEmail()
    {
        return this.email;
    } //-- String getEmail()

    /**
     * Get the email address of the individual.
     * 
     * @return String
     */
    public String getIndividualEmail()
    {
        return this.individualEmail;
    } //-- String getIndividualEmail()

    /**
     * Get the full name of the individual.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get the organization to which the individual belongs.
     * 
     * @return String
     */
    public String getOrganization()
    {
        return this.organization;
    } //-- String getOrganization()

    /**
     * Get the URL of the organization.
     * 
     * @return String
     */
    public String getOrganizationUrl()
    {
        return this.organizationUrl;
    } //-- String getOrganizationUrl()

    /**
     * Get 
     *             The RedBack (plexus security) principal
     * associated with this Invididual.
     *           
     * 
     * @return String
     */
    public String getPrincipal()
    {
        return this.principal;
    } //-- String getPrincipal()

    /**
     * Method getProperties.
     * 
     * @return Properties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }

        return this.properties;
    } //-- java.util.Properties getProperties()

    /**
     * Method getRoles.
     * 
     * @return List
     */
    public java.util.List<String> getRoles()
    {
        if ( this.roles == null )
        {
            this.roles = new java.util.ArrayList<String>();
        }

        return this.roles;
    } //-- java.util.List<String> getRoles()

    /**
     * Get 
     *             The timezone the individual is in. This is a
     * number in the range -11 to 12.
     *           
     * 
     * @return String
     */
    public String getTimezone()
    {
        return this.timezone;
    } //-- String getTimezone()

    /**
     * Get the URL for the homepage of the individual.
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( email != null ? email.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Get 
     *             The flag if this user is a developer and/or
     * commitor.
     *           
     * 
     * @return boolean
     */
    public boolean isCommitor()
    {
        return this.commitor;
    } //-- boolean isCommitor()

    /**
     * Method removeRole.
     * 
     * @param string
     */
    public void removeRole( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Individual.removeRoles(string) parameter must be instanceof " + String.class.getName() );
        }
        getRoles().remove( string );
    } //-- void removeRole( String )

    /**
     * Set 
     *             The flag if this user is a developer and/or
     * commitor.
     *           
     * 
     * @param commitor
     */
    public void setCommitor( boolean commitor )
    {
        this.commitor = commitor;
    } //-- void setCommitor( boolean )

    /**
     * Set the generated id for the object. Due to problems in
     * upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     * 
     * @param email
     */
    public void setEmail( String email )
    {
        this.email = email;
    } //-- void setEmail( String )

    /**
     * Set the email address of the individual.
     * 
     * @param individualEmail
     */
    public void setIndividualEmail( String individualEmail )
    {
        this.individualEmail = individualEmail;
    } //-- void setIndividualEmail( String )

    /**
     * Set the full name of the individual.
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set the organization to which the individual belongs.
     * 
     * @param organization
     */
    public void setOrganization( String organization )
    {
        this.organization = organization;
    } //-- void setOrganization( String )

    /**
     * Set the URL of the organization.
     * 
     * @param organizationUrl
     */
    public void setOrganizationUrl( String organizationUrl )
    {
        this.organizationUrl = organizationUrl;
    } //-- void setOrganizationUrl( String )

    /**
     * Set 
     *             The RedBack (plexus security) principal
     * associated with this Invididual.
     *           
     * 
     * @param principal
     */
    public void setPrincipal( String principal )
    {
        this.principal = principal;
    } //-- void setPrincipal( String )

    /**
     * Set 
     *             Properties about the individual, such as an
     * instant messenger handle.
     *           
     * 
     * @param properties
     */
    public void setProperties( java.util.Properties properties )
    {
        this.properties = properties;
    } //-- void setProperties( java.util.Properties )

    /**
     * Set 
     *             The roles the individual plays in the project. 
     * Each role is
     *             described by a <code>role</code> element, the
     * body of which is a
     *             role name. This can also be used to describe the
     * contribution.
     *           
     * 
     * @param roles
     */
    public void setRoles( java.util.List<String> roles )
    {
        this.roles = roles;
    } //-- void setRoles( java.util.List )

    /**
     * Set 
     *             The timezone the individual is in. This is a
     * number in the range -11 to 12.
     *           
     * 
     * @param timezone
     */
    public void setTimezone( String timezone )
    {
        this.timezone = timezone;
    } //-- void setTimezone( String )

    /**
     * Set the URL for the homepage of the individual.
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "email = '" );
        buf.append( getEmail() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


    private static final long serialVersionUID = -3847642264665088605L;
          
}
