package org.apache.maven.archiva.model.jpox;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.model.AbstractVersionedKey;

import java.io.Serializable;

/**
 * ArchivaProjectModelKey - unique classid-key for JPOX. 
 *
 * @version $Id: ArchivaProjectModelKey.java 718864 2008-11-19 06:33:35Z brett $
 */
public class ArchivaProjectModelKey
    extends AbstractVersionedKey
    implements Serializable
{
    private static final long serialVersionUID = 7789859208617327581L;

    public ArchivaProjectModelKey()
    {
    }

    public ArchivaProjectModelKey( String key )
    {
        super( key );
    }

}
