/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class RepositoryContentStatistics.
 * 
 * @version $Revision$ $Date$
 */
public class RepositoryContentStatistics
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The repository id the statistics belong to.
     *           
     */
    private String repositoryId;

    /**
     * 
     *             The timestamp on when this set of statistics was
     * gathered.
     *           
     */
    private java.util.Date whenGathered;

    /**
     * 
     *             The duration (in milliseconds) for the gathering
     * of the statistics.
     *           
     */
    private long duration = 0L;

    /**
     * 
     *             The total number of files in the repository.
     *           
     */
    private long totalFileCount = 0L;

    /**
     * 
     *             The number of new files discovered.
     *           
     */
    private long newFileCount = 0L;

    /**
     * 
     *             The total number of unique projects in the
     * repository.
     *           
     */
    private long totalProjectCount = 0L;

    /**
     * 
     *             The total number of unique groups in the
     * repository.
     *           
     */
    private long totalGroupCount = 0L;

    /**
     * 
     *             The total number of artifacts in the repository.
     * 
     *           
     */
    private long totalArtifactCount = 0L;

    /**
     * 
     *             The total size in bytes of the repository.
     *           
     */
    private long totalSize = 0L;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The duration (in milliseconds) for the gathering
     * of the statistics.
     *           
     * 
     * @return long
     */
    public long getDuration()
    {
        return this.duration;
    } //-- long getDuration()

    /**
     * Get 
     *             The number of new files discovered.
     *           
     * 
     * @return long
     */
    public long getNewFileCount()
    {
        return this.newFileCount;
    } //-- long getNewFileCount()

    /**
     * Get 
     *             The repository id the statistics belong to.
     *           
     * 
     * @return String
     */
    public String getRepositoryId()
    {
        return this.repositoryId;
    } //-- String getRepositoryId()

    /**
     * Get 
     *             The total number of artifacts in the repository.
     * 
     *           
     * 
     * @return long
     */
    public long getTotalArtifactCount()
    {
        return this.totalArtifactCount;
    } //-- long getTotalArtifactCount()

    /**
     * Get 
     *             The total number of files in the repository.
     *           
     * 
     * @return long
     */
    public long getTotalFileCount()
    {
        return this.totalFileCount;
    } //-- long getTotalFileCount()

    /**
     * Get 
     *             The total number of unique groups in the
     * repository.
     *           
     * 
     * @return long
     */
    public long getTotalGroupCount()
    {
        return this.totalGroupCount;
    } //-- long getTotalGroupCount()

    /**
     * Get 
     *             The total number of unique projects in the
     * repository.
     *           
     * 
     * @return long
     */
    public long getTotalProjectCount()
    {
        return this.totalProjectCount;
    } //-- long getTotalProjectCount()

    /**
     * Get 
     *             The total size in bytes of the repository.
     *           
     * 
     * @return long
     */
    public long getTotalSize()
    {
        return this.totalSize;
    } //-- long getTotalSize()

    /**
     * Get 
     *             The timestamp on when this set of statistics was
     * gathered.
     *           
     * 
     * @return Date
     */
    public java.util.Date getWhenGathered()
    {
        return this.whenGathered;
    } //-- java.util.Date getWhenGathered()

    /**
     * Set 
     *             The duration (in milliseconds) for the gathering
     * of the statistics.
     *           
     * 
     * @param duration
     */
    public void setDuration( long duration )
    {
        this.duration = duration;
    } //-- void setDuration( long )

    /**
     * Set 
     *             The number of new files discovered.
     *           
     * 
     * @param newFileCount
     */
    public void setNewFileCount( long newFileCount )
    {
        this.newFileCount = newFileCount;
    } //-- void setNewFileCount( long )

    /**
     * Set 
     *             The repository id the statistics belong to.
     *           
     * 
     * @param repositoryId
     */
    public void setRepositoryId( String repositoryId )
    {
        this.repositoryId = repositoryId;
    } //-- void setRepositoryId( String )

    /**
     * Set 
     *             The total number of artifacts in the repository.
     * 
     *           
     * 
     * @param totalArtifactCount
     */
    public void setTotalArtifactCount( long totalArtifactCount )
    {
        this.totalArtifactCount = totalArtifactCount;
    } //-- void setTotalArtifactCount( long )

    /**
     * Set 
     *             The total number of files in the repository.
     *           
     * 
     * @param totalFileCount
     */
    public void setTotalFileCount( long totalFileCount )
    {
        this.totalFileCount = totalFileCount;
    } //-- void setTotalFileCount( long )

    /**
     * Set 
     *             The total number of unique groups in the
     * repository.
     *           
     * 
     * @param totalGroupCount
     */
    public void setTotalGroupCount( long totalGroupCount )
    {
        this.totalGroupCount = totalGroupCount;
    } //-- void setTotalGroupCount( long )

    /**
     * Set 
     *             The total number of unique projects in the
     * repository.
     *           
     * 
     * @param totalProjectCount
     */
    public void setTotalProjectCount( long totalProjectCount )
    {
        this.totalProjectCount = totalProjectCount;
    } //-- void setTotalProjectCount( long )

    /**
     * Set 
     *             The total size in bytes of the repository.
     *           
     * 
     * @param totalSize
     */
    public void setTotalSize( long totalSize )
    {
        this.totalSize = totalSize;
    } //-- void setTotalSize( long )

    /**
     * Set 
     *             The timestamp on when this set of statistics was
     * gathered.
     *           
     * 
     * @param whenGathered
     */
    public void setWhenGathered( java.util.Date whenGathered )
    {
        this.whenGathered = whenGathered;
    } //-- void setWhenGathered( java.util.Date )


    private static final long serialVersionUID = -7113629916828442780L;
          
}
