/*
 * $Id$
 */

package org.apache.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         This object is only used for the XML backup / restore
 * features of Archiva.
 *         This object is not serialized to the Database.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ArchivaAll
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field artifacts.
     */
    private java.util.List<ArchivaArtifactModel> artifacts;

    /**
     * Field repositoryMetadata.
     */
    private java.util.List<ArchivaRepositoryMetadata> repositoryMetadata;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addArtifact.
     * 
     * @param archivaArtifactModel
     */
    public void addArtifact( ArchivaArtifactModel archivaArtifactModel )
    {
        if ( !(archivaArtifactModel instanceof ArchivaArtifactModel) )
        {
            throw new ClassCastException( "ArchivaAll.addArtifacts(archivaArtifactModel) parameter must be instanceof " + ArchivaArtifactModel.class.getName() );
        }
        getArtifacts().add( archivaArtifactModel );
    } //-- void addArtifact( ArchivaArtifactModel )

    /**
     * Method addRepositoryMetadata.
     * 
     * @param archivaRepositoryMetadata
     */
    public void addRepositoryMetadata( ArchivaRepositoryMetadata archivaRepositoryMetadata )
    {
        if ( !(archivaRepositoryMetadata instanceof ArchivaRepositoryMetadata) )
        {
            throw new ClassCastException( "ArchivaAll.addRepositoryMetadata(archivaRepositoryMetadata) parameter must be instanceof " + ArchivaRepositoryMetadata.class.getName() );
        }
        getRepositoryMetadata().add( archivaRepositoryMetadata );
    } //-- void addRepositoryMetadata( ArchivaRepositoryMetadata )

    /**
     * Method getArtifacts.
     * 
     * @return List
     */
    public java.util.List<ArchivaArtifactModel> getArtifacts()
    {
        if ( this.artifacts == null )
        {
            this.artifacts = new java.util.ArrayList<ArchivaArtifactModel>();
        }

        return this.artifacts;
    } //-- java.util.List<ArchivaArtifactModel> getArtifacts()

    /**
     * Method getModelEncoding.
     * 
     * @return the current encoding used when reading/writing this
     * model
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Method getRepositoryMetadata.
     * 
     * @return List
     */
    public java.util.List<ArchivaRepositoryMetadata> getRepositoryMetadata()
    {
        if ( this.repositoryMetadata == null )
        {
            this.repositoryMetadata = new java.util.ArrayList<ArchivaRepositoryMetadata>();
        }

        return this.repositoryMetadata;
    } //-- java.util.List<ArchivaRepositoryMetadata> getRepositoryMetadata()

    /**
     * Method removeArtifact.
     * 
     * @param archivaArtifactModel
     */
    public void removeArtifact( ArchivaArtifactModel archivaArtifactModel )
    {
        if ( !(archivaArtifactModel instanceof ArchivaArtifactModel) )
        {
            throw new ClassCastException( "ArchivaAll.removeArtifacts(archivaArtifactModel) parameter must be instanceof " + ArchivaArtifactModel.class.getName() );
        }
        getArtifacts().remove( archivaArtifactModel );
    } //-- void removeArtifact( ArchivaArtifactModel )

    /**
     * Method removeRepositoryMetadata.
     * 
     * @param archivaRepositoryMetadata
     */
    public void removeRepositoryMetadata( ArchivaRepositoryMetadata archivaRepositoryMetadata )
    {
        if ( !(archivaRepositoryMetadata instanceof ArchivaRepositoryMetadata) )
        {
            throw new ClassCastException( "ArchivaAll.removeRepositoryMetadata(archivaRepositoryMetadata) parameter must be instanceof " + ArchivaRepositoryMetadata.class.getName() );
        }
        getRepositoryMetadata().remove( archivaRepositoryMetadata );
    } //-- void removeRepositoryMetadata( ArchivaRepositoryMetadata )

    /**
     * Set the artifacts field.
     * 
     * @param artifacts
     */
    public void setArtifacts( java.util.List<ArchivaArtifactModel> artifacts )
    {
        this.artifacts = artifacts;
    } //-- void setArtifacts( java.util.List )

    /**
     * Set an encoding used for reading/writing the model.
     * 
     * @param modelEncoding
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set the repositoryMetadata field.
     * 
     * @param repositoryMetadata
     */
    public void setRepositoryMetadata( java.util.List<ArchivaRepositoryMetadata> repositoryMetadata )
    {
        this.repositoryMetadata = repositoryMetadata;
    } //-- void setRepositoryMetadata( java.util.List )


    private static final long serialVersionUID = 3259707008803111764L;
          
}
