/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.policies;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.common.utils.VersionUtil;
import org.apache.maven.archiva.policies.PolicyConfigurationException;
import org.apache.maven.archiva.policies.PolicyViolationException;
import org.apache.maven.archiva.policies.PreDownloadPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUpdatePolicy
implements PreDownloadPolicy {
    private Logger log = LoggerFactory.getLogger(AbstractUpdatePolicy.class);
    public static final String ALWAYS = "always";
    public static final String NEVER = "never";
    public static final String DAILY = "daily";
    public static final String HOURLY = "hourly";
    public static final String ONCE = "once";
    private List<String> options = new ArrayList<String>();

    public AbstractUpdatePolicy() {
        this.options.add(ALWAYS);
        this.options.add(HOURLY);
        this.options.add(DAILY);
        this.options.add(ONCE);
        this.options.add(NEVER);
    }

    protected abstract boolean isSnapshotPolicy();

    protected abstract String getUpdateMode();

    @Override
    public List<String> getOptions() {
        return this.options;
    }

    @Override
    public void applyPolicy(String policySetting, Properties request, File localFile) throws PolicyViolationException, PolicyConfigurationException {
        if (!StringUtils.equals((String)request.getProperty("filetype"), (String)"artifact")) {
            return;
        }
        String version = request.getProperty("version", "");
        boolean isSnapshotVersion = false;
        if (StringUtils.isNotBlank((String)version)) {
            isSnapshotVersion = VersionUtil.isSnapshot((String)version);
        }
        if (!this.options.contains(policySetting)) {
            throw new PolicyConfigurationException("Unknown " + this.getUpdateMode() + " policy setting [" + policySetting + "], valid settings are [" + StringUtils.join(this.options.iterator(), (String)",") + "]");
        }
        if (ALWAYS.equals(policySetting)) {
            this.log.debug("OK to update, " + this.getUpdateMode() + " policy set to ALWAYS.");
            return;
        }
        if (!isSnapshotVersion && this.isSnapshotPolicy()) {
            this.log.debug("OK to update, snapshot policy does not apply for non-snapshot versions.");
            return;
        }
        if (isSnapshotVersion && !this.isSnapshotPolicy()) {
            this.log.debug("OK to update, release policy does not apply for snapshot versions.");
            return;
        }
        if (NEVER.equals(policySetting)) {
            throw new PolicyViolationException("NO to update, " + this.getUpdateMode() + " policy set to NEVER.");
        }
        if (!localFile.exists()) {
            this.log.debug("OK to update " + this.getUpdateMode() + ", local file does not exist.");
            return;
        }
        if (ONCE.equals(policySetting)) {
            throw new PolicyViolationException("NO to update " + this.getUpdateMode() + ", policy is ONCE, and local file exist.");
        }
        if (DAILY.equals(policySetting)) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            Calendar fileCal = Calendar.getInstance();
            fileCal.setTimeInMillis(localFile.lastModified());
            if (cal.after(fileCal)) {
                return;
            }
            throw new PolicyViolationException("NO to update " + this.getUpdateMode() + ", policy is DAILY, local file exist, and has been updated within the last day.");
        }
        if (HOURLY.equals(policySetting)) {
            Calendar cal = Calendar.getInstance();
            cal.add(10, -1);
            Calendar fileCal = Calendar.getInstance();
            fileCal.setTimeInMillis(localFile.lastModified());
            if (cal.after(fileCal)) {
                return;
            }
            throw new PolicyViolationException("NO to update " + this.getUpdateMode() + ", policy is HOURLY, local file exist, and has been updated within the last hour.");
        }
        throw new PolicyConfigurationException("Unable to process " + this.getUpdateMode() + " policy of [" + policySetting + "], please file a bug report.");
    }
}

