/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.policies;

import java.util.Collections;
import java.util.Map;
import org.apache.maven.archiva.common.ArchivaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyDownloadException
extends ArchivaException {
    private final Map<String, Exception> failures;

    public ProxyDownloadException(String message, String repositoryId, Exception cause) {
        super(ProxyDownloadException.constructMessage(message, Collections.singletonMap(repositoryId, cause)), (Throwable)cause);
        this.failures = Collections.singletonMap(repositoryId, cause);
    }

    public ProxyDownloadException(String message, Map<String, Exception> failures) {
        super(ProxyDownloadException.constructMessage(message, failures));
        this.failures = failures;
    }

    private static String constructMessage(String message, Map<String, Exception> failures) {
        String msg = message + ":";
        for (Map.Entry<String, Exception> entry : failures.entrySet()) {
            msg = msg + "\n\t" + entry.getKey() + ": " + entry.getValue().getMessage();
        }
        return msg;
    }

    public Map<String, Exception> getFailures() {
        return this.failures;
    }
}

